import {EventEmitter, Injectable, Output} from '@angular/core';
import {map} from 'rxjs/operators';
import {HttpClient} from '@angular/common/http';
import {Observable} from 'rxjs';
import { Question } from './question';

@Injectable({
  providedIn: 'root'
})

export class QuestionService {

  uploadUrl = "http://localhost/sfcode/backend/questions/question_save.php/";
  getUrl = "http://localhost/sfcode/backend/questions/get_questions.php/";

  constructor(private http: HttpClient) { }

  uploadQues(ques: Question): void {
    this.http.post(this.uploadUrl, ques);
  }

  getQues(): Observable<any[]> {
    return this.http.get<any[]>(this.getUrl);
  }

}
