import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
declare const CodeMirror: any;

@Component({
  selector: 'app-ide',
  templateUrl: './ide.component.html',
  styleUrls: ['./ide.component.scss']
})
export class IdeComponent implements OnInit {

  constructor(public router: Router) { }

  ngOnInit(): void {
    const editorArea = document.getElementById('editor');
    const editor = CodeMirror.fromTextArea(editorArea as HTMLTextAreaElement, {
      lineNumbers: true,
      theme: 'material-ocean',
      mode: 'text/x-c++src',
      autoCloseBrackets: true,
      matchBrackets: true
    });
    editor.setSize('auto', '70vh');
    Object.assign((document.getElementsByClassName('CodeMirror')[0] as HTMLTextAreaElement).style, {
      border: '2px solid #ddf',
      padding: '20px',
      fontFamily: '"Anonymous Pro", monospace',
    });

    let activeLang = 0;
    const langs = ['C++', 'Python', 'Java'];
    const langsMime = ['text/x-c++src', 'text/x-python', 'text/x-java'];
    const defaultCode = [`#include <iostream>
using namespace std;

int main() {
  cout << "Hello World!\\n";
  return 0;
}`, `print("Hello World!")`, `class HelloWorld {
    public static void main(String[] args) {
        System.out.println("Hello, World!");
    }
}`];

    editor.setValue(defaultCode[activeLang]);
    document.getElementById('toggle-lang').onclick = function(): void {
      const th = this as HTMLDivElement;
      activeLang = (activeLang + 1) % 3;
      th.innerHTML = langs[activeLang];
      editor.setValue(defaultCode[activeLang]);
      editor.setOption('mode', langsMime[activeLang]);
    };

  }

}
