import {Injectable} from '@angular/core';
// import {Problem} from './problem';
import {Question} from './question';
import {File} from './file';
import {Observable, of, throwError} from 'rxjs';
import {HttpClient} from '@angular/common/http';

@Injectable({
  providedIn: 'root'
})
export class RunCodeService {

  runStatus = 'Compiling...';
  result = 0;
  private baseUrl = 'http://localhost/sfcode/backend/';

  constructor(private httpClient: HttpClient) {
  }

  compileFile(file: File): Observable<any> {
    return this.httpClient.post(this.baseUrl + 'compile.php', file);
  }

  executeFile(file: File, input: string): Observable<any> {
    return this.httpClient.post(this.baseUrl + 'execute.php', {
      file,
      input_data: input
    });
  }

  // compileProblemFile(prob: Problem): Observable<any> {
  //   if (Math.floor(Math.random() * 2) === 1) {return of('done'); }
  //   else {return throwError('error'); }
  // }

  verifyTestcase(file: File, out: string, ind: number, isSubmit: number): Observable<any> {
    return this.httpClient.post(this.baseUrl + 'questions/check_output.php', {
      title: file.filename,
      username: file.username,
      out,
      ind,
      isSubmit
    });
  }

  update(b: boolean): Observable<any> {
    return this.httpClient.put(this.baseUrl + 'update_correct.php', {b});
  }

  compileQuestionFile(ques: Question, code: string[]): Observable<any> {
    if (Math.floor(Math.random() * 2) === 1) {return of('done'); }
    else {return throwError('error'); }
  }
}
