import numpy as np
import pygame
import sys
from tkinter import *
from tkinter import messagebox


#Constants
ROW = 6
COLUMN = 7
WIDTH, HEIGHT = 700, 750
WINDOW = pygame.display.set_mode((WIDTH, HEIGHT))
pygame.display.set_caption("Connect 4")
FPS = 60
SQUARESIZE = 100



#Global variable
player1_score = 0
player2_score = 0

# score location of player-1 and player-2
SCORE_PLAYER1_X = 5
SCORE_PLAYER1_Y = 710
SCORE_PLAYER2_X = 550
SCORE_PLAYER2_Y = 710

# Color used
BLUE = (0, 0, 255)
WHITE = (255, 255, 255)
BLACK = (0, 0, 0)
RED = (255, 0, 0)
YELLOW = (255, 255, 0)
WOOD = (249, 248, 246)
BLOODRED = (238,75,43)


def playing_board():
    return (np.zeros((ROW, COLUMN)))


def is_valid_location(board, column):
    return board[5][column] == 0


# This function will return the row number where Square will fill after clicking
def get_block_filling_location(board, column):
    for row in range(ROW):
        if (board[row][column] == 0):
            return row


def winner(board, squareBlock):
    # horizontal checkup
    for j in range(COLUMN - 3):
        for i in range(ROW):
            if (board[i][j] == squareBlock and board[i][j + 1] == squareBlock and board[i][j + 2] == squareBlock and
                    board[i][j + 3] == squareBlock):
                return True

    # vertical checkup
    for j in range(COLUMN):
        for i in range(ROW - 3):
            if (board[i][j] == squareBlock and board[i + 1][j] == squareBlock and board[i + 2][j] == squareBlock and
                    board[i + 3][j] == squareBlock):
                return True

    # Diagonal checkup
    for j in range(COLUMN - 3):
        for i in range(ROW - 3):
            if (board[i][j] == squareBlock and board[i + 1][j + 1] == squareBlock and board[i + 2][
                j + 2] == squareBlock and board[i + 3][j + 3] == squareBlock):
                return True

    for j in range(COLUMN - 3):
        for i in range(3, ROW):
            if (board[i][j] == squareBlock and board[i - 1][j + 1] == squareBlock and board[i - 2][
                j + 2] == squareBlock and board[i - 3][j + 3] == squareBlock):
                return True


def show_score(x1, y1, x2, y2):
    font_player1 = pygame.font.SysFont("arial", 20)
    font_player2 = pygame.font.SysFont("arial", 20)
    score1 = font_player1.render("Player 1 score: " + str(player1_score), True, BLOODRED)
    WINDOW.blit(score1, (x1, y1))
    score2 = font_player2.render("Player 2 score: " + str(player2_score), True, BLOODRED)
    WINDOW.blit(score2, (x2, y2))
    pygame.display.update()


def draw_window(board):
    global player1_score
    global player2_score
    pygame.init()
    for j in range(COLUMN):
        for i in range(ROW):
            pygame.draw.rect(WINDOW, WOOD, (j * SQUARESIZE, (i + 1) * SQUARESIZE, SQUARESIZE, SQUARESIZE))
            pygame.draw.line(WINDOW, BLACK, (SQUARESIZE + i * SQUARESIZE, SQUARESIZE),
                             ((i + 1) * SQUARESIZE, COLUMN * SQUARESIZE), width=3)

    for i in range(ROW):
        pygame.draw.line(WINDOW, BLACK, (0, (i + 1) * SQUARESIZE), (WIDTH, (i + 1) * SQUARESIZE), width=3)

    for j in range(COLUMN):
        for i in range(ROW):
            if (board[i][j] == 1):
                pygame.draw.rect(WINDOW, BLUE, (
                int(j * (SQUARESIZE) + 1), HEIGHT - int((i + 1) * SQUARESIZE + (SQUARESIZE / 2 - 1)), SQUARESIZE - 2,
                SQUARESIZE - 2))
            if (board[i][j] == 2):
                pygame.draw.rect(WINDOW, YELLOW, (
                int(j * (SQUARESIZE) + 1), HEIGHT - int((i + 1) * (SQUARESIZE) + (SQUARESIZE / 2 - 1)), SQUARESIZE - 2,
                SQUARESIZE - 2))
    pygame.display.update()


def main():
    global player1_score
    global player2_score
    player1_winner_flag = False
    player2_winner_flag = False
    board = playing_board()
    gameExit = False
    player_turn = 0
    clock = pygame.time.Clock()
    draw_window(board)
    show_score(SCORE_PLAYER1_X, SCORE_PLAYER1_Y, SCORE_PLAYER2_X, SCORE_PLAYER2_Y)

    while not gameExit:
        clock.tick(FPS)
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                Tk().wm_withdraw()
                result = messagebox.askyesno("Confirmation Window", "Are you sure want to exit?")
                if result:
                    sys.exit()

            if event.type == pygame.MOUSEMOTION:
                # print(event.pos)
                pygame.draw.rect(WINDOW, BLACK, (0, 0, WIDTH, SQUARESIZE))
                mouse_pos = event.pos[0]
                if player_turn == 0:
                    pygame.draw.rect(WINDOW, BLUE, (mouse_pos, 2, SQUARESIZE - 2, SQUARESIZE - 2))
                else:
                    pygame.draw.rect(WINDOW, YELLOW, (mouse_pos, 2, SQUARESIZE - 2, SQUARESIZE - 2))
            pygame.display.update()

            if event.type == pygame.MOUSEBUTTONDOWN:
                if player_turn == 0:
                    mouse_pos = event.pos[0]
                    column = int(mouse_pos / SQUARESIZE)
                    if is_valid_location(board, column):
                        row = get_block_filling_location(board, column)
                        board[row][column] = 1
                        print(board)

                        if winner(board, 1):
                            gameExit = True
                            print(board)
                            print("Player 1 wins")
                            player1_winner_flag = True
                            player1_score = player1_score + 1

                else:
                    mouse_pos = event.pos[0]
                    column = int(mouse_pos / SQUARESIZE)
                    if is_valid_location(board, column):
                        row = get_block_filling_location(board, column)
                        board[row][column] = 2
                        print(board)

                        if winner(board, 2):
                            gameExit = True
                            print(board)
                            print("Player 2 wins")
                            player2_winner_flag = True
                            player2_score = player2_score + 1

                draw_window(board)
                player_turn += 1
                player_turn = player_turn % 2

    show_score(SCORE_PLAYER1_X, SCORE_PLAYER1_Y, SCORE_PLAYER2_X, SCORE_PLAYER2_Y)
    print("Player 1 score: " + str(player1_score))
    print("Player 2 score: " + str(player2_score))

    if gameExit:
        Tk().wm_withdraw()
        if player1_winner_flag:
            result = messagebox.askyesno("Restart", "Player 1 wins !!!! Do you want to play again?")
            if result:
                main()
            else:
                pygame.quit()

        if player2_winner_flag:
            result = messagebox.askyesno("Restart", "Player 2 wins !!!! Do you want to play again?")
            if result:
                main()
            else:
                pygame.quit()


if __name__ == '__main__':
    main()
