.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "COPY" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
COPY \- Copies data between files and tables
.SH SYNOPSIS
.sp
.nf
COPY [ BINARY ] \fItable\fR [ WITH OIDS ]
    FROM { '\fIfilename\fR' | \fIstdin\fR }
    [ USING DELIMITERS '\fIdelimiter\fR' ]
COPY [ BINARY ] \fItable\fR [ WITH OIDS ]
    TO { '\fIfilename\fR' | \fIstdout\fR }
    [ USING DELIMITERS '\fIdelimiter\fR' ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBBINARY\fR
Changes the behavior of field formatting, forcing all data to be
stored or read as binary objects rather than as text.
.TP
\fB\fItable\fB\fR
The name of an existing table.
.TP
\fBWITH OIDS\fR
Copies the internal unique object id (OID) for each row.
.TP
\fB\fIfilename\fB\fR
The absolute Unix pathname of the input or output file.
.TP
\fB\fIstdin\fB\fR
Specifies that input comes from a pipe or terminal.
.TP
\fB\fIstdout\fB\fR
Specifies that output goes to a pipe or terminal.
.TP
\fB\fIdelimiter\fB\fR
A character that delimits the input or output fields.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCOPY\fR
The copy completed successfully.
.TP
\fBERROR: \fIreason\fB\fR
The copy failed for the reason stated in the error message.
.PP
.SH "DESCRIPTION"
.PP
\fBCOPY\fR moves data between
Postgres tables and
standard file-system files.
\fBCOPY\fR instructs
the Postgres backend
to directly read from or write to a file. The file must be directly visible to
the backend and the name must be specified from the viewpoint of the backend.
If \fIstdin\fR or \fIstdout\fR are
specified, data flows through the client frontend to the backend.
.SS "NOTES"
.PP
The BINARY keyword will force all data to be
stored/read as binary objects rather than as text. It is
somewhat faster than the normal copy command, but is not
generally portable, and the files generated are somewhat larger,
although this factor is highly dependent on the data itself. By
default, a text copy uses a tab ("\\t") character as a delimiter.
The delimiter may also be changed to any other single character
with the keyword phrase USING DELIMITERS. Characters
in data fields which happen to match the delimiter character will
be quoted.
.PP
You must have \fIselect access\fR on any table
whose values are read by
\fBCOPY\fR, and either
\fIinsert or update access\fR to a
table into which values are being inserted by \fBCOPY\fR.
The backend also needs appropriate Unix permissions for any file read
or written by \fBCOPY\fR.
.PP
The keyword phrase USING DELIMITERS specifies a single character
to be used for all delimiters between columns. If multiple characters
are specified in the delimiter string, only the first character is
used.
.sp
.RS
.B "Tip:"
Do not confuse \fBCOPY\fR with the
\fBpsql\fR instruction \fB\\copy\fR.
.RE
.sp
.PP
\fBCOPY\fR neither invokes rules nor acts on column defaults.
It does invoke triggers, however.
.PP
\fBCOPY\fR stops operation at the first error. This
should not lead to problems in the event of
a \fBCOPY FROM\fR, but the
target relation will, of course, be partially modified in a
\fBCOPY TO\fR.
\fBVACUUM\fR should be used to clean up
after a failed copy.
.PP
Because the Postgres backend's current working directory
is not usually the same as the user's
working directory, the result of copying to a file
"\fIfoo\fR" (without
additional path information) may yield unexpected results for the
naive user. In this case, \fIfoo\fR
will wind up in \fI$PGDATA/foo\fR. In
general, the full pathname as it would appear to the backend server machine
should be used when specifying files to
be copied.
.PP
Files used as arguments to \fBCOPY\fR
must reside on or be
accessible to the database server machine by being either on
local disks or on a networked file system.
.PP
When a TCP/IP connection from one machine to another is used, and a
target file is specified, the target file will be written on the
machine where the backend is running rather than the user's
machine. 
.SH "FILE FORMATS"
.SS "TEXT FORMAT"
.PP
When \fBCOPY TO\fR is used without the BINARY option,
the file generated will have each row (instance) on a single line, with each
column (attribute) separated by the delimiter character. Embedded
delimiter characters will be preceded by a backslash character
("\\"). The attribute values themselves are strings generated by the
output function associated with each attribute type. The output
function for a type should not try to generate the backslash
character; this will be handled by \fBCOPY\fR itself.
.PP
The actual format for each instance is
.sp
.nf
<attr1><\fIseparator\fR><attr2><\fIseparator\fR>...<\fIseparator\fR><attr\fIn\fR><newline>
    
.sp
.fi
The oid is placed on the beginning of the line
if WITH OIDS is specified.
.PP
If \fBCOPY\fR is sending its output to standard
output instead of a file, it will send a backslash("\\") and a period
(".") followed immediately by a newline, on a separate line,
when it is done. Similarly, if \fBCOPY\fR is reading
from standard input, it will expect a backslash ("\\") and a period
(".") followed by a newline, as the first three characters on a
line to denote end-of-file. However, \fBCOPY\fR
will terminate (followed by the backend itself) if a true EOF is
encountered before this special end-of-file pattern is found.
.PP
The backslash character has other special meanings. NULL attributes are
represented as "\\N". A literal backslash character is represented as two
consecutive backslashes ("\\\\"). A literal tab character is represented
as a backslash and a tab. A literal newline character is
represented as a backslash and a newline. When loading text data
not generated by Postgres,
you will need to convert backslash
characters ("\\") to double-backslashes ("\\\\") to ensure that they are loaded
properly.
.SS "BINARY FORMAT"
.PP
In the case of \fBCOPY BINARY\fR, the first four
bytes in the file will be the number of instances in the file. If
this number is zero, the \fBCOPY BINARY\fR command
will read until end of file is encountered. Otherwise, it will
stop reading when this number of instances has been read.
Remaining data in the file will be ignored.
.PP
The format for each instance in the file is as follows. Note that
this format must be followed \fBexactly\fR.
Unsigned four-byte integer quantities are called uint32 in the
table below.
"CONTENTS OF A BINARY COPY FILE"
At the start of the fileuint32number of tuplesFor each tupleuint32total length of tuple datauint32oid (if specified)uint32number of null attributes[uint32,...,uint32]attribute numbers of attributes, counting from 0-<tuple data>
.SS "ALIGNMENT OF BINARY DATA"
.PP
On Sun-3s, 2-byte attributes are aligned on two-byte boundaries,
and all larger attributes are aligned on four-byte boundaries.
Character attributes are aligned on single-byte boundaries. On
most other machines, all attributes larger than 1 byte are aligned on
four-byte boundaries. Note that variable length attributes are
preceded by the attribute's length; arrays are simply contiguous
streams of the array element type.
.SH "USAGE"
.PP
The following example copies a table to standard output,
using a vertical bar ("|") as the field
delimiter:
.sp
.nf
COPY country TO \fIstdout\fR USING DELIMITERS '|';
  
.sp
.fi
.PP
To copy data from a Unix file into a table "country":
.sp
.nf
COPY country FROM '/usr1/proj/bray/sql/country_data';
  
.sp
.fi
.PP
Here is a sample of data suitable for copying into a table
from \fIstdin\fR (so it
has the termination sequence on the last line):
.sp
.nf
   AF      AFGHANISTAN
   AL      ALBANIA
   DZ      ALGERIA
   ...
   ZM      ZAMBIA
   ZW      ZIMBABWE
   \\.
  
.sp
.fi
.PP
The same data, output in binary format on a Linux/i586 machine.
The data is shown after filtering through
the Unix utility \fBod -c\fR. The table has
three fields; the first is \fBchar(2)\fR
and the second is \fBtext\fR. All the
rows have a null value in the third field.
Notice how the \fBchar(2)\fR
field is padded with nulls to four bytes and the text field is
preceded by its length:
.sp
.nf
   355  \\0  \\0  \\0 027  \\0  \\0  \\0 001  \\0  \\0  \\0 002  \\0  \\0  \\0
   006  \\0  \\0  \\0   A   F  \\0  \\0 017  \\0  \\0  \\0   A   F   G   H
     A   N   I   S   T   A   N 023  \\0  \\0  \\0 001  \\0  \\0  \\0 002
    \\0  \\0  \\0 006  \\0  \\0  \\0   A   L  \\0  \\0  \\v  \\0  \\0  \\0   A
     L   B   A   N   I   A 023  \\0  \\0  \\0 001  \\0  \\0  \\0 002  \\0
    \\0  \\0 006  \\0  \\0  \\0   D   Z  \\0  \\0  \\v  \\0  \\0  \\0   A   L
     G   E   R   I   A
   ...              \\n  \\0  \\0  \\0   Z   A   M   B   I   A 024  \\0
    \\0  \\0 001  \\0  \\0  \\0 002  \\0  \\0  \\0 006  \\0  \\0  \\0   Z   W
    \\0  \\0  \\f  \\0  \\0  \\0   Z   I   M   B   A   B   W   E
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCOPY\fR statement in SQL92.
