.TH PG_UPGRADE 1 "PG_UPGRADE(1)" "14 Jan 2002" "PostgreSQL Client Applications" ""
.SH NAME
pg_upgrade \- upgrading from a previous release without reloading
.SH SYNOPSIS
pg_upgrade [-D \fIdata_dir\fP] -1 | -2
.SH DESCRIPTION
\fBpg_upgrade\fP is a utility for upgrading from a previous PostgreSQL release
without reloading all the data. Not all PostgreSQL releases can use
this utility.  Check the release notes for details about your
version.
.LP
\fBpg_upgrade\fP must be run in two stages.  In phase one you must run
\fBpg_upgrade\fP with your old database installation in place.  In phase two, 
\fBpg_upgrade\fP must be run on a freshly \fBinitdb\fP'ed current install. 
In both phases, the same \fBpg_upgrade\fP script matching the newly installed
version must be used.
.SH Upgrading PostgreSQL with pg_upgrade
.LP
1) Back up your existing data directory, preferably by making a complete
dump with \fBpg_dumpall.\fP
.LP
2) Copy the program \fIpgsql/contrib/pg_upgrade/pg_upgrade\fP from the current
PostgreSQL distribution somewhere into your path.
.LP
3)  Change your working directory to the pgsql main directory, and type:
.LP
.B $ pg_upgrade -1
.sp
to collect information about the old database needed for the upgrade.
You may use \fI-D\fP to specify the data directory, or use PGDATA.
.LP
4) Do:
.LP
.B $ make install
.sp
to install the new binaries.
.LP
5)  Do:
.LP
.B $ cd pgsql/contrib/pg_resetxlog
.br
.B $ make install
.sp
to install the \fIpg_resetxlog\fP utility which is needed by
\fBpg_upgrade\fP.
.LP
6) Run initdb to create a new template1 database containing the system
tables for the new release.  Make sure you use settings similar to those
used in your previous version.
.LP
7) Start the new \fIpostmaster.\fP  (Note: it is critical that no users connect
to the server until the upgrade is complete.  You may wish to start the
postmaster without -i or alter pg_hba.conf temporarily.)
.LP
8)  Change your working directory to the pgsql main directory again, and type: 
.LP
.B $ pg_upgrade -2
.sp
The program will do some checking to make sure everything is properly
configured, and will then recreate all the databases and tables you had,
but with no data.  It will then physically move the data files
containing non-system tables and indexes into the proper 
subdirectories.
.LP
9)  Restore your old \fIpg_hba.conf\fP if needed to allow user logins.
.sp
.LP
10)  Carefully examine the contents of the upgraded databases.  If you
detect problems, you'll need to recover by restoring from your full
\fBpg_dumpall\fP backup. You can delete the \fIpg_upgrade_info/\fP directory when you
are satisfied.
.LP
The upgraded databases will be in an un-vacuumed state.  You will
probably want to run a \fIVACUUM ANALYZE\fP before beginning production work.
.SH SEE ALSO
initdb(1), postmaster(1), pg_dump(1), pg_dumpall(1), vacuumdb(1)
