.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_AGGREGATE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE AGGREGATE \- Defines a new aggregate function
.SH SYNOPSIS
.sp
.nf
CREATE AGGREGATE \fIname\fR [ AS ] ( BASETYPE = \fIdata_type\fR
    [ , SFUNC1 = \fIsfunc1\fR, STYPE1 = \fIsfunc1_return_type\fR ]
    [ , SFUNC2 = \fIsfunc2\fR, STYPE2 = \fIsfunc2_return_type\fR ]
    [ , FINALFUNC = \fIffunc\fR ]
    [ , INITCOND1 = \fIinitial_condition1\fR ]
    [ , INITCOND2 = \fIinitial_condition2\fR ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an aggregate function to create.
.TP
\fB\fIdata_type\fB\fR
The fundamental data type on which this aggregate function operates.
.TP
\fB\fIsfunc1\fB\fR
The state transition function
to be called for every non-NULL field from the source column.
It takes a variable of
type \fIsfunc1_return_type\fR as
the first argument and that field as the
second argument.
.TP
\fB\fIsfunc1_return_type\fB\fR
The return type of the first transition function.
.TP
\fB\fIsfunc2\fB\fR
The state transition function
to be called for every non-NULL field from the source column.
It takes a variable
of type \fIsfunc2_return_type\fR
as the only argument and returns a variable of the same type.
.TP
\fB\fIsfunc2_return_type\fB\fR
The return type of the second transition function.
.TP
\fB\fIffunc\fB\fR
The final function
called after traversing all input fields. This function must
take two arguments of types
\fIsfunc1_return_type\fR
and
\fIsfunc2_return_type\fR.
.TP
\fB\fIinitial_condition1\fB\fR
The initial value for the first transition function argument.
.TP
\fB\fIinitial_condition2\fB\fR
The initial value for the second transition function argument.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE AGGREGATE\fR 
allows a user or programmer to extend Postgres
functionality by defining new aggregate functions. Some aggregate functions
for base types such as \fBmin(int4)\fR
and \fBavg(float8)\fR are already provided in the base
distribution. If one defines new types or needs an aggregate function not
already provided then \fBCREATE AGGREGATE\fR
can be used to provide the desired features.
.PP
An aggregate function can require up to three functions, two
state transition functions, 
\fIsfunc1\fR
and \fIsfunc2\fR:
.sp
.nf
\fIsfunc1\fR( internal-state1, next-data_item ) ---> next-internal-state1 \fIsfunc2\fR( internal-state2 ) ---> next-internal-state2
   
.sp
.fi
and a final calculation function,
\fIffunc\fR:
.sp
.nf
\fIffunc\fR(internal-state1, internal-state2) ---> aggregate-value
   
.sp
.fi
.PP
Postgres creates up to two temporary variables
(referred to here as \fItemp1\fR
and \fItemp2\fR)
to hold intermediate results used as arguments to the transition functions.
.PP
These transition functions are required to have the following properties:
.TP 0.2i
\(bu
The arguments to 
\fIsfunc1\fR
must be
\fItemp1\fR
of type
\fIsfunc1_return_type\fR
and
\fIcolumn_value\fR
of type \fIdata_type\fR.
The return value must be of type
\fIsfunc1_return_type\fR
and will be used as the first argument in the next call to 
\fIsfunc1\fR.
.TP 0.2i
\(bu
The argument and return value of 
\fIsfunc2\fR
must be
\fItemp2\fR
of type
\fIsfunc2_return_type\fR.
.TP 0.2i
\(bu
The arguments to the final-calculation-function
must be
\fItemp1\fR
and
\fItemp2\fR
and its return value must
be a Postgres
base type (not necessarily
\fIdata_type\fR 
which had been specified for BASETYPE).
.TP 0.2i
\(bu
FINALFUNC should be specified
if and only if both state-transition functions are
specified. 
.PP
.PP
An aggregate function may also require one or two initial conditions,
one for
each transition function. These are specified and stored
in the database as fields of type \fBtext\fR.
.SS "NOTES"
.PP
Use \fBDROP AGGREGATE\fR
to drop aggregate functions.
.PP
It is possible to specify aggregate functions
that have varying combinations of state and final functions. 
For example, the \fBcount\fR aggregate requires SFUNC2
(an incrementing function) but not SFUNC1 or FINALFUNC,
whereas the \fBsum\fR aggregate requires SFUNC1 (an addition
function) but not SFUNC2 or FINALFUNC and the \fBavg\fR
aggregate requires 
both of the above state functions as
well as a FINALFUNC (a division function) to produce its
answer. In any case, at least one state function must be
defined, and any SFUNC2 must have a corresponding INITCOND2.
.SH "USAGE"
.PP
Refer to the chapter on aggregate functions
in the \fIPostgreSQL Programmer's Guide\fR for
complete examples of usage.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE AGGREGATE\fR 
is a Postgres language extension.
There is no \fBCREATE AGGREGATE\fR in SQL92.
