.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /cvsroot/pgsql/src/man/Attic/create_table.l,v 1.22 1998/10/14 02:54:29 momjian Exp $
.TH "CREATE TABLE" SQL 09/25/97 PostgreSQL
.SH NAME
create table - create a new class
.SH SYNOPSIS
.nf
\fBcreate table\fR classname
  \fB(\fP
	attname type
		[\fBdefault\fP value]
		[[\fBnot null\fP] [\fBunique\fP] | [\fBprimary key\fP]]
		[\fBreferences\fP classname \fB(\fP attname \fB)\fP]
		[\fBcheck (\fP condition\fB )\fP]
	[\fB,\fP attname type [constraint] [\fB,\fP ...] ]
	[\fB, primary key ( \fPattname, attname[,...] \fB)\fP]
	[\fB, unique ( \fPattname, attname[,...] \fB)\fP]
	[\fB, foreign key ( \fPattname, attname[,...] \fB) references\fP classname]
	[\fB,\fP [\fBconstraint\fR cname] \fBcheck\fR \fB(\fR test \fB)\fR [, \fBcheck\fR \fB(\fR test \fB)\fR ] ]
  \fB)\fP
  [\fBinherits\fR \fB(\fR classname [\fB,\fR classname] \fB)\fR]
.fi
.SH DESCRIPTION
.BR "Create Table"
will enter a new class into the current data base.  The class will be
\*(lqowned\*(rq by the user issuing the command.  The name of the
class is
.IR classname
and the attributes are as specified in the list of
.IR attname s.
Each attribute is created with the type specified by
.IR type "."
Each type may be a simple type, a complex type (set) or an array type.
Each attribute may be specified to be non-null and
each may have a default value, specified by the
.IR default
clause which is the keyword "default" followed by a constant or expression.
.PP
Each array attribute stores arrays that must have the same number of
dimensions but may have different sizes and array index bounds.  An
array of dimension
.IR n
is specified by appending 
.IR n
pairs of square brackets:
.nf
att_name type[][]..[]
.fi
N.B. As of Postgres version 6.0, consistant array dimensions within an
attribute are not enforced. This will likely change in a future release.
.PP
The optional
.BR inherits
clause specifies a collection of class names from which this class
automatically inherits all fields.  If any inherited field name
appears more than once, Postgres reports an error.  Postgres automatically
allows the created class to inherit functions on classes above it in
the inheritance hierarchy.  Inheritance of functions is done according
to the conventions of the Common Lisp Object System (CLOS).
.PP
Each new class
.IR classname 
is automatically created as a type.  Therefore, one or more instances
from the class are automatically a type and can be used in 
.IR alter_table(l)
or other 
.BR create_table(l)
statements.
.PP
The optional
.BR constraint
clauses specify constraints or tests which new or updated entries
must satisfy for an insert or update operation to succeed. Each constraint
must evaluate to a boolean expression. Multiple attributes may be referenced within
a single constraint.  The use of \fBprimary key (\fPattname[\fB,\fP...]\fB)\fP
as a table constraint
is mutually incompatible with \fBprimary key\fP used as a column constraint.
.PP
The new class is created as a heap with no initial data.  A class can
have no more than 1600 attributes (realistically, this is limited by the
fact that tuple sizes must be less than 8192 bytes), but this limit
may be configured lower at some sites.  A class cannot have the same
name as a system catalog class.
.PP
.SH EXAMPLES
.nf
--
-- Create class emp with attributes name, sal and bdate
--
create table emp (name name, salary float4, bdate abstime)
.fi
.nf
--
--Create class permemp with pension information that
--inherits all fields of emp 
--
create table permemp (plan name) inherits (emp)
.fi
.nf
--
--Create class emppay with attributes name and wage with
--a default salary and constraints on wage range
--
create table emppay (name text not null, wage float4 default 10.00
constraint empcon check (wage > 5.30 and wage <= 30.00), check (name <> ''))
.fi
.nf
--
--Create class tictactoe to store noughts-and-crosses
--boards as a 2-dimensional array
--
create table tictactoe (game int4, board char[][])
.fi
.nf
--
--Create a class newemp with a set attribute "manager".  A
--set (complex) attribute may be of the same type as the
--relation being defined (as here) or of a different complex
--type.  The type must exist in the "pg_type" catalog or be
--the one currently being defined.
--
create table newemp (name text, manager newemp)
.fi
.nf
--
--Create a table using SQL92 syntax
create table component
(
        assembly        char(8)         not null
                                        references job (id),
        product         char(8)         not null
                                        references product (id),
        sorting         int,
        qty             int		check (qty >= 0),

        primary key (assembly, product),
        unique (assembly, product, sorting),
        constraint not_same check (assembly != product)
)
.fi
.PP
.SH BUGS
The \fBforeign key\fP and \fBreferences\fP keywords are parsed but not yet
implemented in PostgreSQL 6.3.1.
.SH "SEE ALSO"
drop_table(l).
