.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_DATABASE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE DATABASE \- Creates a new database
.SH SYNOPSIS
.sp
.nf
CREATE DATABASE \fIname\fR [ WITH LOCATION = '\fIdbpath\fR' ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a database to create.
.TP
\fB\fIdbpath\fB\fR
An alternate location for the new database. See below for caveats.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATEDB\fR
Message returned if the command completes successfully.
.TP
\fBWARN: createdb: database "\fIname\fB" already exists.\fR
This occurs if \fIdatabase\fR specified already exists.
.TP
\fBERROR: Unable to create database directory \fIdirectory\fB\fR
There was a problem with creating the required directory; this operation will
need permissions for the postgres user on the specified location.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE DATABASE\fR creates a new Postgres database.
The creator becomes the administrator of the new database.
.PP
An alternate location can be specified as either an
environment variable known to the backend server
(e.g. '\fBPGDATA2\fR') or, if the server is built to
allow it, as an absolute path name
(e.g. '\fI/usr/local/pgsql/data\fR').
In either case, the location must be pre-configured
by \fBinitlocation\fR.
.SS "NOTES"
.PP
\fBCREATE DATABASE\fR is a Postgres
language extension.
.PP
Use \fBDROP DATABASE\fR to remove a database.
.PP
There are security and data integrity issues
involved with using alternate database locations
specified with absolute path names, and by default
only an environment variable known to the backend may be
specified for an alternate location.
See the Administrator's Guide for more information.
.SH "USAGE"
.PP
To create a new database:
.sp
.nf
olly=> \fBcreate database lusiadas;\fR
   
.sp
.fi
.PP
To create a new database in an alternate area \fI~/private_db\fR:
.sp
.nf
$ \fBmkdir private_db\fR
$ \fBinitlocation ~/private_db\fR
Creating Postgres database system directory /home/olly/private_db/base
   
   $ \fBpsql olly\fR
   Welcome to the POSTGRESQL interactive sql monitor:
    Please read the file COPYRIGHT for copyright terms of POSTGRESQL
    
    type \\? for help on slash commands
    type \\q to quit
    type \\g or terminate with semicolon to execute query
    You are currently connected to the database: template1
    
    olly=> \fBcreate database elsewhere with location = '/home/olly/private_db';\fR
   CREATEDB
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE DATABASE\fR statement in SQL92.
The equivalent command in standard SQL is \fBCREATE SCHEMA\fR.
