.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "ALTER_USER" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
ALTER USER \- Modifies user account information
.SH SYNOPSIS
.sp
.nf
ALTER USER \fIusername\fR [ WITH PASSWORD \fIpassword\fR ]
    [ CREATEDB | NOCREATEDB ] [ CREATEUSER | NOCREATEUSER ]
    [ IN GROUP \fIgroupname\fR [, ...] ]
    [ VALID UNTIL '\fIabstime\fR' ]
  
.sp
.fi
.SS "INPUTS"
.PP
Refer to \fBCREATE USER\fR for a detailed description of each
clause.
.PP
.TP
\fB\fIusername \fB\fR
The Postgres account name of the user whose details are to be altered.
.TP
\fB\fIpassword \fB\fR
The new password to be used for this account.
.TP
\fB\fIgroupname \fB\fR
The name of an access group into which this account is to be put.
.TP
\fB\fIabstime \fB\fR
The date (and, optionally, the time)
at which this user's access is to be terminated.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER USER\fR
Message returned if the alteration was successful.
.TP
\fBERROR: alterUser: user "username" does not exist\fR
Error message returned if the specified user is not known to
the database.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER USER\fR is used to change the attributes of a user's
Postgres account.
Please note that it is not possible
to alter a user's "usesysid" via the alter user
statement. Also, it is only possible for the
Postgres
user or any user with read and modify permissions on
pg_shadow to alter user passwords.
.PP
If any of the clauses of the alter user statement are
omitted, the corresponding value in the pg_shadow table
is left unchanged.
.SS "NOTES"
.PP
\fBALTER USER\fR
is a Postgres
language extension.
.PP
Refer to \fBCREATE/DROP USER\fR
to create or remove a user account.
.PP
In the current release (v6.5), the IN GROUP clause is parsed
but has no affect. When it is fully implemented, it is
intended to modify the pg_group relation.
.SH "USAGE"
.PP
Change a user password:
.sp
.nf
ALTER USER davide WITH PASSWORD hu8jmn3;
  
.sp
.fi
Change a user's valid until date
.sp
.nf
ALTER USER manuel VALID UNTIL 'Jan 31 2030';
   
.sp
.fi
Change a user's valid until date, specifying that his
authorisation should expire at midday on 4th May 1998 using
the time zone which is one hour ahead of UTC
.sp
.nf
ALTER USER chris VALID UNTIL 'May 4 12:00:00 1998 +1';
   
.sp
.fi
Give a user the ability to create other users and new databases.
.sp
.nf
ALTER USER miriam CREATEUSER CREATEDB;
   
.sp
.fi
Place a user in two groups
.sp
.nf
ALTER USER miriam IN GROUP sales, payroll;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBALTER USER\fR statement in
SQL92.
The standard leaves
the definition of users to the implementation.
