.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_USER" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE USER \- Creates account information for a new user
.SH SYNOPSIS
.sp
.nf
CREATE USER\fI username\fR
    [ WITH PASSWORD \fIpassword\fR ]
    [ CREATEDB   | NOCREATEDB ] [ CREATEUSER | NOCREATEUSER ]
    [ IN GROUP     \fIgroupname\fR [, ...] ]
    [ VALID UNTIL  '\fIabstime\fR' ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIusername\fB\fR
The name of the user.
.TP
\fB\fIpassword\fB\fR
The WITH PASSWORD clause sets the user's password within
the "\fIpg_shadow\fR" table. For this reason,
\fI"pg_shadow\fR" is no
longer accessible to the instance of
Postgres that the
Postgres
user's password is initially set to NULL.

When a
user's password in the "\fIpg_shadow\fR"
table is NULL, user
authentication proceeds as it historically has (HBA,
PG_PASSWORD, etc). However, if a password is set for a
user, a new authentication system supplants any other
configured for the Postgres
instance, and the password
stored in the "\fIpg_shadow\fR" table is used
for authentication.
For more details on how this authentication system
functions see pg_crypt(3). If the WITH PASSWORD clause is
omitted, the user's password is set to the empty
string which equates to a NULL value in the authentication
system mentioned above.
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a user's ability to create databases.
If CREATEDB is specified, the user being defined will
be allowed to create his own databases. Using NOCREATEDB
will deny a user the ability to create databases. If this
clause is omitted, NOCREATEDB is used by default.
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses determine whether a user will be permitted to
create new
users in an instance of Postgres.
Omitting this clause will set the user's value of this
attribute to be NOCREATEUSER.
.TP
\fB\fIgroupname\fB\fR
A name of a group into which to insert the user as a new member.
.TP
\fB\fIabstime\fB\fR
The VALID UNTIL clause sets an absolute time after which the
user's Postgres
login is no longer valid. Please note that
if a user does not have a password defined in the
"\fIpg_shadow\fR"
table, the valid until date will not be checked
during user authentication. If this clause is omitted,
a NULL value is stored in "\fIpg_shadow\fR" 
for this attribute,
and the login will be valid for all time.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE USER\fR
Message returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
CREATE USER will add a new user to an instance of 
Postgres.
.PP
The new user will be given a \fIusesysid\fR of:
.sp
.nf
SELECT MAX(usesysid) + 1 FROM pg_shadow;
   
.sp
.fi
This means that 
Postgres users' \fIusesysid\fRs will not
correspond to their operating
system(OS) user ids. The exception to this rule is
the postgres superuser, whose OS user id
is used as the
\fIusesysid\fR during the initdb process. 
If you still want the
OS user id and the \fIusesysid\fR to match
for any given user,
use the \fBcreateuser\fR script provided with
the Postgres distribution.
.SS "NOTES"
.PP
\fBCREATE USER\fR statement is a
Postgres language extension.
.PP
Use \fBDROP USER\fR or \fBALTER USER\fR
statements to remove or modify a user account.
.PP
Refer to the \fIpg_shadow\fR table for further information.
.sp
.nf
   Table    = pg_shadow
   +--------------------------+--------------------------+-------+
   |          Field           |          Type            | Length|
   +--------------------------+--------------------------+-------+
   | usename                  | name                     |    32 |
   | usesysid                 | int4                     |     4 |
   | usecreatedb              | bool                     |     1 |
   | usetrace                 | bool                     |     1 |
   | usesuper                 | bool                     |     1 |
   | usecatupd                | bool                     |     1 |
   | passwd                   | text                     |   var |
   | valuntil                 | abstime                  |     4 |
   +--------------------------+--------------------------+-------+
   
.sp
.fi
.SH "USAGE"
.PP
Create a user with no password:
.sp
.nf
CREATE USER jonathan
   
.sp
.fi
.PP
Create a user with a password:
.sp
.nf
CREATE USER davide WITH PASSWORD jw8s0F4
   
.sp
.fi
.PP
Create a user with a password, whose account is valid until the end of 2001.
Note that after one second has ticked in 2002, the account is not
valid:
.sp
.nf
CREATE USER miriam WITH PASSWORD jw8s0F4 VALID UNTIL 'Jan 1 2002'
   
.sp
.fi
.PP
Create an account where the user can create databases:
.sp
.nf
CREATE USER manuel WITH PASSWORD jw8s0F4 CREATEDB
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE USER\fR statement in SQL92.
