.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "EXPLAIN" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
EXPLAIN \- Shows statement execution details
.SH SYNOPSIS
.sp
.nf
EXPLAIN [ VERBOSE ] \fIquery\fR        
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBVERBOSE\fR
Flag to show detailed query plan.
.TP
\fB\fIquery\fB\fR
Any \fIquery\fR.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBNOTICE: QUERY PLAN:\fR
Explicit query plan from the Postgres backend.
.TP
\fBEXPLAIN\fR
Flag sent after query plan is shown.
.PP
.SH "DESCRIPTION"
.PP
This command outputs details about the supplied query.
The default output is the computed query cost. 
The cost value is only meaningful to the optimizer in comparing
various query plans.
VERBOSE displays the full query plan and cost to your screen,
and pretty-prints the plan to the postmaster log file. 
.SS "NOTES"
.PP
There is only sparse documentation on the optimizer's use of cost
information in Postgres.
General information on cost estimation for query optimization
can be found in database textbooks.
Refer to the \fIProgrammer's Guide\fR
in the chapters on indexes and the genetic query optimizer for
more information.
.SH "USAGE"
.PP
To show a query plan for a simple query on a table with a single
\fBint4\fR column and 128 rows:
.sp
.nf
EXPLAIN SELECT * FROM foo;
    NOTICE:  QUERY PLAN:

Seq Scan on foo  (cost=5.22 rows=128 width=4)

EXPLAIN
    
   
.sp
.fi
.PP
For the same table with an index to support an
\fIequijoin\fR condition on the query,
\fBEXPLAIN\fR will show a different plan:
.sp
.nf
EXPLAIN SELECT * FROM foo WHERE i = 4;
    NOTICE:  QUERY PLAN:

Index Scan using fi on foo  (cost=2.05 rows=1 width=4)

EXPLAIN
    
   
.sp
.fi
.PP
And finally, for the same table with an index to support an
\fIequijoin\fR condition on the query,
\fBEXPLAIN\fR will show the following for a query
using an aggregate function:
.sp
.nf
EXPLAIN SELECT sum(i) FROM foo WHERE i = 4;
    NOTICE:  QUERY PLAN:

Aggregate  (cost=2.05 rows=1 width=4)
  ->  Index Scan using fi on foo  (cost=2.05 rows=1 width=4)
    
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBEXPLAIN\fR statement defined in SQL92.
