.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_OPERATOR" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE OPERATOR \- Defines a new user operator
.SH SYNOPSIS
.sp
.nf
CREATE OPERATOR \fIname\fR ( PROCEDURE = \fIfunc_name\fR
     [, LEFTARG = \fItype1\fR ] [, RIGHTARG = \fItype2\fR ]
     [, COMMUTATOR = \fIcom_op\fR ] [, NEGATOR = \fIneg_op\fR ]
     [, RESTRICT = \fIres_proc\fR ] [, JOIN = \fIjoin_proc\fR ]
     [, HASHES ] [, SORT1 = \fIleft_sort_op\fR ] [, SORT2 = \fIright_sort_op\fR ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The operator to be defined. See below for allowable characters.
.TP
\fB\fIfunc_name\fB\fR
The function used to implement this operator.
.TP
\fB\fItype1\fB\fR
The type for the left-hand side of the operator, if any. This option would be
omitted for a right-unary operator.
.TP
\fB\fItype2\fB\fR
The type for the right-hand side of the operator, if any. This option would be
omitted for a left-unary operator.
.TP
\fB\fIcom_op\fB\fR
The commutator for this operator.
.TP
\fB\fIneg_op\fB\fR
The negator of this operator.
.TP
\fB\fIres_proc\fB\fR
The restriction selectivity estimator function for this operator.
.TP
\fB\fIjoin_proc\fB\fR
The join selectivity estimator function for this operator.
.TP
\fBHASHES\fR
Indicates this operator can support a hash-join algorithm.
.TP
\fB\fIleft_sort_op\fB\fR
Operator that sorts the left-hand data type of this operator.
.TP
\fB\fIright_sort_op\fB\fR
Operator that sorts the right-hand data type of this operator.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the operator is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE OPERATOR\fR defines a new operator,
\fIname\fR.
The user who defines an operator becomes its owner.
.PP
The operator \fIname\fR
is a sequence of up to thirty two (32) characters in any combination
from the following:
.sp
.nf
+ - * / < > = ~ ! @ # % ^ & | ` ? $ : 
   
.sp
.fi
.sp
.RS
.B "Note:"
No alphabetic characters are allowed in an operator name.
This enables Postgres to parse SQL input
into tokens without requiring spaces between each token.
.RE
.sp
.PP
The operator "!=" is mapped to "<>" on input, so they are
therefore equivalent.
.PP
At least one of LEFTARG and RIGHTARG must be defined. For
binary operators, both should be defined. For right unary
operators, only LEFTARG should be defined, while for left
unary operators only RIGHTARG should be defined.
.PP
Also, the
\fIfunc_name\fR procedure must have
been previously defined using \fBCREATE FUNCTION\fR and must
be defined to accept the correct number of arguments
(either one or two).
.PP
The commutator operator should be identified if one exists,
so that Postgres can
reverse the order of the operands if it wishes.
For example, the operator area-less-than, <<<,
would probably have a commutator
operator, area-greater-than, >>>.
Hence, the query optimizer could freely convert:
.sp
.nf
"0,0,1,1"::box  >>> MYBOXES.description
   
.sp
.fi
to
.sp
.nf
MYBOXES.description <<< "0,0,1,1"::box
   
.sp
.fi
.PP
This allows the execution code to always use the latter
representation and simplifies the query optimizer somewhat.
.PP
Similarly, if there is a negator operator then it should be
identified.
Suppose that an
operator, area-equal, ===, exists, as well as an area not
equal, !==.
The negator link allows the query optimizer to simplify
.sp
.nf
NOT MYBOXES.description === "0,0,1,1"::box
   
.sp
.fi
to
.sp
.nf
MYBOXES.description !== "0,0,1,1"::box
   
.sp
.fi
.PP
If a commutator operator name is supplied, 
Postgres
searches for it in the catalog. If it is found and it
does not yet have a commutator itself, then the commutator's
entry is updated to have the newly created operator as its
commutator. This applies to the negator, as well.
.PP
This is to allow the definition of two operators that are
the commutators or the negators of each other. The first
operator should be defined without a commutator or negator
(as appropriate). When the second operator is defined,
name the first as the commutator or negator. The first
will be updated as a side effect. (As of Postgres 6.5,
it also works to just have both operators refer to each other.)
.PP
The next three specifications are present to support the
query optimizer in performing joins. 
Postgres can always
evaluate a join (i.e., processing a clause with two tuple
variables separated by an operator that returns a boolean)
by iterative substitution [WONG76]. 
In addition, Postgres
can use a hash-join algorithm along
the lines of [SHAP86]; however, it must know whether this
strategy is applicable. The current hash-join algorithm
is only correct for operators that represent equality tests;
furthermore, equality of the datatype must mean bitwise equality
of the representation of the type. (For example, a datatype that
contains unused bits that don't matter for equality tests could
not be hashjoined.)
The HASHES flag indicates to the query optimizer that a hash join
may safely be used with this operator.
.PP
Similarly, the two sort operators indicate to the query
optimizer whether merge-sort is a usable join strategy and
which operators should be used to sort the two operand
classes. Sort operators should only be provided for an equality
operator, and they should refer to less-than operators for the
left and right side data types respectively.
.PP
If other join strategies are found to be practical,
Postgres
will change the optimizer and run-time system to use
them and will require additional specification when an
operator is defined. Fortunately, the research community
invents new join strategies infrequently, and the added
generality of user-defined join strategies was not felt to
be worth the complexity involved.
.PP
The last two pieces of the specification are present so
the query optimizer can estimate result sizes. If a
clause of the form:
.sp
.nf
MYBOXES.description <<< "0,0,1,1"::box
   
.sp
.fi
is present in the qualification,
then Postgres may have to
estimate the fraction of the instances in MYBOXES that
satisfy the clause. The function
\fIres_proc\fR
must be a registered function (meaning it is already defined using
\fBCREATE FUNCTION\fR) which accepts arguments of the correct
data types and returns a floating point number. The
query optimizer simply calls this function, passing the
parameter "0,0,1,1" and multiplies the result by the relation
size to get the desired expected number of instances.
.PP
Similarly, when the operands of the operator both contain
instance variables, the query optimizer must estimate the
size of the resulting join. The function join_proc will
return another floating point number which will be multiplied
by the cardinalities of the two classes involved to
compute the desired expected result size.
.PP
The difference between the function
.sp
.nf
my_procedure_1 (MYBOXES.description, "0,0,1,1"::box)
   
.sp
.fi
and the operator
.sp
.nf
MYBOXES.description === "0,0,1,1"::box
   
.sp
.fi
is that Postgres
attempts to optimize operators and can
decide to use an index to restrict the search space when
operators are involved. However, there is no attempt to
optimize functions, and they are performed by brute force.
Moreover, functions can have any number of arguments while
operators are restricted to one or two.
.SS "NOTES"
.PP
Refer to the chapter on operators in the
\fIPostgreSQL User's Guide\fR
for further information.
Refer to \fBDROP OPERATOR\fR to delete
user-defined operators from a database.
.SH "USAGE"
.PP
The following command defines a new operator,
area-equality, for the BOX data type.
.sp
.nf
CREATE OPERATOR === (
   LEFTARG = box,
   RIGHTARG = box,
   PROCEDURE = area_equal_procedure,
   COMMUTATOR = ===,
   NEGATOR = !==,
   RESTRICT = area_restriction_procedure,
   JOIN = area_join_procedure,
   HASHES,
   SORT1 = <<<,
   SORT2 = <<<
);
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE OPERATOR\fR
is a Postgres extension.
There is no \fBCREATE OPERATOR\fR
statement in SQL92.
