/*-------------------------------------------------------------------------
 *
 * unicode_norm_hashfunc.h
 *	  Perfect hash functions used for Unicode normalization
 *
 * Portions Copyright (c) 1996-2020, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/common/unicode_norm_hashfunc.h
 *
 *-------------------------------------------------------------------------
 */

/*
 * File auto-generated by src/common/unicode/generate-unicode_norm_table.pl,
 * do not edit. There is deliberately not an #ifndef PG_UNICODE_NORM_HASHFUNC_H
 * here.
 */

#include "common/unicode_norm_table.h"

/* Typedef for perfect hash functions */
typedef int (*cp_hash_func) (const void *key);

/* Information for lookups with perfect hash functions */
typedef struct
{
	const pg_unicode_decomposition *decomps;
	cp_hash_func	hash;
	int		num_decomps;
} pg_unicode_decompinfo;

typedef struct
{
	const uint16	*inverse_lookup;
	cp_hash_func	hash;
	int		num_recomps;
} pg_unicode_recompinfo;

/* Perfect hash function for decomposition */
static int
Decomp_hash_func(const void *key)
{
	static const int16 h[13209] = {
		0,     1515,  4744,  4745,  0,     0,     0,     0,
		0,     0,     0,     0,     3890,  3890,  0,     0,
		3891,  3891,  -2046, 2800,  3890,  3890,  3890,  -4396,
		4361,  4362,  -4441, -4441, -4396, 1773,  1773,  1773,
		4372,  4373,  -4438, -4438, -4393, -4393, 2619,  17,
		-4347, -4393, -4393, -4393, -4393, -4393, 2619,  2619,
		1560,  4346,  4347,  4348,  1917,  1873,  1874,  1875,
		-7856, 4358,  17619, 2622,  2622,  2622,  6357,  6358,
		6359,  6360,  6361,  6362,  6363,  2622,  -4390, -4390,
		4414,  -5356, -5356, 4374,  4375,  -5356, -5356, -6335,
		-3020, 2511,  -5356, -5356, -3583, -3583, -3583, -3583,
		-995,  0,     0,     -9799, -9754, 2874,  2875,  2876,
		2877,  2878,  -9830, -3591, -9756, -9756, -2744, -5346,
		-9710, -9756, 342,   -5346, -9756, -5346, -2743, -449,
		348,   2894,  2895,  -2853, 2897,  2898,  2899,  2900,
		2901,  2902,  2903,  2904,  2905,  2906,  2907,  2908,
		2909,  2910,  2911,  2912,  2913,  2914,  2915,  2916,
		2917,  2918,  2919,  2920,  2921,  2922,  2923,  2924,
		2925,  2926,  2927,  2928,  2929,  2930,  2931,  2932,
		2933,  2934,  32767, 32767, 32767, 32767, 32767, 32767,
		-8721, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1,     32767, 48,    32767, 32767, 32767, 32767, 49,
		32767, 32767, -8687, -8687, -6255, -6210, 32767, 32767,
		-8689, -8689, -21949,32767, -18635,-15320,-15320,32767,
		-12006,-8691, -8691, -8691, -8691, -8691, 32767, 66,
		-8737, -8737, -8692, -8692, -8692, -8692, 73,    74,
		32767, -8738, -8693, -8693, -8693, -8693, -8693, 32767,
		32767, -8695, -8695, -8695, -8695, -8695, 32767, 32767,
		40,    41,    -2390, -2434, 44,    45,    32767, 46,
		13307, 9993,  9994,  6680,  6681,  3367,  3368,  54,
		0,     55,    56,    57,    -8699, -8699, 105,   32767,
		32767, 61,    62,    63,    -8701, -8701, 32767, 111,
		32767, 67,    68,    69,    70,    1890,  3687,  -1272,
		3690,  75,    76,    77,    78,    79,    80,    81,
		82,    32767, 32767, 83,    84,    85,    86,    87,
		88,    89,    90,    91,    92,    93,    94,    95,
		96,    97,    98,    99,    100,   101,   102,   32767,
		32767, 103,   104,   105,   106,   107,   108,   109,
		-8660, -8660, 32767, -8661, -8661, -8661, -8661, -8661,
		-8661, 32767, 73,    74,    75,    76,    -2355, -2399,
		79,    80,    32767, 32767, 13341, 10027, 10028, 6714,
		6715,  3401,  3402,  32767, 32767, 88,    89,    90,
		-8666, -8666, 138,   32767, 32767, 94,    95,    96,
		-8668, -8668, 144,   145,   101,   -2553, -2553, -2553,
		-2553, -4983, -2553, -2553, 154,   -2553, 156,   32767,
		32767, 6114,  158,   -3153, -3152, -3151, -12891,-6888,
		-931,  -3149, 166,   -3148, -4728, 169,   -3147, -3146,
		-3145, -3144, -3143, -3142, -3141, -2543, -3139, -3138,
		180,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3314,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     3660,  3661,  2131,  2132,  2133,  2134,  2135,
		2136,  2137,  2138,  2139,  2140,  2141,  2142,  2143,
		2144,  2145,  -5472, -5472, -3612, -3612, -3612, -3612,
		-3612, 2652,  -3612, -3612, -3612, -3612, -3612, -3612,
		-3612, -3612, 3693,  -3613, -7015, -7015, 1742,  1743,
		-7060, -7060, -7015, -846,  -846,  -846,  1753,  1754,
		-7057, -7057, -7012, -7012, 0,     -2602, -6966, -7012,
		-7012, -7012, -7012, -7012, 0,     0,     1725,  1726,
		1727,  1728,  -703,  -747,  -746,  0,     1735,  1736,
		14997, 0,     0,     0,     3735,  3736,  3737,  3738,
		3739,  3740,  3741,  0,     -7012, -7012, 1792,  1793,
		1749,  1750,  1751,  -7980, -7980, -8959, -5644, -113,
		-7980, -113,  -2382, -6116, -6116, -6116, -6116, -6116,
		-6116, -6116, -2374, 4639,  4640,  -4163, 5608,  5609,
		-4120, -4120, 5612,  5613,  6593,  3279,  -2251, 5617,
		5618,  3846,  3847,  3848,  3849,  1262,  1262,  10066,
		10067, 10023, 3855,  3856,  3857,  1259,  1259,  10071,
		3861,  10027, 10028, 3017,  5620,  9985,  10032, -65,
		5624,  10035, 5626,  3024,  731,   -65,   1298,  12530,
		3727,  3727,  3772,  3772,  3772,  13504, 13505, 14485,
		11171, 5641,  13509, 5643,  7913,  11648, 11649, 11650,
		11651, 11652, 11653, 11654, 7913,  901,   901,   9705,
		-65,   -65,   9665,  9666,  -65,   -65,   -1044, 2271,
		7802,  -65,   -65,   1708,  1708,  1708,  1708,  4296,
		4297,  -4506, -4506, -4461, 1708,  1708,  1708,  4307,
		4308,  -4503, 1708,  -4457, -4457, 2555,  -47,   -4411,
		-4457, 5641,  -47,   -4457, -47,   2556,  4850,  5647,
		4285,  -6946, 1858,  1859,  1815,  1816,  1817,  -7914,
		-7914, -8893, -5578, -47,   -7914, -47,   -2316, -6050,
		-6050, -6050, -6050, -6050, -6050, -6050, -2308, 4705,
		4706,  -4097, 5674,  5675,  -4054, -4054, 5678,  5679,
		6659,  3345,  -2185, 5683,  5684,  3912,  3913,  3914,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -3083, -3083, 232,   287,   233,   233,
		233,   8990,  8991,  32767, 32767, 3668,  32767, 3667,
		3667,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 208,   208,   208,   208,   208,   208,
		32767, 32767, 206,   206,   206,   206,   206,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 304,   305,   -1274, 307,   308,
		309,   6753,  -1374, 10488, 4486,  -1470, 4488,  316,
		4489,  -5607, 4490,  4491,  4492,  322,   760,   324,
		325,   326,   166,   763,   329,   -2553, 765,   332,
		333,   334,   335,   772,   337,   6310,  339,   340,
		341,   342,   343,   344,   345,   346,   -2542, -2542,
		-2542, 350,   351,   352,   353,   354,   355,   356,
		357,   358,   359,   360,   361,   362,   -6008, 364,
		365,   366,   367,   368,   369,   370,   254,   372,
		373,   374,   375,   376,   377,   378,   379,   380,
		381,   382,   32767, 383,   384,   -3606, -3605, -3604,
		-3603, 389,   -3600, -3599, -3598, 2340,  -1238, -3595,
		-3594, -3593, 4694,  -4062, -4062, 4742,  4743,  4699,
		-1469, -1468, -1467, -4065, -4065, 4747,  -1463, 4703,
		4704,  -2307, 296,   32767, 0,     32767, 32767, 4708,
		-1376, -1376, -1376, 32767, 32767, -1246, 506,   506,
		0,     -1559, 32767, 32767, 32767, 32767, 32767, 305,
		419,   308,   2578,  6313,  6314,  424,   32767, -6030,
		32767, 426,   427,   428,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 0,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 429,   -5407, 431,
		-5406, 433,   -3601, 435,   32767, -3751, 32767, 32767,
		32767, 32767, -3755, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 436,   -11425,-5422,
		535,   -5422, 535,   -5422, 4675,  -5421, -5421, -5421,
		-5421, -5421, 4681,  0,     0,     0,     4682,  4683,
		4684,  4685,  4686,  4687,  0,     0,     32767, 32767,
		0,     0,     -5684, 0,     4688,  4689,  4690,  4691,
		4692,  4693,  4694,  4695,  -1257, -1257, 4696,  -5441,
		-5441, 4699,  4700,  4701,  -5443, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 454,   0,     32767, 456,
		32767, 32767, 0,     457,   32767, 32767, 32767, 0,
		458,   459,   460,   32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 4703,  4704,  4705,  4706,  32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 4655,  4656,  4657,  4658,
		4659,  4712,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 462,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 463,   464,   32767, 465,
		32767, 32767, 32767, 466,   32767, 32767, 32767, 32767,
		467,   468,   469,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 3011,  3011,  3011,
		3011,  3011,  3011,  3011,  32767, 32767, 32767, 32767,
		32767, 32767, 470,   471,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 472,
		473,   474,   475,   476,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 4713,  4714,  4715,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 477,   478,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 479,   480,   481,   482,
		32767, 32767, 483,   484,   32767, 32767, 485,   486,
		487,   488,   489,   490,   32767, 32767, 491,   492,
		493,   494,   495,   496,   32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     665,   -255,  667,   0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     693,   694,   695,   696,
		697,   698,   699,   700,   701,   702,   703,   704,
		705,   706,   707,   708,   709,   710,   711,   712,
		7183,  714,   -1580, 716,   2547,  718,   7194,  720,
		2553,  722,   723,   7204,  725,   726,   727,   728,
		729,   730,   731,   732,   733,   734,   735,   736,
		0,     0,     8114,  8159,  745,   -1535, 747,   748,
		8161,  -5019, -5019, -5019, -5019, 1938,  0,     0,
		0,     0,     0,     0,     767,   768,   0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -2875, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -2884, -2884,
		-2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
		-2884, -2884, -4271, -2884, -2884, -2884, -2884, -2884,
		-2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
		-2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
		-2884, -2884, -2884, -2884, -2884, -2884, -2884, -2884,
		-2884, -2884, -2884, 32767, -2885, 32767, -2886, -2886,
		32767, -2887, -2887, 32767, -2888, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 563,   564,
		565,   566,   567,   568,   569,   570,   571,   572,
		573,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		574,   575,   576,   577,   578,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -294,  -294,  -294,  -3047, 583,   584,   585,
		-4462, -4418, -4418, -4418, -4418, -4418, -4462, -4462,
		-4462, 595,   596,   597,   598,   599,   32767, 32767,
		32767, 32767, -4471, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 4716,  4717,  4718,  4719,
		4720,  4721,  4722,  4723,  4724,  4725,  4726,  4727,
		4728,  4729,  4730,  4731,  4732,  4733,  4734,  4735,
		3826,  4737,  4738,  4739,  4740,  4741,  4742,  3832,
		4744,  3833,  3120,  3121,  3835,  3835,  3124,  3836,
		3836,  4753,  4754,  4755,  4756,  4757,  4758,  4759,
		4760,  4761,  4762,  4763,  4764,  4765,  4766,  4767,
		4768,  4769,  4770,  4771,  4772,  4773,  4774,  4775,
		4776,  4777,  4778,  4779,  4780,  4781,  6619,  6620,
		6621,  11272, 6623,  6624,  4788,  4789,  4790,  3874,
		4761,  3874,  4794,  3874,  4796,  4797,  4798,  3874,
		4800,  32767, 0,     4802,  4803,  4804,  4805,  4806,
		4807,  4808,  4809,  4810,  4811,  4812,  4813,  4814,
		4815,  4816,  4817,  4818,  4819,  4820,  4821,  4822,
		4823,  4824,  4825,  4826,  4827,  4828,  11299, 4830,
		2536,  4832,  6663,  4834,  11310, 4836,  6669,  4838,
		4839,  11320, 4841,  4842,  4843,  4844,  4845,  4846,
		4847,  4848,  4849,  4850,  4851,  4852,  1188,  4854,
		4855,  4856,  4857,  2577,  4859,  4860,  12273, -907,
		-907,  -907,  -907,  -907,  -907,  4868,  4869,  4870,
		4871,  32767, 4872,  4873,  32767, 32767, 4874,  32767,
		627,   4875,  4876,  32767, 32767, 4877,  4878,  4879,
		6722,  32767, 4881,  4882,  4883,  6730,  6731,  7446,
		6733,  4888,  7449,  7449,  4891,  4892,  32767, 4893,
		32767, 4894,  4895,  4896,  4897,  4898,  4899,  3512,
		3513,  3514,  3515,  3516,  4904,  3518,  3519,  3520,
		3521,  3522,  3523,  3524,  3525,  3526,  3527,  3528,
		3529,  3530,  3531,  3532,  3533,  3534,  3535,  3536,
		3537,  3538,  4926,  6797,  4928,  6800,  4930,  4931,
		4932,  4933,  4934,  4935,  6813,  4937,  4938,  6816,
		6817,  4941,  4942,  4943,  0,     4945,  6821,  0,
		0,     4949,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, -127,  -127,  -127,
		7285,  -127,  -127,  0,     -128,  -128,  -128,  -128,
		0,     32767, -130,  4971,  -129,  5613,  5614,  5615,
		4976,  5618,  32767, 5619,  5620,  5621,  4981,  5624,
		4983,  4984,  32767, 5630,  5631,  -1986, -1986, -126,
		-126,  5078,  4992,  5037,  5038,  5039,  5040,  5041,
		5086,  5087,  5088,  5089,  -2322, 5091,  5092,  5093,
		5094,  5095,  5096,  5097,  5098,  5099,  5100,  0,
		5101,  -640,  -640,  -640,  0,     -641,  -641,  -641,
		-641,  -641,  0,     -642,  0,     0,     32767, -645,
		-645,  6973,  6974,  5115,  5116,  -87,   0,     -44,
		-44,   -44,   -44,   -44,   -88,   -88,   -88,   -88,
		7324,  -88,   -88,   -88,   -88,   -88,   -88,   -88,
		-88,   -88,   -88,   -88,   -88,   5654,  5655,  5656,
		5657,  5658,  5659,  5660,  5661,  5662,  5663,  5664,
		5665,  5666,  5667,  5668,  5669,  -1948, -1948, -88,
		-88,   5116,  5117,  5074,  5075,  5076,  5077,  5078,
		5123,  5124,  5125,  5126,  -2285, 5128,  5129,  5130,
		5131,  5132,  5133,  5134,  5135,  5136,  5137,  5138,
		5139,  -602,  -602,  -602,  -602,  -602,  -602,  -602,
		-602,  -602,  -602,  -602,  -602,  -602,  -602,  -602,
		-602,  7016,  7017,  5158,  5159,  -44,   -44,   0,
		0,     0,     0,     0,     -44,   -44,   -44,   -44,
		7368,  -44,   -44,   -44,   -44,   -44,   -44,   -44,
		-44,   -44,   -44,   -44,   -44,   5698,  5699,  5700,
		5701,  5702,  5703,  5704,  5705,  5706,  5707,  5708,
		5709,  5710,  5711,  5712,  5713,  -1904, -1904, -44,
		-44,   5160,  5161,  5118,  5119,  5120,  5121,  5122,
		5167,  5168,  5169,  5170,  -2241, 5172,  5173,  5174,
		5175,  5176,  5177,  5178,  5179,  5180,  5181,  5182,
		5183,  -558,  -558,  -558,  -558,  -558,  -558,  -558,
		-558,  -558,  -558,  -558,  -558,  -558,  -558,  -558,
		-558,  7060,  7061,  5202,  5203,  0,     0,     44,
		44,    44,    44,    44,    0,     0,     0,     0,
		7412,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     5742,  5743,  5744,
		5745,  5746,  5747,  5748,  5749,  5750,  5751,  5752,
		5753,  5754,  5755,  5756,  5757,  -1860, -1860, 0,
		0,     0,     0,     0,     6264,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     -3402,
		-3402, 5355,  5356,  -3447, -3447, -3402, -3402, -3402,
		-3402, 5363,  5364,  -3447, -3447, -3402, -3402, -3402,
		-3358, -3358, -3404, -3404, -3404, -3404, -3404, -3404,
		-3404, 5331,  5332,  5333,  5334,  2903,  2859,  5337,
		5338,  5339,  5340,  18601, 15287, 15288, 11974, 11975,
		8661,  8662,  5348,  5349,  5350,  5351,  5352,  -3404,
		-3404, 5400,  5401,  5357,  5358,  5359,  5360,  -3404,
		-3404, 5408,  5409,  5365,  5366,  5367,  5324,  5325,
		5372,  5373,  5374,  5375,  5376,  5377,  5378,  -3356,
		-3356, -3356, -3356, -924,  -879,  -3356, -3356, -3356,
		-3356, -16616,-13301,-13301,-9986, -9986, -6671, -6671,
		-3356, -3356, -3356, -3356, -3356, 5401,  5402,  -3401,
		-3401, -3356, -3356, -3356, -3356, 5409,  5410,  -3401,
		-3401, -3356, -3356, -3356, -3312, -3312, -3358, -3358,
		-3358, -3358, -3358, -3358, -3358, 5377,  5378,  5379,
		5380,  2949,  2905,  5383,  5384,  5385,  5386,  18647,
		15333, 15334, 12020, 12021, 8707,  8708,  5394,  5395,
		5396,  5397,  5398,  -3358, -3358, 5446,  5447,  5403,
		5404,  5405,  5406,  -3358, -3358, 5454,  5455,  5411,
		5412,  5413,  5414,  5415,  5416,  5417,  5418,  5419,
		5420,  5421,  5422,  -3312, -3312, -3312, -3312, -880,
		-835,  -3312, -3312, -3312, -3312, -16572,-13257,-13257,
		-9942, -9942, -6627, -6627, -3312, -3312, -3312, -3312,
		-3312, 5445,  5446,  -3357, -3357, -3312, -3312, -3312,
		-3312, 5453,  5454,  -3357, -3357, -3312, -3312, -3312,
		-3312, -3312, -3312, -3312, -3312, -3312, -3312, -3312,
		-3312, 5423,  5424,  5425,  5426,  2995,  2951,  5429,
		5430,  5431,  5432,  18693, 15379, 15380, 12066, 12067,
		8753,  8754,  5440,  5441,  5442,  5443,  5444,  -3312,
		-3312, 5492,  5493,  5449,  5450,  5451,  5452,  -3312,
		-3312, 5500,  5501,  5457,  2803,  2803,  2803,  2803,
		373,   2803,  2803,  5510,  2803,  5512,  11470, 5514,
		11472, 5516,  2205,  2206,  2207,  -7533, -1530, 4427,
		2209,  5524,  2210,  630,   5527,  2211,  2212,  2213,
		2214,  2215,  2216,  2217,  2815,  2219,  2220,  5538,
		2221,  5540,  2222,  5542,  5543,  2223,  -3312, -3312,
		-3312, 5548,  5549,  -3312, -3312, 2803,  2803,  2803,
		5555,  5556,  5557,  2803,  2803,  2803,  2803,  2803,
		2803,  2803,  2803,  2803,  2803,  2803,  2803,  2803,
		9050,  9051,  2803,  2803,  2803,  2803,  2803,  2803,
		2803,  2803,  2803,  2803,  2803,  2803,  4318,  7547,
		7548,  2803,  2803,  2803,  2803,  2803,  2803,  2803,
		2803,  6693,  6693,  2803,  2803,  6694,  6694,  757,
		5603,  6693,  6693,  6693,  -1593, 7164,  7165,  -1638,
		-1638, -1593, 4576,  4576,  4576,  7175,  7176,  -1635,
		-1635, -1590, -1590, 5422,  2820,  -1544, -1590, -1590,
		-1590, -1590, -1590, 5422,  5422,  4363,  7149,  7150,
		7151,  4720,  4676,  4677,  4678,  -5053, 7161,  20422,
		5425,  5425,  5425,  9160,  9161,  9162,  9163,  9164,
		9165,  9166,  5425,  -1587, -1587, 7217,  -2553, -2553,
		7177,  7178,  -2553, 32767, 32767, -219,  5312,  -2555,
		-2555, -782,  -782,  -782,  -782,  1806,  2801,  2801,
		-6998, -6953, 5675,  5676,  5677,  5678,  5679,  -7029,
		-790,  -6955, -6955, 57,    -2545, -6909, -6955, 3143,
		-2545, -6955, -2545, 58,    2352,  3149,  5695,  5696,
		-52,   5698,  5699,  5700,  5701,  5702,  5703,  5704,
		5705,  5706,  5707,  5708,  5709,  5710,  5711,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -1838, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 6927,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -973,  32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     4567,  4568,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -437,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -448,  32767, 32767, -450,  -450,
		-450,  0,     32767, 32767, 32767, -2166, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     32767, -464,
		-464,  32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -514,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		5757,  5758,  5759,  0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, -4186, -4186, -12097,-4186, 32767,
		-4187, -4187, -8787, 32767, 0,     0,     5952,  0,
		0,     -4183, -4183, -4183, 0,     -2386, -4182, 778,
		-4183, -5935, 32767, 32767, -4690, -6249, -4184, -4184,
		-4184, 32767, 32767, -4186, -4186, -77,   32767, -77,
		32767, -4188, 0,     -4189, 32767, 0,     0,     0,
		0,     32767, 0,     0,     0,     32767, 0,     0,
		0,     0,     0,     0,     0,     32767, 0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		0,     0,     0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -5937, -2358, 0,     0,     0,
		-8286, 471,   472,   32767, 32767, 32767, 32767, 32767,
		32767, 32767, 1747,  32767, -2126, 32767, 32767, 1748,
		1749,  1750,  1751,  1752,  1753,  8224,  1755,  -539,
		1757,  781,   32767, 32767, 32767, -1991, -2035, 32767,
		32767, 782,   -3784, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 837,   32767, 32767, 32767, 32767, 32767, -4008,
		-4008, -4008, 2949,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     -797,  1806,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4605,  4606,
		32767, 32767, 0,     455,   32767, 0,     32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -4244, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		784,   32767, 32767, 2950,  2951,  32767, 32767, 32767,
		32767, 32767, 32767, 786,   787,   32767, 1252,  1253,
		32767, 790,   32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     32767, 0,     32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 0,     0,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -200,  -200,  -200,
		-200,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		-5932, -5932, 32767, 32767, 2952,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -5387,
		-5387, -5387, -5387, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     0,     32767, 32767,
		0,     0,     32767, 32767, 0,     0,     0,     0,
		0,     0,     32767, 32767, 0,     0,     0,     0,
		0,     0,     32767, 32767, 497,   498,   499,   500,
		501,   502,   503,   504,   505,   506,   507,   508,
		32767, 32767, -156,  765,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -861,
		32767, 6106,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2953,  2954,  32767, 797,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 2955,  32767, 32767, 32767, -8929,
		32767, -8885, -8885, -8885, 32767, 32767, 32767, 32767,
		32767, 32767, -749,  7119,  7120,  32767, 32767, 32767,
		32767, 2760,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     0,     32767, 32767, 32767, 32767,
		32767, -1181, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -5587, 0,     7596,
		7597,  0,     0,     0,     0,     0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -714,  0,
		0,     -713,  -712,  0,     -711,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     1859,
		0,     3247,  32767, 32767, 0,     3247,  0,     3248,
		0,     3249,  0,     3250,  0,     3251,  0,     3252,
		808,   3252,  0,     3253,  0,     3254,  0,     0,
		3256,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 0,     0,     0,
		0,     32767, 32767, 32767, 32767, 0,     0,     6824,
		32767, 0,     32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		4207,  4208,  0,     0,     0,     0,     0,     1896,
		0,     0,     1898,  1898,  1898,  1898,  0,     0,
		0,     1901,  1901,  0,     0,     0,     0,     0,
		0,     -1319, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     7618,  7619,  7620,
		3,     3,     1863,  1863,  7067,  7068,  7025,  7026,
		7027,  7028,  7029,  7074,  7075,  7076,  7077,  -334,
		7079,  7080,  7081,  7082,  7083,  7084,  7085,  7086,
		7087,  7088,  7089,  7090,  1349,  1349,  1349,  1349,
		1349,  1349,  1349,  1349,  1349,  1349,  1349,  1349,
		1349,  1349,  1349,  1349,  8967,  8968,  7109,  7110,
		1907,  1907,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 2976,  2977,  2978,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     820,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 821,
		2381,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 2005,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 823,   32767, 824,   32767,
		825,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 826,   32767, 32767, 32767, 32767, 32767,
		32767, 4575,  4576,  4577,  4578,  4579,  4580,  4581,
		4582,  4583,  4584,  4585,  32767, 32767, 829,   32767,
		32767, 32767, 32767, 830,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		6253,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		6253,  -3848, 834,   835,   836,   -3845, -3845, -3845,
		-3845, -3845, -3845, 843,   844,   -4280, 32767, 845,
		846,   6531,  848,   -3839, 32767, -3840, -3840, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 1946,  32767,
		32767, 32767, -3849, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 853,   32767, 32767, 32767,
		32767, 854,   32767, 32767, 32767, 32767, 855,   32767,
		32767, 32767, 32767, 856,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		857,   32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -3799, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 8266,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 859,   32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 860,
		32767, 861,   -5065, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 10746, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4526,
		32767, 4573,  4574,  4575,  32767, 32767, -2436, -1376,
		32767, 32767, 32767, 32767, 32767, -1689, -1689, 4349,
		-4171, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4588,  32767,
		4589,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4590,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4591,  4592,  32767,
		32767, 32767, 32767, 32767, 32767, 2933,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 864,   32767, 32767, 32767,
		0,     32767, 0,     32767, 32767, -2977, 335,   335,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2992,  2993,  2994,  2995,
		32767, 32767, 32767, 4596,  2550,  32767, 32767, 32767,
		-1188, 4769,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		4600,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 2997,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4601,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 2013,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -11287,32767, 32767, 32767, 32767,
		32767, 32767, 32767, -4664, 32767, 32767, -4711, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -4718, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4049,
		32767, 32767, 32767, 4050,  4051,  4052,  17313, 32767,
		32767, 32767, 10684, 7370,  7371,  4057,  4058,  4059,
		4060,  4061,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4603,  8793,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1283,  4897,  4898,  4899,  12175, 4901,  4902,  32767,
		4903,  4904,  4905,  4906,  4907,  10276, -1469, 1282,
		1282,  1282,  1282,  1282,  1282,  1282,  1282,  1282,
		1282,  32767, 32767, 4920,  4921,  4063,  -2051, -2050,
		4925,  4926,  32767, 7332,  7333,  32767, 7334,  7335,
		7336,  7337,  5045,  32767, 32767, 32767, -2049, -2048,
		32767, -8294, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     1132,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     20166, 16852, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     6908,  6909,  6910,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		-4510, -4510, -4510, -4510, -4510, -4510, -4510, 0,
		0,     0,     0,     0,     0,     -1831, -1831, -1831,
		-15091,-11776,-11776,-8461, 0,     0,     0,     -1834,
		-1834, -1834, -1834, -1834, 0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -1819, -3615, 1345,  -3616, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     8770,  8771,
		8772,  8773,  8774,  8775,  8776,  8777,  8778,  8779,
		45,    45,    45,    45,    2477,  2522,  45,    45,
		45,    45,    -13215,-9900, -9900, -6585, -6585, -3270,
		-3270, 45,    45,    45,    45,    45,    8802,  8803,
		0,     0,     45,    45,    45,    45,    8810,  8811,
		0,     0,     45,    2700,  2701,  2702,  2703,  5134,
		2705,  2706,  0,     2708,  0,     -5957, 0,     -5957,
		0,     3312,  3312,  3312,  13053, 7051,  1095,  3314,
		0,     3315,  4896,  0,     3317,  3317,  3317,  3317,
		3317,  3317,  3317,  2720,  3317,  3317,  0,     3318,
		0,     3319,  0,     0,     3321,  8857,  8858,  8859,
		0,     0,     8862,  8863,  2749,  2750,  2751,  0,
		0,     0,     2755,  2756,  2757,  2758,  2759,  2760,
		2761,  2762,  2763,  2764,  2765,  2766,  2767,  -3479,
		-3479, 2770,  2771,  2772,  2773,  2774,  2775,  2776,
		2777,  2778,  2779,  2780,  2781,  1267,  -1961, -1961,
		2785,  2786,  2787,  2788,  2789,  2790,  2791,  2792,
		-1097, -1096, 2795,  2796,  -1094, -1093, 4845,  0,
		-1089, -1088, -1087, 7200,  -1556, -1556, 7248,  7249,
		7205,  1037,  1038,  1039,  -1559, -1559, 7253,  7254,
		7210,  7211,  200,   2803,  7168,  7215,  7216,  7217,
		7218,  7219,  208,   209,   1269,  -1516, -1516, -1516,
		916,   961,   961,   961,   10693, -1520, -14780,218,
		219,   220,   -3514, -3514, -3514, -3514, -3514, -3514,
		-3514, 228,   7241,  7242,  -1561, 8210,  8211,  -1518,
		-1518, 8214,  8215,  9195,  5881,  351,   8219,  8220,
		6448,  6449,  6450,  6451,  3864,  2870,  2871,  12671,
		12627, 0,     0,     0,     0,     0,     12709, 6471,
		12637, 12638, 5627,  8230,  12595, 12642, 2545,  8234,
		12645, 8236,  5634,  3341,  2545,  0,     0,     5749,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     0,     0,     11602,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     1466,
		0,     0,     32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     5760,  0,     0,     0,     0,     0,     32767,
		0,     32767, 0,     0,     32767, 0,     0,     32767,
		0,     3507,  3508,  0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		1644,  1645,  1646,  1647,  -5764, 1649,  1650,  1651,
		1652,  1653,  1654,  1655,  1656,  1657,  1658,  1659,
		1660,  -4081, -4081, -4081, -4081, -4081, -4081, -4081,
		-4081, -4081, -4081, -4081, -4081, -4081, -4081, -4081,
		-4081, 3537,  3538,  1679,  3582,  3583,  3584,  -3482,
		-3482, -3482, -3482, -3482, -3526, -3526, -3526, -3526,
		3886,  -3526, -3526, -3526, -3526, 3599,  3600,  3601,
		3602,  3603,  3604,  3605,  3606,  3607,  3608,  3609,
		3610,  3611,  3612,  3613,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     0,
		-7275, 0,     0,     -7234, 0,     0,     0,     0,
		0,     -5368, 6378,  3628,  3629,  3630,  3631,  3632,
		3633,  3634,  3635,  3636,  3637,  3638,  3639,  0,
		0,     859,   6974,  6974,  0,     0,     3647,  -2405,
		-2405, 3650,  -2405, -2405, -2405, -2405, -112,  -2405,
		-3201, 3658,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 5280,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		4637,  4638,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 4014,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 802,   32767, 32767,
		32767, 32767, 803,   -1055, 805,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 4639,  32767,
		32767, 32767, 806,   -2445, 0,     -2443, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 810,   32767, 32767,
		32767, 32767, 811,   812,   813,   32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -6211, -6211, -6211, -6211, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, -6271, -6271,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 935,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -10300,32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     32767, 32767, 4640,  4641,  32767,
		32767, 32767, 32767, 32767, 4624,  32767, 32767, 32767,
		-4233, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		1859,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 872,   32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -4568, -1253, 32767,
		-3590, 32767, 32767, 32767, -1820, -1820, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 873,   874,   875,   3629,  0,     0,
		0,     5048,  5005,  5006,  5007,  5008,  5009,  5054,
		5055,  5056,  0,     0,     0,     0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -4118,
		32767, 32767, 32767, 32767, -4122, -4122, -4122, -4122,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -4193,
		32767, -4194, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -4209, 32767, 32767, -4211, -4211, -4211,
		-4211, -4211, -4211, -4211, 32767, 32767, -4213, -10683,
		-4213, -1918, -4213, -6043, 32767, 32767, -4215, -6047,
		32767, -4216, -10696,-4216, -4216, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 4646,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 876,   877,   0,     32767, 0,     32767, 0,
		32767, 0,     32767, 0,     32767, 32767, 32767, 0,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 1844,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     -2899, 0,     32767,
		0,     32767, 0,     32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     836,   0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 0,     0,     0,     879,
		880,   881,   882,   883,   884,   885,   886,   0,
		0,     887,   0,     920,   0,     922,   923,   924,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 5431,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     32767, 3639,  889,   890,   891,   892,   893,
		894,   895,   896,   897,   898,   899,   900,   -2739,
		927,   -1881, 4234,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, -459,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -458,
		-457,  904,   32767, 905,   32767, 906,   32767, 907,
		32767, 908,   32767, 32767, 32767, 909,   32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     910,
		0,     0,     0,     0,     0,     0,     911,   0,
		912,   1626,  1626,  913,   914,   1626,  915,   916,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -1837, -1837, -1837,
		-6487, -1837, -1837, 0,     0,     0,     917,   31,
		919,   0,     921,   0,     0,     0,     925,   0,
		32767, 4801,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     -6470, 0,     2295,
		0,     -1830, 0,     -6475, 0,     -1832, 0,     0,
		-6480, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     3665,  0,     0,
		0,     0,     2281,  0,     0,     -7412, 5769,  5770,
		5771,  5772,  5773,  5774,  0,     0,     0,     0,
		32767, 0,     0,     32767, 32767, 0,     32767, 32767,
		0,     0,     32767, 32767, 0,     0,     0,     -1842,
		32767, 0,     0,     0,     -1846, -1846, -2560, -1846,
		0,     -2560, -2559, 0,     0,     32767, 0,     32767,
		0,     0,     0,     0,     0,     0,     1388,  0,
		1387,  1387,  1387,  0,     1387,  1387,  1387,  1387,
		1387,  1387,  1387,  1387,  1387,  1387,  1387,  1387,
		1387,  1387,  1387,  1387,  1387,  1387,  1387,  1387,
		1387,  0,     -1870, 0,     -1871, 0,     0,     0,
		0,     0,     0,     -1877, 0,     0,     -1877, -1877,
		0,     0,     0,     4944,  0,     -1875, 4947,  4948,
		0,     4950,  4951,  4952,  4953,  4954,  4955,  4956,
		4957,  4958,  4959,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		32767, 32767, 0,     0,     0,     0,     32767, 32767,
		32767, 0,     0,     931,   32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 4650,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 5375,
		5376,  5377,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 13180, 0,     0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, -4011, 933,   -4011, 32767,
		935,   936,   -4012, 938,   939,   940,   941,   942,
		943,   944,   945,   946,   947,   32767, 1075,  1076,
		1077,  -6334, 1079,  1080,  954,   32767, 32767, 32767,
		32767, 955,   32767, 32767, 32767, 32767, 32767, 32767,
		-4659, 32767, 32767, 32767, -4662, -4662, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 959,   960,   961,   32767, 962,   963,   964,
		965,   966,   967,   968,   969,   970,   971,   972,
		32767, 973,   974,   975,   976,   977,   978,   979,
		980,   981,   982,   983,   984,   985,   986,   987,
		988,   989,   990,   32767, 991,   992,   993,   994,
		995,   996,   997,   998,   999,   1000,  1001,  1002,
		1003,  1004,  1005,  1006,  1007,  1008,  1009,  1010,
		1011,  1012,  1013,  1014,  1015,  1016,  1017,  -362,
		-362,  32767, 32767, 32767, 32767, -410,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 1019,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		164,   1021,  -3551, -3551, 1024,  1025,  1026,  1027,
		1028,  1029,  1030,  1031,  1032,  1033,  1034,  1035,
		1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,
		1044,  1045,  1046,  1047,  1048,  1049,  1050,  1051,
		1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,
		1060,  1061,  1062,  1063,  1064,  1065,  1066,  1067,
		1068,  1069,  1070,  1071,  1072,  1073,  1074,  1075,
		1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,
		1084,  1085,  1086,  1087,  1088,  1089,  1090,  1091,
		1092,  1093,  1094,  1095,  1096,  1097,  1098,  1099,
		1100,  1101,  1102,  1103,  1104,  1105,  1106,  1107,
		1108,  1109,  1110,  1111,  1112,  1113,  1114,  32767,
		1115,  1116,  1117,  1118,  1119,  32767, 1120,  1121,
		1122,  1123,  1124,  1125,  1126,  1127,  1128,  1129,
		1130,  1131,  0,     1133,  1134,  1135,  1136,  1137,
		1138,  1139,  1140,  1141,  1142,  1143,  1144,  1145,
		1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,
		1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,
		1162,  1163,  1164,  1165,  1166,  1167,  1168,  1169,
		1170,  1171,  1172,  1173,  1174,  1175,  1176,  1177,
		1178,  1179,  1180,  1181,  1182,  1183,  1184,  1185,
		1186,  1187,  1188,  1189,  1190,  1191,  1192,  1193,
		1194,  1195,  1196,  1197,  1198,  1199,  1200,  1201,
		1202,  1203,  1204,  1205,  1206,  1207,  1208,  1209,
		-18956,-15641,1212,  1213,  1214,  1215,  1216,  1217,
		1218,  1219,  1220,  1221,  1222,  1223,  1224,  1225,
		-5682, -5682, -5682, 1229,  1230,  1231,  1232,  1233,
		1234,  1235,  1236,  1237,  1238,  1239,  5750,  5751,
		5752,  5753,  5754,  5755,  5756,  1247,  1248,  1249,
		1250,  1251,  1252,  3084,  3085,  3086,  16347, 13033,
		13034, 9720,  1260,  1261,  1262,  3097,  3098,  3099,
		3100,  3101,  1268,  1269,  1270,  1271,  1272,  1273,
		1274,  1275,  32767, 32767, 32767, 32767, 1276,  1277,
		1278,  1279,  1280,  1281,  1282,  1283,  1284,  1285,
		1286,  1287,  1288,  1289,  1290,  1291,  1292,  1293,
		1294,  1295,  1296,  1297,  1298,  1299,  1300,  1301,
		1302,  1303,  1304,  1305,  1306,  1307,  1308,  1309,
		1310,  1311,  1312,  1313,  1314,  1315,  1316,  1317,
		1318,  1319,  1320,  1321,  1322,  1323,  1324,  1325,
		1326,  1327,  1328,  1329,  1330,  1331,  1332,  1333,
		1334,  1335,  1336,  1337,  1338,  1339,  1340,  1341,
		1342,  3162,  4959,  0,     4962,  1347,  1348,  1349,
		1350,  1351,  1352,  1353,  1354,  1355,  1356,  1357,
		1358,  1359,  1360,  1361,  1362,  1363,  1364,  1365,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 7481,
		7482,  7483,  7484,  5053,  5009,  7487,  7488,  7489,
		7490,  20751, 17437, 17438, 14124, 14125, 10811, 10812,
		7498,  7499,  7500,  7501,  7502,  32767, 32767, 7548,
		7549,  7505,  7506,  7507,  7508,  32767, 32767, 7554,
		7555,  7511,  4857,  4857,  4857,  4857,  2427,  4857,
		4857,  7564,  4857,  7566,  13524, 7568,  13526, 7570,
		4259,  4260,  4261,  -5479, 524,   6481,  4263,  7578,
		4264,  2684,  1421,  -7842, -4527, -4527, -1212, -1212,
		-1212, -1212, -1212, 7545,  7546,  0,     0,     -1214,
		-1214, -1214, -1214, 7551,  7552,  32767, 1610,  -1216,
		1439,  1440,  1441,  1442,  3873,  1444,  1445,  32767,
		1446,  32767, -7220, 32767, -7221, 0,     2047,  2047,
		2047,  11788, 5786,  -170,  2049,  -1265, 2050,  3631,
		-1265, 2052,  2052,  2052,  2052,  2052,  2052,  2052,
		1455,  2052,  2052,  -1265, 2053,  -1265, 2054,  -1265,
		-1265, 2056,  7592,  7593,  7594,  32767, 32767, 7595,
		7596,  1482,  1483,  1484,  -1267, -1267, -1267, 1488,
		1489,  1490,  1491,  1492,  1493,  1494,  1495,  1496,
		1497,  1498,  1499,  1500,  -4746, -4746, 1503,  1504,
		1505,  1506,  1507,  1508,  1509,  1510,  1511,  1512,
		1513,  1514,  0,     -3228, -3228, 1518,  1519,  1520,
		1521,  1522,  1523,  1524,  1525,  -2364, -2363, 1528,
		1529,  -2361, -2360, 3578,  0,     -2357, -2356, -2355,
		5932,  -2824, -2824, 5980,  5981,  5937,  -231,  -230,
		-229,  -2827, -2827, 5985,  -225,  5941,  5942,  -1069,
		1534,  5899,  5946,  5947,  5948,  5949,  5950,  -1061,
		-1060, 0,     -2785, 0,     -355,  -355,  -310,  -310,
		-310,  9422,  -2791, 32767, -1054, -1053, -1052, -4786,
		-4786, -4786, -4786, -4786, -4786, -4786, -1044, 5969,
		5970,  -2833, 6938,  6939,  -2790, -2790, 6942,  0,
		32767, 4607,  -923,  6945,  32767, 5173,  5174,  5175,
		5176,  2589,  1595,  1596,  11396, 11352, 32767, 32767,
		6126,  2812,  2813,  2814,  2815,  2816,  -5940, -5940,
		1607,  1608,  2823,  32767, 32767, 1516,  0,     -8581,
		0,     0,     728,   1525,  163,   -11068,0,     -2262,
		-2306, -2305, 32767, 32767, 0,     0,     1580,  0,
		0,     0,     -6443, 1685,  -10176,-4173, 1784,  -4173,
		0,     -4172, 5925,  -4171, -4171, -4171, 0,     -437,
		0,     0,     0,     161,   -435,  0,     2883,  -434,
		0,     0,     0,     0,     -436,  0,     -5972, 0,
		0,     0,     0,     0,     0,     0,     0,     2889,
		2890,  2891,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     6371,
		0,     0,     0,     0,     0,     0,     0,     117,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     32767, 0,     0,     3991,  3991,
		3991,  3991,  0,     3990,  3990,  3990,  -1947, 1632,
		3990,  3990,  3990,  -4296, 4461,  4462,  -4341, -4341,
		-4296, 1873,  1873,  1873,  4472,  4473,  -4338, 1873,
		-4292, -4292, 2720,  118,   -4246, -4292, -4292, 117,
		-4293, -4293, 2719,  2719,  1660,  4446,  1662,  2018,
		2019,  1975,  1976,  1977,  -7754, -7754, -8733, -5418,
		113,   0,     112,   -2157, -5891, -5891, 0,     -5892,
		6455,  -5893, 0,     0,     0,     32767, 32767, 32767,
		5826,  32767, 32767, 32767, 32767, 6806,  32767, -2039,
		32767, 5829,  32767, 5830,  5831,  5832,  32767, 5833,
		5834,  32767, 5835,  32767, 32767, -3520, 0,     5837,
		0,     5838,  0,     4035,  0,     5840,  32767, 10251,
		154,   1671,  10253, 1673,  1674,  947,   151,   1514,
		12746, 1679,  3942,  3987,  3987,  3987,  13719, 13720,
		14700, 103,   5855,  13723, 5857,  8127,  0,     11862,
		5860,  -96,   5862,  1690,  5863,  -4233, 5864,  5865,
		5866,  5867,  5868,  5869,  5870,  5871,  5872,  5873,
		32767, 5874,  5875,  5876,  5877,  5878,  5879,  5880,
		5881,  5882,  5883,  13795, 5885,  5886,  5887,  5888,
		10489, 5890,  1703,  1704,  -4247, 1706,  1707,  5891,
		5892,  5893,  1711,  4098,  5895,  5896,  5897,  7650,
		32767, 5899,  6406,  7966,  5902,  5903,  5904,  5905,
		5906,  5907,  5908,  1800,  5910,  1801,  5912,  5913,
		5914,  5915,  32767, 1727,  1728,  1729,  1730,  32767,
		1731,  1732,  1733,  32767, 1734,  1735,  1736,  1737,
		1738,  1739,  1740,  32767, 1741,  1742,  1743,  1744,
		1745,  1746,  32767, 32767, 32767, 32767, 1747,  1748,
		1749,  1750,  1751,  32767, 32767, 32767, 32767, 32767,
		32767, 1752,  1753,  1754,  1755,  1756,  1757,  1758,
		1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,
		1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
		1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,
		1783,  1784,  1785,  1786,  1787,  1788,  1789,  1790,
		1791,  7729,  4151,  1794,  1795,  1796,  10083, 1327,
		1327,  10131, 10132, 10088, 3920,  3921,  3922,  1324,
		1324,  10136, 3926,  10092, 10093, 3082,  5685,  10050,
		10097, 0,     5689,  10100, 5691,  3089,  796,   0,
		1363,  12595, 3792,  3792,  3837,  3837,  3837,  13569,
		13570, 14550, 11236, 5706,  13574, 5708,  7978,  11713,
		11714, 11715, 11716, 11717, 11718, 11719, 7978,  966,
		966,   9770,  0,     0,     9730,  9731,  0,     0,
		-979,  2336,  7867,  0,     0,     32767, 0,     0,
		0,     32767, 0,     0,     32767, 0,     32767, 32767,
		9356,  32767, 0,     32767, 0,     32767, 1804,  2602,
		0,     -4364, -4410, 5688,  0,     -4410, 0,     2603,
		4897,  5694,  4332,  -6899, 1905,  1906,  1862,  1863,
		1864,  -7867, -7867, -8846, -5531, 0,     -7867, 0,
		-2269, -6003, -6003, 0,     5957,  0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     -7911, 0,
		0,     0,     0,     -4600, 0,     0,     4156,  32767,
		32767, 0,     0,     0,     0,     0,     1796,  0,
		0,     0,     -1752, 0,     0,     -506,  -2065, 0,
		0,     0,     0,     0,     0,     0,     4109,  0,
		4110,  0,     0,     0,     0,     0,     4111,  17372,
		0,     14058, 10744, 0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     -4650, 0,     0,     4161,  32767,
		32767, 4117,  32767, 4118,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, -7946, 32767, -4632, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -4642,
		-4642, 4123,  4124,  -4687, 0,     0,     -4644, -4644,
		0,     0,     -4646, -4646, 32767, 32767, 32767, 32767,
		32767, 32767, 4084,  4085,  32767, 32767, 1609,  4087,
		32767, 32767, 4088,  17349, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 10092, 4136,
		10094, 4138,  10096, 0,     10097, 10098, 10099, 10100,
		10101, 0,     32767, 32767, 32767, 0,     0,     0,
		0,     0,     0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     0,     0,     0,     0,
		0,     0,     0,     32767, 32767, 0,     10138, 10139,
		0,     0,     0,     10145, 32767, 32767, 32767, 32767,
		32767, 32767, -1425, 8316,  2314,  -3642, 32767, 0,
		32767, 32767, 32767, 32767, -1426, -1426, -1426, -1426,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 52,    52,    52,    52,    52,
		0,     32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1849,  1850,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		100,   101,   102,   103,   104,   105,   106,   107,
		108,   -5633, -5633, -5633, -5633, -5633, -5633, -5633,
		-5633, -5633, -5633, -5633, -5633, -5633, -5633, -5633,
		-5633, 1985,  1986,  127,   2030,  2031,  2032,  -5034,
		32767, 32767, 32767, 32767, 32767, 0,     32767, 32767,
		32767, 5916,  5917,  5918,  5919,  5920,  5921,  5922,
		5923,  5924,  8824,  5926,  32767, 32767, 0,     32767,
		0,     5927,  5928,  5929,  5930,  5931,  5932,  5933,
		5934,  5935,  5936,  5937,  5938,  5939,  5940,  5105,
		5942,  5943,  5944,  5945,  5946,  5947,  5948,  5949,
		5950,  5951,  5952,  5953,  5954,  5955,  5956,  5957,
		32767, 5958,  5959,  5960,  5082,  5082,  5082,  5082,
		5082,  5082,  5082,  5082,  5969,  5970,  5084,  5972,
		5053,  5974,  5053,  5053,  5053,  5978,  5979,  5980,
		5981,  5982,  5983,  5984,  5985,  5986,  5987,  5988,
		5989,  32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2552,  32767, 32767, 32767,
		32767, 32767, 32767, 5990,  5991,  5992,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 5993,  32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 6936,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 1851,  1852,  1853,  1854,
		1855,  1856,  1857,  1858,  1859,  1860,  1861,  1862,
		1863,  1864,  1200,  2121,  1200,  1868,  1869,  1870,
		1871,  1872,  1873,  1874,  1875,  1876,  1877,  1878,
		1879,  1880,  1188,  1188,  1188,  1188,  1188,  1188,
		1188,  1188,  1188,  1188,  1188,  1188,  1188,  1188,
		1188,  1188,  1188,  1188,  1188,  1188,  -5282, 1188,
		3483,  1188,  -642,  1188,  -5287, 1188,  -644,  1188,
		1188,  -5292, 1188,  1188,  1188,  1188,  1188,  1188,
		1188,  1188,  1188,  1188,  1188,  1188,  1925,  1926,
		-6187, -6231, 1184,  3465,  1184,  1184,  -6228, 6953,
		6954,  6955,  6956,  0,     1939,  1940,  1941,  1942,
		1943,  1944,  1178,  1178,  1947,  1948,  1949,  1950,
		1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,
		1959,  1960,  1961,  1962,  1963,  1964,  1965,  1966,
		1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,
		1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,
		1983,  1984,  1985,  1986,  1987,  1988,  1989,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 0,     0,     32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 709,   666,   667,   668,   32767, 669,
		714,   715,   716,   717,   -6694, 719,   720,   721,
		32767, 722,   723,   724,   32767, 725,   726,   727,
		728,   -5013, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 6052,  0,     0,     6055,
		0,     0,     0,     0,     2293,  0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 1244,  1245,  1246,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, -4660,
		-4660, -4660, -4660, 4097,  4098,  -4705, -4705, -4660,
		-4660, -4660, -4660, 4105,  4106,  -4705, 32767, -4661,
		-4661, -4661, -4617, -4617, -4663, -4663, -4663, -4663,
		-4663, -4663, -4663, 4072,  4073,  4074,  4075,  1644,
		1600,  4078,  4079,  4080,  4081,  17342, 14028, 14029,
		10715, 10716, 7402,  7403,  32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 0,     0,
		0,     32767, 0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		32767, 0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     1380,  32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 856,   0,     4573,
		4574,  0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     32767, 0,     0,     0,
		0,     0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		5204,  5161,  5162,  5163,  5164,  5165,  5210,  5211,
		5212,  5213,  -2198, 5215,  5216,  5217,  5218,  5219,
		5220,  5221,  5222,  5223,  5224,  5225,  5226,  -515,
		-515,  -515,  -515,  -515,  -515,  -515,  -515,  -515,
		-515,  -515,  -515,  -515,  -515,  -515,  -515,  7103,
		7104,  5245,  5246,  5247,  5248,  5249,  -1014, 5251,
		5252,  5253,  5254,  5255,  5256,  5257,  5258,  5259,
		5260,  8663,  8664,  -92,   -92,   8712,  8713,  8669,
		8670,  8671,  8672,  -92,   -92,   8720,  8721,  8677,
		8678,  8679,  8636,  8637,  8684,  8685,  8686,  8687,
		8688,  8689,  8690,  -44,   -44,   -44,   -44,   2388,
		2433,  -44,   -44,   -44,   -44,   -13304,-9989, -9989,
		-6674, -6674, -3359, -3359, -44,   -44,   -44,   -44,
		-44,   8713,  8714,  -89,   -89,   -44,   -44,   -44,
		-44,   8721,  8722,  -89,   -89,   -44,   -44,   -44,
		0,     0,     -46,   -46,   -46,   -46,   -46,   -46,
		-46,   8689,  8690,  8691,  8692,  6261,  6217,  8695,
		8696,  8697,  8698,  21959, 18645, 18646, 15332, 15333,
		12019, 12020, 8706,  8707,  8708,  8709,  8710,  -46,
		-46,   8758,  8759,  8715,  8716,  8717,  8718,  -46,
		-46,   8766,  8767,  8723,  8724,  8725,  8726,  8727,
		8728,  8729,  8730,  8731,  8732,  8733,  8734,  0,
		0,     0,     0,     2432,  2477,  0,     0,     0,
		0,     -13260,-9945, -9945, -6630, -6630, -3315, -3315,
		0,     0,     0,     0,     0,     8757,  8758,  -45,
		-45,   0,     0,     0,     0,     8765,  8766,  -45,
		-45,   0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     8735,  8736,  8737,
		8738,  6307,  6263,  8741,  8742,  8743,  8744,  22005,
		18691, 18692, 15378, 15379, 12065, 12066, 8752,  8753,
		8754,  8755,  8756,  0,     0,     8804,  8805,  8761,
		8762,  8763,  8764,  0,     0,     8812,  8813,  8769,
		6115,  6115,  6115,  6115,  3685,  6115,  6115,  8822,
		6115,  8824,  14782, 8826,  14784, 8828,  5517,  5518,
		5519,  -4221, 1782,  7739,  5521,  8836,  5522,  3942,
		8839,  5523,  5524,  5525,  5526,  5527,  5528,  5529,
		6127,  5531,  5532,  8850,  5533,  8852,  5534,  8854,
		8855,  5535,  0,     0,     0,     8860,  8861,  0,
		0,     0,     13252, 9939,  9939,  6626,  6626,  3313,
		3313,  0,     0,     0,     -9269, -3312, 0,     0,
		0,     9741,  32767, 32767, 0,     32767, 0,     32767,
		32767, 0,     0,     0,     0,     0,     0,     0,
		-597,  0,     0,     32767, 0,     32767, 0,     32767,
		32767, 0,     0,     32767, 32767, 32767, 0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     32767, 32767, 0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     -1387, 0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, -1773, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 0,
		0,     0,     0,     0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, -4161, 1581,  1582,  32767, 32767, 1990,  32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 0,     32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 1539,  32767, 32767, 6150,  6151,  6152,  411,
		411,   411,   411,   411,   411,   411,   411,   411,
		411,   411,   411,   411,   411,   411,   411,   8029,
		8030,  6171,  6172,  969,   969,   1013,  1013,  1013,
		1013,  1013,  969,   969,   969,   969,   8381,  969,
		969,   969,   969,   969,   969,   969,   969,   969,
		969,   969,   969,   6711,  6712,  6713,  6714,  6715,
		6716,  6717,  6718,  6719,  6720,  6721,  6722,  6723,
		6724,  6725,  6726,  -891,  -891,  969,   969,   6173,
		6174,  6131,  6132,  6133,  6134,  6135,  6180,  6181,
		6182,  6183,  -1228, 6185,  6186,  6187,  6188,  6189,
		6190,  6191,  6192,  6193,  6194,  6195,  6196,  455,
		455,   455,   455,   455,   455,   455,   455,   455,
		455,   455,   455,   455,   455,   455,   455,   8073,
		8074,  6215,  6216,  1013,  1013,  1057,  1057,  1057,
		1057,  1057,  1013,  1013,  1013,  1013,  8425,  1013,
		1013,  1013,  1013,  1013,  1013,  1013,  1013,  1013,
		1013,  1013,  1013,  6755,  6756,  6757,  6758,  6759,
		6760,  6761,  6762,  6763,  6764,  6765,  6766,  6767,
		6768,  6769,  6770,  -847,  -847,  1013,  1013,  6217,
		6218,  6175,  6176,  6177,  6178,  6179,  6224,  6225,
		6226,  6227,  -1184, 6229,  6230,  6231,  6232,  6233,
		6234,  6235,  6236,  6237,  6238,  6239,  6240,  499,
		499,   499,   499,   499,   499,   499,   499,   499,
		499,   499,   499,   499,   499,   499,   499,   8117,
		8118,  6259,  6260,  6261,  6262,  6263,  0,     6265,
		6266,  6267,  6268,  6269,  6270,  6271,  6272,  6273,
		6274,  9677,  9678,  922,   922,   9726,  9727,  9683,
		9684,  9685,  9686,  922,   922,   9734,  9735,  9691,
		9692,  9693,  9650,  9651,  9698,  9699,  9700,  9701,
		9702,  9703,  9704,  970,   970,   970,   970,   3402,
		3447,  970,   970,   970,   970,   -12290,-8975, -8975,
		-5660, -5660, -2345, -2345, -2345, -2345, -2345, 6412,
		6413,  -2390, -2390, -2345, -2345, -2345, -2345, 6420,
		6421,  -2390, -2390, -2345, -2345, -2345, -2301, -2301,
		-2347, -2347, -2347, -2347, -2347, -2347, -2347, 6388,
		6389,  6390,  6391,  3960,  3916,  6394,  6395,  6396,
		6397,  19658, 16344, 16345, 13031, 13032, 9718,  9719,
		6405,  6406,  6407,  6408,  6409,  -2347, -2347, 6457,
		6458,  6414,  6415,  6416,  6417,  -2347, -2347, 6465,
		6466,  6422,  6423,  6424,  6381,  6382,  6429,  6430,
		6431,  6432,  6433,  6434,  6435,  -2299, -2299, -2299,
		-2299, 133,   178,   -2299, -2299, -2299, -2299, -15559,
		-12244,-12244,-8929, -8929, -5614, -5614, -2299, -2299,
		-2299, -2299, -2299, 6458,  6459,  -2344, -2344, -2299,
		-2299, -2299, -2299, 6466,  6467,  -2344, -2344, -2299,
		-2299, -2299, -2299, -2299, -2299, -2299, -2299, -2299,
		-2299, -2299, -2299, 6436,  6437,  6438,  6439,  4008,
		3964,  6442,  6443,  6444,  6445,  19706, 16392, 16393,
		13079, 13080, 9766,  9767,  6453,  6454,  6455,  6456,
		6457,  -2299, -2299, 6505,  6506,  6462,  6463,  6464,
		6465,  -2299, -2299, 6513,  6514,  6470,  6471,  6472,
		6473,  6474,  6475,  6476,  6477,  6478,  6479,  6480,
		6481,  -2253, -2253, -2253, -2253, 179,   224,   -2253,
		-2253, -2253, -2253, -15513,-12198,-12198,-8883, -8883,
		-5568, -5568, -2253, -2253, -2253, -2253, -2253, 6504,
		6505,  -2298, -2298, -2253, -2253, -2253, -2253, 6512,
		6513,  -2298, -2298, -2253, 402,   403,   404,   405,
		2836,  407,   408,   -2298, 410,   -2298, -8255, -2298,
		-8255, -2298, 1014,  1014,  1014,  10755, 4753,  -1203,
		1016,  -2298, 1017,  2598,  -2298, 1019,  1019,  1019,
		1019,  1019,  1019,  1019,  422,   1019,  1019,  -2298,
		1020,  -2298, 1021,  -2298, -2298, 1023,  6559,  6560,
		6561,  -2298, -2298, 6564,  6565,  6566,  -6685, -3371,
		-3370, -56,   -55,   3259,  3260,  3261,  12531, 6575,
		3264,  3265,  3266,  -6474, -471,  5486,  3268,  6583,
		3269,  1689,  6586,  3270,  3271,  3272,  3273,  3274,
		3275,  3276,  3874,  3278,  3279,  6597,  3280,  6599,
		3281,  6601,  6602,  3282,  3283,  32767, 32767, 32767,
		3284,  3285,  3286,  3287,  3288,  3289,  3290,  3291,
		3292,  3293,  3294,  3295,  3296,  3297,  3298,  3299,
		3300,  3301,  3302,  3303,  3304,  3305,  3306,  3307,
		3308,  3309,  3310,  3311,  3312,  3313,  3314,  3315,
		3316,  3317,  3318,  3319,  3320,  3321,  3322,  3323,
		3324,  3325,  3326,  3327,  3328,  3329,  3330,  3331,
		3332,  3333,  3334,  3335,  3336,  3337,  3338,  3339,
		3340,  3341,  3342,  3343,  3344,  3345,  3346,  3347,
		3348,  3349,  3350,  3351,  32767, 32767, 3352,  3353,
		3354,  3355,  3356,  3357,  3358,  3359,  3360,  3361,
		3362,  3363,  3364,  3365,  3366,  3367,  3368,  3369,
		3370,  3371,  3372,  3373,  3374,  3375,  3376,  3377,
		3378,  3379,  3380,  3381,  3382,  3383,  3384,  3385,
		3386,  3387,  3388,  3389,  3390,  3391,  3392,  3393,
		3394,  3395,  3396,  3397,  3398,  3399,  3400,  3401,
		3402,  3403,  3404,  3405,  3406,  3407,  4795,  3409,
		3410,  3411,  3412,  3413,  3414,  3415,  3416,  3417,
		3418,  3419,  3420,  3421,  3422,  3423,  3424,  3425,
		3426,  3427,  3428,  3429,  3430,  3431,  3432,  3433,
		3434,  3435,  3436,  3437,  3438,  3439,  3440,  3441,
		3442,  3443,  3444,  3445,  3446,  3447,  3448,  3449,
		3450,  3451,  3452,  3453,  3454,  3455,  3456,  3457,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 3458,
		3459,  3460,  3461,  3462,  -8139, 3464,  32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 3465,  3466,  2001,  3468,  3469,  32767,
		32767, 32767, 32767, 32767, 3470,  3471,  3472,  3473,
		3474,  3475,  3476,  3477,  3478,  3479,  3480,  3481,
		3482,  3483,  3484,  3485,  3486,  3487,  3488,  3489,
		3490,  3491,  3492,  3493,  3494,  3495,  32767, 3496,
		3497,  3498,  3499,  3500,  32767, 3501,  32767, 3502,
		3503,  32767, 3504,  3505,  32767, 3506,  0,     0,
		3509,  3510,  3511,  3512,  3513,  3514,  3515,  3516,
		3517,  3518,  3519,  3520,  3521,  3522,  3523,  3524,
		3525,  3526,  3527,  3528,  3529,  3530,  3531,  3532,
		3533,  3534,  3535,  3536,  3537,  3538,  3539,  3540,
		3541,  3542,  3543,  3544,  3545,  1902,  1902,  1902,
		1902,  9314,  1902,  1902,  1902,  1902,  1902,  1902,
		1902,  1902,  1902,  1902,  1902,  1902,  7644,  7645,
		7646,  7647,  7648,  7649,  7650,  7651,  7652,  7653,
		7654,  7655,  7656,  7657,  7658,  7659,  42,    42,
		1902,  0,     0,     0,     7067,  7068,  7069,  7070,
		7071,  7116,  7117,  7118,  7119,  -292,  7121,  7122,
		7123,  7124,  0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     3614,  3615,  3616,  10892, 3618,  3619,
		10854, 3621,  3622,  3623,  3624,  3625,  8994,  -2751,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     3640,  3641,  2783,  -3331,
		-3330, 3645,  3646,  0,     6053,  6054,  0,     6056,
		6057,  6058,  6059,  3767,  6061,  6858,  0,     0,
		3659,  0,     0,     1531,  1531,  1531,  1531,  1531,
		1531,  1531,  1531,  1531,  1531,  1531,  1531,  1531,
		1531,  1531,  9149,  9150,  7291,  7292,  7293,  7294,
		7295,  1032,  7297,  7298,  7299,  7300,  7301,  7302,
		7303,  7304,  0,     7307,  10710, 10711, 1955,  1955,
		10759, 10760, 10716, 4548,  4549,  4550,  1952,  1952,
		10764, 10765, 10721, 10722, 3711,  6314,  10679, 10726,
		10727, 10728, 10729, 10730, 3719,  3720,  1996,  1996,
		1996,  1996,  4428,  4473,  4473,  3728,  1994,  1994,
		-11266,3732,  3733,  3734,  0,     0,     0,     0,
		0,     0,     0,     3742,  10755, 10756, 1953,  1953,
		1998,  1998,  1998,  11730, 11731, 12711, 9397,  3867,
		11735, 3869,  6139,  9874,  9875,  9876,  9877,  9878,
		9879,  9880,  6139,  -873,  -873,  7931,  -1839, -1839,
		7891,  7892,  -1839, -1839, -2818, 497,   6028,  -1839,
		-1839, -66,   -66,   -66,   -66,   2522,  2523,  -6280,
		-6280, -6235, -66,   -66,   -66,   2533,  2534,  -6277,
		-66,   -6231, -6231, 781,   -1821, -6185, -6231, 3867,
		-1821, -6231, -1821, 782,   3076,  3873,  2511,  -8720,
		84,    85,    41,    42,    43,    -9688, -9688, -10667,
		-7352, -1821, -9688, -1821, -4090, -7824, -7824, -7824,
		-7824, -7824, -7824, -7824, -4082, 2931,  2932,  -5871,
		3900,  3901,  -5828, -5828, 3904,  3905,  4885,  1571,
		-3959, 3909,  3910,  2138,  2139,  2140,  2141,  -446,
		-446,  8358,  8359,  8315,  2147,  2148,  2149,  -449,
		-449,  8363,  2153,  8319,  8320,  1309,  3912,  8277,
		8324,  -1773, 3916,  8327,  3918,  1316,  -977,  -1773,
		-410,  10822, 2019,  2019,  2064,  2064,  2064,  11796,
		11797, 12777, 9463,  3933,  11801, 3935,  6205,  9940,
		9941,  9942,  9943,  9944,  9945,  9946,  6205,  -807,
		-807,  7997,  -1773, -1773, 7957,  7958,  -1773, -1773,
		-2752, 563,   6094,  -1773, -1773, 0,     0,     0,
		0,     2588,  2589,  -6214, -6214, -6169, 0,     0,
		0,     2599,  2600,  -6211, 0,     -6165, -6165, 847,
		-1755, -6119, -6165, 3933,  -1755, -6165, -1755, 848,
		3142,  3939,  2577,  -8654, 150,   151,   107,   108,
		109,   -9622, -9622, -10601,-7286, -1755, -9622, -1755,
		-4024, -7758, -7758, -7758, -7758, -7758, -7758, -7758,
		-4016, 2997,  2998,  -5805, 3966,  3967,  -5762, -5762,
		3970,  3971,  4951,  1637,  -3893, 3975,  3976,  2204,
		2205,  2206,  2207,  -380,  -380,  8424,  8425,  8381,
		2213,  2214,  2215,  -383,  -383,  8429,  2219,  8385,
		8386,  1375,  3978,  8343,  8390,  -1707, 3982,  8393,
		3984,  1382,  -911,  -1707, -344,  10888, 2085,  2085,
		2130,  2130,  2130,  11862, 11863, 12843, 9529,  3999,
		11867, 4001,  6271,  10006, 10007, 4005,  -1951, 4007,
		4008,  4009,  4010,  4011,  4012,  4013,  4014,  4015,
		4016,  4017,  4018,  4019,  4020,  4021,  4022,  4023,
		4024,  4025,  4026,  4027,  4028,  4029,  4030,  4031,
		11943, 4033,  4034,  4035,  4036,  8637,  4038,  4039,
		-116,  32767, 32767, 4041,  4042,  4043,  4044,  4045,
		2250,  4047,  4048,  4049,  5802,  4051,  4052,  4559,
		6119,  4055,  4056,  4057,  4058,  4059,  4060,  4061,
		-47,   4063,  -46,   4065,  4066,  4067,  4068,  4069,
		-41,   -13301,4072,  -9985, -6670, 4075,  4076,  4077,
		4078,  4079,  4080,  4081,  4082,  4083,  4084,  4085,
		4086,  4087,  4088,  4089,  4090,  8741,  4092,  4093,
		-67,   32767, 32767, 32767, 32767, 32767, 2257,  32767,
		2258,  2259,  2260,  32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 2261,  32767, 2262,  32767,
		2263,  32767, 2264,  32767, 2265,  32767, 2266,  32767,
		2267,  8737,  8738,  -26,   -26,   8786,  4100,  4101,
		8746,  8747,  4104,  4105,  8752,  8753,  32767, 2274,
		32767, 2275,  32767, 32767, 32767, 32767, 32767, 32767,
		2276,  2277,  32767, 2278,  2279,  32767, 2280,  0,
		32767, 2282,  9695,  4109,  -3486, -3486, 4112,  4113,
		4114,  4115,  4116,  4117,  32767, 32767, 32767, 32767,
		32767, 32767, 4118,  4119,  4120,  4121,  4122,  4123,
		4124,  4125,  4126,  4127,  4128,  4129,  4130,  4131,
		4132,  4133,  4134,  4849,  4136,  4137,  4851,  4851,
		4140,  4852,  4142,  4143,  4144,  4145,  4146,  4147,
		4148,  4149,  4150,  4151,  2293,  4153,  907,   32767,
		2295,  4155,  909,   4157,  910,   4159,  911,   4161,
		912,   4163,  913,   4165,  914,   32767, 915,   4168,
		916,   4170,  917,   4172,  4173,  918,   4175,  4176,
		4177,  4178,  4179,  4180,  4181,  4182,  4183,  4184,
		4185,  2309,  4186,  4187,  4188,  4189,  2312,  2313,
		32767, 2314,  4190,  4191,  -2632, 2317,  4193,  32767,
		4194,  4195,  4196,  4197,  4198,  4199,  4200,  4201,
		4202,  4203,  4204,  4205,  4206,  0,     0,     4209,
		4210,  4211,  4212,  4213,  2318,  4215,  4216,  2319,
		2320,  2321,  2322,  4221,  4222,  4223,  2323,  2324,
		4226,  4227,  4228,  4229,  4230,  4231,  5551,  4233,
		4234,  4235,  4236,  4237,  4238,  4239,  4240,  4241,
		4242,  4243,  4244,  4245,  4246,  4247,  4248,  4249,
		4250,  4251,  4252,  4253,  4254,  4255,  4256,  4257,
		4258,  4259,  4260,  4261,  4262,  4263,  4264,  4265,
		4266,  4267,  4268,  4269,  4270,  4271,  4272,  4273,
		4274,  4275,  -3342, -3342, -3342, 4276,  4277,  2418,
		2419,  -2784, -2784, -2740, -2740, -2740, -2740, -2740,
		-2784, -2784, -2784, -2784, 4628,  -2784, -2784, -2784,
		-2784, -2784, -2784, -2784, -2784, -2784, -2784, -2784,
		-2784, 2958,  2959,  2960,  2961,  2962,  2963,  2964,
		2965,  2966,  2967,  2968,  2969,  2970,  2971,  2972,
		2973,  -4644, -4644, -2784, -2784, 2420,  2421,  2378,
		2379,  2380,  2381,  2382,  2427,  2428,  2429,  2430,
		-4981, 2432,  2433,  2434,  2435,  2436,  2437,  2438,
		2439,  2440,  2441,  2442,  2443,  -3298, -3298, -3298,
		-3298, -3298, -3298, -3298, -3298, -3298, -3298, -3298,
		-3298, -3298, -3298, -3298, -3298, 4320,  4321,  2462,
		4365,  4366,  4367,  -2699, -2699, -2699, -2699, -2699,
		-2743, -2743, -2743, -2743, 4669,  -2743, -2743, -2743,
		-2743, 4382,  4383,  4384,  4385,  4386,  4387,  4388,
		4389,  4390,  4391,  4392,  4393,  4394,  4395,  4396,
		4397,  4398,  4399,  4400,  4401,  4402,  4403,  4404,
		4405,  4406,  4407,  4408,  4409,  4410,  4411,  4412,
		4413,  4414,  4415,  4416,  4417,  4418,  4419,  4420,
		4421,  4422,  4423,  4424,  4425,  4426,  4427,  4428,
		4429,  816,   816,   816,   -6459, 816,   816,   -6418,
		816,   816,   816,   816,   816,   -4552, 7194,  4444,
		4445,  4446,  4447,  4448,  4449,  4450,  4451,  4452,
		4453,  4454,  4455,  816,   816,   1675,  7790,  7790,
		816,   816,   4463,  -1589, -1589, 4466,  -1589, -1589,
		-1589, -1589, 704,   -1589, -2385, 4474,  4475,  817,
		4477,  4478,  2948,  2949,  2950,  2951,  2952,  2953,
		2954,  2955,  2956,  2957,  2958,  2959,  2960,  2961,
		2962,  -4655, -4655, -2795, -2795, -2795, -2795, -2795,
		3469,  -2795, -2795, -2795, -2795, -2795, -2795, -2795,
		-2795, 4510,  -2796, -6198, -6198, 2559,  2560,  -6243,
		-6243, -6198, -6198, -6198, -6198, 2567,  2568,  -6243,
		-6243, -6198, -6198, -6198, -6154, -6154, -6200, -6200,
		-6200, -6200, -6200, -6200, -6200, 2535,  2536,  2537,
		2538,  107,   63,    2541,  2542,  2543,  2544,  15805,
		12491, 12492, 32767, 4540,  4541,  4542,  4543,  4544,
		4545,  4546,  2548,  -6208, -6208, 2596,  2597,  2553,
		2554,  2555,  2556,  -6208, -6208, 2604,  2605,  2561,
		2562,  2563,  2520,  2521,  2568,  2569,  2570,  2571,
		2572,  2573,  2574,  -6160, -6160, -6160, -6160, -3728,
		-3683, -6160, -6160, -6160, -6160, -19420,-16105,-16105,
		-12790,-12790,-9475, -9475, -6160, -6160, -6160, -6160,
		-6160, 32767, 2597,  -6206, -6206, -6161, -6161, -6161,
		-6161, 2604,  2605,  -6206, -6206, -6161, -6161, -6161,
		-6161, -6161, -6161, -6161, -6161, -6161, -6161, -6161,
		-6161, 2574,  2575,  2576,  2577,  146,   102,   2580,
		2581,  2582,  2583,  15844, 12530, 12531, 9217,  9218,
		5904,  5905,  2591,  2592,  2593,  2594,  2595,  -6161,
		-6161, 2643,  2644,  2600,  2601,  2602,  2603,  -6161,
		-6161, 2651,  2652,  2608,  2609,  2610,  2611,  2612,
		2613,  2614,  2615,  2616,  2617,  2618,  2619,  -6115,
		-6115, -6115, -6115, -3683, -3638, -6115, -6115, -6115,
		-6115, -19375,-16060,-16060,-12745,-12745,-9430, -9430,
		-6115, -6115, -6115, -6115, -6115, 2642,  2643,  -6160,
		-6160, -6115, -6115, -6115, -6115, 2650,  2651,  -6160,
		-6160, -6115, -3460, -3459, -3458, -3457, -1026, -3455,
		-3454, -6160, -3452, -6160, -12117,-6160, -12117,-6160,
		-2848, -2848, -2848, 6893,  891,   -5065, -2846, -6160,
		-2845, -1264, 0,     9264,  5950,  5951,  2637,  2638,
		2639,  2640,  2641,  -6115, -6115, 2689,  2690,  2646,
		2647,  2648,  2649,  -6115, -6115, 2697,  2698,  2654,
		0,     0,     0,     0,     -2430, 0,     0,     2707,
		0,     2709,  8667,  2711,  8669,  2713,  -598,  -597,
		-596,  -10336,-4333, 1624,  -594,  2721,  -593,  -2173,
		2724,  -592,  -591,  -590,  -589,  -588,  -587,  -586,
		12,    -584,  -583,  2735,  -582,  2737,  -581,  2739,
		2740,  -580,  -6115, -6115, -6115, 2745,  2746,  -6115,
		-6115, 0,     0,     0,     2752,  2753,  2754,  0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0,     0,     0,     0,     6247,  6248,  0,     0,
		0,     0,     0,     0,     0,     0,     0,     0,
		0
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 4;
	uint32		a = 0;
	uint32		b = 1;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 8191 + c;
	}
	return h[a % 13209] + h[b % 13209];
}

/* Hash lookup information for decomposition */
static const pg_unicode_decompinfo UnicodeDecompInfo =
{
	UnicodeDecompMain,
	Decomp_hash_func,
	6604
};

/* Inverse lookup array -- contains indexes into UnicodeDecompMain[] */
static const uint16 RecompInverseLookup[941] =
{
	/* U+003C+0338 -> U+226E */ 1823,
	/* U+003D+0338 -> U+2260 */ 1820,
	/* U+003E+0338 -> U+226F */ 1824,
	/* U+0041+0300 -> U+00C0 */ 14,
	/* U+0041+0301 -> U+00C1 */ 15,
	/* U+0041+0302 -> U+00C2 */ 16,
	/* U+0041+0303 -> U+00C3 */ 17,
	/* U+0041+0304 -> U+0100 */ 67,
	/* U+0041+0306 -> U+0102 */ 69,
	/* U+0041+0307 -> U+0226 */ 270,
	/* U+0041+0308 -> U+00C4 */ 18,
	/* U+0041+0309 -> U+1EA2 */ 1278,
	/* U+0041+030A -> U+00C5 */ 19,
	/* U+0041+030C -> U+01CD */ 194,
	/* U+0041+030F -> U+0200 */ 240,
	/* U+0041+0311 -> U+0202 */ 242,
	/* U+0041+0323 -> U+1EA0 */ 1276,
	/* U+0041+0325 -> U+1E00 */ 1120,
	/* U+0041+0328 -> U+0104 */ 71,
	/* U+0042+0307 -> U+1E02 */ 1122,
	/* U+0042+0323 -> U+1E04 */ 1124,
	/* U+0042+0331 -> U+1E06 */ 1126,
	/* U+0043+0301 -> U+0106 */ 73,
	/* U+0043+0302 -> U+0108 */ 75,
	/* U+0043+0307 -> U+010A */ 77,
	/* U+0043+030C -> U+010C */ 79,
	/* U+0043+0327 -> U+00C7 */ 20,
	/* U+0044+0307 -> U+1E0A */ 1130,
	/* U+0044+030C -> U+010E */ 81,
	/* U+0044+0323 -> U+1E0C */ 1132,
	/* U+0044+0327 -> U+1E10 */ 1136,
	/* U+0044+032D -> U+1E12 */ 1138,
	/* U+0044+0331 -> U+1E0E */ 1134,
	/* U+0045+0300 -> U+00C8 */ 21,
	/* U+0045+0301 -> U+00C9 */ 22,
	/* U+0045+0302 -> U+00CA */ 23,
	/* U+0045+0303 -> U+1EBC */ 1304,
	/* U+0045+0304 -> U+0112 */ 83,
	/* U+0045+0306 -> U+0114 */ 85,
	/* U+0045+0307 -> U+0116 */ 87,
	/* U+0045+0308 -> U+00CB */ 24,
	/* U+0045+0309 -> U+1EBA */ 1302,
	/* U+0045+030C -> U+011A */ 91,
	/* U+0045+030F -> U+0204 */ 244,
	/* U+0045+0311 -> U+0206 */ 246,
	/* U+0045+0323 -> U+1EB8 */ 1300,
	/* U+0045+0327 -> U+0228 */ 272,
	/* U+0045+0328 -> U+0118 */ 89,
	/* U+0045+032D -> U+1E18 */ 1144,
	/* U+0045+0330 -> U+1E1A */ 1146,
	/* U+0046+0307 -> U+1E1E */ 1150,
	/* U+0047+0301 -> U+01F4 */ 230,
	/* U+0047+0302 -> U+011C */ 93,
	/* U+0047+0304 -> U+1E20 */ 1152,
	/* U+0047+0306 -> U+011E */ 95,
	/* U+0047+0307 -> U+0120 */ 97,
	/* U+0047+030C -> U+01E6 */ 216,
	/* U+0047+0327 -> U+0122 */ 99,
	/* U+0048+0302 -> U+0124 */ 101,
	/* U+0048+0307 -> U+1E22 */ 1154,
	/* U+0048+0308 -> U+1E26 */ 1158,
	/* U+0048+030C -> U+021E */ 268,
	/* U+0048+0323 -> U+1E24 */ 1156,
	/* U+0048+0327 -> U+1E28 */ 1160,
	/* U+0048+032E -> U+1E2A */ 1162,
	/* U+0049+0300 -> U+00CC */ 25,
	/* U+0049+0301 -> U+00CD */ 26,
	/* U+0049+0302 -> U+00CE */ 27,
	/* U+0049+0303 -> U+0128 */ 103,
	/* U+0049+0304 -> U+012A */ 105,
	/* U+0049+0306 -> U+012C */ 107,
	/* U+0049+0307 -> U+0130 */ 111,
	/* U+0049+0308 -> U+00CF */ 28,
	/* U+0049+0309 -> U+1EC8 */ 1316,
	/* U+0049+030C -> U+01CF */ 196,
	/* U+0049+030F -> U+0208 */ 248,
	/* U+0049+0311 -> U+020A */ 250,
	/* U+0049+0323 -> U+1ECA */ 1318,
	/* U+0049+0328 -> U+012E */ 109,
	/* U+0049+0330 -> U+1E2C */ 1164,
	/* U+004A+0302 -> U+0134 */ 114,
	/* U+004B+0301 -> U+1E30 */ 1168,
	/* U+004B+030C -> U+01E8 */ 218,
	/* U+004B+0323 -> U+1E32 */ 1170,
	/* U+004B+0327 -> U+0136 */ 116,
	/* U+004B+0331 -> U+1E34 */ 1172,
	/* U+004C+0301 -> U+0139 */ 118,
	/* U+004C+030C -> U+013D */ 122,
	/* U+004C+0323 -> U+1E36 */ 1174,
	/* U+004C+0327 -> U+013B */ 120,
	/* U+004C+032D -> U+1E3C */ 1180,
	/* U+004C+0331 -> U+1E3A */ 1178,
	/* U+004D+0301 -> U+1E3E */ 1182,
	/* U+004D+0307 -> U+1E40 */ 1184,
	/* U+004D+0323 -> U+1E42 */ 1186,
	/* U+004E+0300 -> U+01F8 */ 232,
	/* U+004E+0301 -> U+0143 */ 126,
	/* U+004E+0303 -> U+00D1 */ 29,
	/* U+004E+0307 -> U+1E44 */ 1188,
	/* U+004E+030C -> U+0147 */ 130,
	/* U+004E+0323 -> U+1E46 */ 1190,
	/* U+004E+0327 -> U+0145 */ 128,
	/* U+004E+032D -> U+1E4A */ 1194,
	/* U+004E+0331 -> U+1E48 */ 1192,
	/* U+004F+0300 -> U+00D2 */ 30,
	/* U+004F+0301 -> U+00D3 */ 31,
	/* U+004F+0302 -> U+00D4 */ 32,
	/* U+004F+0303 -> U+00D5 */ 33,
	/* U+004F+0304 -> U+014C */ 133,
	/* U+004F+0306 -> U+014E */ 135,
	/* U+004F+0307 -> U+022E */ 278,
	/* U+004F+0308 -> U+00D6 */ 34,
	/* U+004F+0309 -> U+1ECE */ 1322,
	/* U+004F+030B -> U+0150 */ 137,
	/* U+004F+030C -> U+01D1 */ 198,
	/* U+004F+030F -> U+020C */ 252,
	/* U+004F+0311 -> U+020E */ 254,
	/* U+004F+031B -> U+01A0 */ 181,
	/* U+004F+0323 -> U+1ECC */ 1320,
	/* U+004F+0328 -> U+01EA */ 220,
	/* U+0050+0301 -> U+1E54 */ 1204,
	/* U+0050+0307 -> U+1E56 */ 1206,
	/* U+0052+0301 -> U+0154 */ 139,
	/* U+0052+0307 -> U+1E58 */ 1208,
	/* U+0052+030C -> U+0158 */ 143,
	/* U+0052+030F -> U+0210 */ 256,
	/* U+0052+0311 -> U+0212 */ 258,
	/* U+0052+0323 -> U+1E5A */ 1210,
	/* U+0052+0327 -> U+0156 */ 141,
	/* U+0052+0331 -> U+1E5E */ 1214,
	/* U+0053+0301 -> U+015A */ 145,
	/* U+0053+0302 -> U+015C */ 147,
	/* U+0053+0307 -> U+1E60 */ 1216,
	/* U+0053+030C -> U+0160 */ 151,
	/* U+0053+0323 -> U+1E62 */ 1218,
	/* U+0053+0326 -> U+0218 */ 264,
	/* U+0053+0327 -> U+015E */ 149,
	/* U+0054+0307 -> U+1E6A */ 1226,
	/* U+0054+030C -> U+0164 */ 155,
	/* U+0054+0323 -> U+1E6C */ 1228,
	/* U+0054+0326 -> U+021A */ 266,
	/* U+0054+0327 -> U+0162 */ 153,
	/* U+0054+032D -> U+1E70 */ 1232,
	/* U+0054+0331 -> U+1E6E */ 1230,
	/* U+0055+0300 -> U+00D9 */ 35,
	/* U+0055+0301 -> U+00DA */ 36,
	/* U+0055+0302 -> U+00DB */ 37,
	/* U+0055+0303 -> U+0168 */ 157,
	/* U+0055+0304 -> U+016A */ 159,
	/* U+0055+0306 -> U+016C */ 161,
	/* U+0055+0308 -> U+00DC */ 38,
	/* U+0055+0309 -> U+1EE6 */ 1346,
	/* U+0055+030A -> U+016E */ 163,
	/* U+0055+030B -> U+0170 */ 165,
	/* U+0055+030C -> U+01D3 */ 200,
	/* U+0055+030F -> U+0214 */ 260,
	/* U+0055+0311 -> U+0216 */ 262,
	/* U+0055+031B -> U+01AF */ 183,
	/* U+0055+0323 -> U+1EE4 */ 1344,
	/* U+0055+0324 -> U+1E72 */ 1234,
	/* U+0055+0328 -> U+0172 */ 167,
	/* U+0055+032D -> U+1E76 */ 1238,
	/* U+0055+0330 -> U+1E74 */ 1236,
	/* U+0056+0303 -> U+1E7C */ 1244,
	/* U+0056+0323 -> U+1E7E */ 1246,
	/* U+0057+0300 -> U+1E80 */ 1248,
	/* U+0057+0301 -> U+1E82 */ 1250,
	/* U+0057+0302 -> U+0174 */ 169,
	/* U+0057+0307 -> U+1E86 */ 1254,
	/* U+0057+0308 -> U+1E84 */ 1252,
	/* U+0057+0323 -> U+1E88 */ 1256,
	/* U+0058+0307 -> U+1E8A */ 1258,
	/* U+0058+0308 -> U+1E8C */ 1260,
	/* U+0059+0300 -> U+1EF2 */ 1358,
	/* U+0059+0301 -> U+00DD */ 39,
	/* U+0059+0302 -> U+0176 */ 171,
	/* U+0059+0303 -> U+1EF8 */ 1364,
	/* U+0059+0304 -> U+0232 */ 282,
	/* U+0059+0307 -> U+1E8E */ 1262,
	/* U+0059+0308 -> U+0178 */ 173,
	/* U+0059+0309 -> U+1EF6 */ 1362,
	/* U+0059+0323 -> U+1EF4 */ 1360,
	/* U+005A+0301 -> U+0179 */ 174,
	/* U+005A+0302 -> U+1E90 */ 1264,
	/* U+005A+0307 -> U+017B */ 176,
	/* U+005A+030C -> U+017D */ 178,
	/* U+005A+0323 -> U+1E92 */ 1266,
	/* U+005A+0331 -> U+1E94 */ 1268,
	/* U+0061+0300 -> U+00E0 */ 40,
	/* U+0061+0301 -> U+00E1 */ 41,
	/* U+0061+0302 -> U+00E2 */ 42,
	/* U+0061+0303 -> U+00E3 */ 43,
	/* U+0061+0304 -> U+0101 */ 68,
	/* U+0061+0306 -> U+0103 */ 70,
	/* U+0061+0307 -> U+0227 */ 271,
	/* U+0061+0308 -> U+00E4 */ 44,
	/* U+0061+0309 -> U+1EA3 */ 1279,
	/* U+0061+030A -> U+00E5 */ 45,
	/* U+0061+030C -> U+01CE */ 195,
	/* U+0061+030F -> U+0201 */ 241,
	/* U+0061+0311 -> U+0203 */ 243,
	/* U+0061+0323 -> U+1EA1 */ 1277,
	/* U+0061+0325 -> U+1E01 */ 1121,
	/* U+0061+0328 -> U+0105 */ 72,
	/* U+0062+0307 -> U+1E03 */ 1123,
	/* U+0062+0323 -> U+1E05 */ 1125,
	/* U+0062+0331 -> U+1E07 */ 1127,
	/* U+0063+0301 -> U+0107 */ 74,
	/* U+0063+0302 -> U+0109 */ 76,
	/* U+0063+0307 -> U+010B */ 78,
	/* U+0063+030C -> U+010D */ 80,
	/* U+0063+0327 -> U+00E7 */ 46,
	/* U+0064+0307 -> U+1E0B */ 1131,
	/* U+0064+030C -> U+010F */ 82,
	/* U+0064+0323 -> U+1E0D */ 1133,
	/* U+0064+0327 -> U+1E11 */ 1137,
	/* U+0064+032D -> U+1E13 */ 1139,
	/* U+0064+0331 -> U+1E0F */ 1135,
	/* U+0065+0300 -> U+00E8 */ 47,
	/* U+0065+0301 -> U+00E9 */ 48,
	/* U+0065+0302 -> U+00EA */ 49,
	/* U+0065+0303 -> U+1EBD */ 1305,
	/* U+0065+0304 -> U+0113 */ 84,
	/* U+0065+0306 -> U+0115 */ 86,
	/* U+0065+0307 -> U+0117 */ 88,
	/* U+0065+0308 -> U+00EB */ 50,
	/* U+0065+0309 -> U+1EBB */ 1303,
	/* U+0065+030C -> U+011B */ 92,
	/* U+0065+030F -> U+0205 */ 245,
	/* U+0065+0311 -> U+0207 */ 247,
	/* U+0065+0323 -> U+1EB9 */ 1301,
	/* U+0065+0327 -> U+0229 */ 273,
	/* U+0065+0328 -> U+0119 */ 90,
	/* U+0065+032D -> U+1E19 */ 1145,
	/* U+0065+0330 -> U+1E1B */ 1147,
	/* U+0066+0307 -> U+1E1F */ 1151,
	/* U+0067+0301 -> U+01F5 */ 231,
	/* U+0067+0302 -> U+011D */ 94,
	/* U+0067+0304 -> U+1E21 */ 1153,
	/* U+0067+0306 -> U+011F */ 96,
	/* U+0067+0307 -> U+0121 */ 98,
	/* U+0067+030C -> U+01E7 */ 217,
	/* U+0067+0327 -> U+0123 */ 100,
	/* U+0068+0302 -> U+0125 */ 102,
	/* U+0068+0307 -> U+1E23 */ 1155,
	/* U+0068+0308 -> U+1E27 */ 1159,
	/* U+0068+030C -> U+021F */ 269,
	/* U+0068+0323 -> U+1E25 */ 1157,
	/* U+0068+0327 -> U+1E29 */ 1161,
	/* U+0068+032E -> U+1E2B */ 1163,
	/* U+0068+0331 -> U+1E96 */ 1270,
	/* U+0069+0300 -> U+00EC */ 51,
	/* U+0069+0301 -> U+00ED */ 52,
	/* U+0069+0302 -> U+00EE */ 53,
	/* U+0069+0303 -> U+0129 */ 104,
	/* U+0069+0304 -> U+012B */ 106,
	/* U+0069+0306 -> U+012D */ 108,
	/* U+0069+0308 -> U+00EF */ 54,
	/* U+0069+0309 -> U+1EC9 */ 1317,
	/* U+0069+030C -> U+01D0 */ 197,
	/* U+0069+030F -> U+0209 */ 249,
	/* U+0069+0311 -> U+020B */ 251,
	/* U+0069+0323 -> U+1ECB */ 1319,
	/* U+0069+0328 -> U+012F */ 110,
	/* U+0069+0330 -> U+1E2D */ 1165,
	/* U+006A+0302 -> U+0135 */ 115,
	/* U+006A+030C -> U+01F0 */ 226,
	/* U+006B+0301 -> U+1E31 */ 1169,
	/* U+006B+030C -> U+01E9 */ 219,
	/* U+006B+0323 -> U+1E33 */ 1171,
	/* U+006B+0327 -> U+0137 */ 117,
	/* U+006B+0331 -> U+1E35 */ 1173,
	/* U+006C+0301 -> U+013A */ 119,
	/* U+006C+030C -> U+013E */ 123,
	/* U+006C+0323 -> U+1E37 */ 1175,
	/* U+006C+0327 -> U+013C */ 121,
	/* U+006C+032D -> U+1E3D */ 1181,
	/* U+006C+0331 -> U+1E3B */ 1179,
	/* U+006D+0301 -> U+1E3F */ 1183,
	/* U+006D+0307 -> U+1E41 */ 1185,
	/* U+006D+0323 -> U+1E43 */ 1187,
	/* U+006E+0300 -> U+01F9 */ 233,
	/* U+006E+0301 -> U+0144 */ 127,
	/* U+006E+0303 -> U+00F1 */ 55,
	/* U+006E+0307 -> U+1E45 */ 1189,
	/* U+006E+030C -> U+0148 */ 131,
	/* U+006E+0323 -> U+1E47 */ 1191,
	/* U+006E+0327 -> U+0146 */ 129,
	/* U+006E+032D -> U+1E4B */ 1195,
	/* U+006E+0331 -> U+1E49 */ 1193,
	/* U+006F+0300 -> U+00F2 */ 56,
	/* U+006F+0301 -> U+00F3 */ 57,
	/* U+006F+0302 -> U+00F4 */ 58,
	/* U+006F+0303 -> U+00F5 */ 59,
	/* U+006F+0304 -> U+014D */ 134,
	/* U+006F+0306 -> U+014F */ 136,
	/* U+006F+0307 -> U+022F */ 279,
	/* U+006F+0308 -> U+00F6 */ 60,
	/* U+006F+0309 -> U+1ECF */ 1323,
	/* U+006F+030B -> U+0151 */ 138,
	/* U+006F+030C -> U+01D2 */ 199,
	/* U+006F+030F -> U+020D */ 253,
	/* U+006F+0311 -> U+020F */ 255,
	/* U+006F+031B -> U+01A1 */ 182,
	/* U+006F+0323 -> U+1ECD */ 1321,
	/* U+006F+0328 -> U+01EB */ 221,
	/* U+0070+0301 -> U+1E55 */ 1205,
	/* U+0070+0307 -> U+1E57 */ 1207,
	/* U+0072+0301 -> U+0155 */ 140,
	/* U+0072+0307 -> U+1E59 */ 1209,
	/* U+0072+030C -> U+0159 */ 144,
	/* U+0072+030F -> U+0211 */ 257,
	/* U+0072+0311 -> U+0213 */ 259,
	/* U+0072+0323 -> U+1E5B */ 1211,
	/* U+0072+0327 -> U+0157 */ 142,
	/* U+0072+0331 -> U+1E5F */ 1215,
	/* U+0073+0301 -> U+015B */ 146,
	/* U+0073+0302 -> U+015D */ 148,
	/* U+0073+0307 -> U+1E61 */ 1217,
	/* U+0073+030C -> U+0161 */ 152,
	/* U+0073+0323 -> U+1E63 */ 1219,
	/* U+0073+0326 -> U+0219 */ 265,
	/* U+0073+0327 -> U+015F */ 150,
	/* U+0074+0307 -> U+1E6B */ 1227,
	/* U+0074+0308 -> U+1E97 */ 1271,
	/* U+0074+030C -> U+0165 */ 156,
	/* U+0074+0323 -> U+1E6D */ 1229,
	/* U+0074+0326 -> U+021B */ 267,
	/* U+0074+0327 -> U+0163 */ 154,
	/* U+0074+032D -> U+1E71 */ 1233,
	/* U+0074+0331 -> U+1E6F */ 1231,
	/* U+0075+0300 -> U+00F9 */ 61,
	/* U+0075+0301 -> U+00FA */ 62,
	/* U+0075+0302 -> U+00FB */ 63,
	/* U+0075+0303 -> U+0169 */ 158,
	/* U+0075+0304 -> U+016B */ 160,
	/* U+0075+0306 -> U+016D */ 162,
	/* U+0075+0308 -> U+00FC */ 64,
	/* U+0075+0309 -> U+1EE7 */ 1347,
	/* U+0075+030A -> U+016F */ 164,
	/* U+0075+030B -> U+0171 */ 166,
	/* U+0075+030C -> U+01D4 */ 201,
	/* U+0075+030F -> U+0215 */ 261,
	/* U+0075+0311 -> U+0217 */ 263,
	/* U+0075+031B -> U+01B0 */ 184,
	/* U+0075+0323 -> U+1EE5 */ 1345,
	/* U+0075+0324 -> U+1E73 */ 1235,
	/* U+0075+0328 -> U+0173 */ 168,
	/* U+0075+032D -> U+1E77 */ 1239,
	/* U+0075+0330 -> U+1E75 */ 1237,
	/* U+0076+0303 -> U+1E7D */ 1245,
	/* U+0076+0323 -> U+1E7F */ 1247,
	/* U+0077+0300 -> U+1E81 */ 1249,
	/* U+0077+0301 -> U+1E83 */ 1251,
	/* U+0077+0302 -> U+0175 */ 170,
	/* U+0077+0307 -> U+1E87 */ 1255,
	/* U+0077+0308 -> U+1E85 */ 1253,
	/* U+0077+030A -> U+1E98 */ 1272,
	/* U+0077+0323 -> U+1E89 */ 1257,
	/* U+0078+0307 -> U+1E8B */ 1259,
	/* U+0078+0308 -> U+1E8D */ 1261,
	/* U+0079+0300 -> U+1EF3 */ 1359,
	/* U+0079+0301 -> U+00FD */ 65,
	/* U+0079+0302 -> U+0177 */ 172,
	/* U+0079+0303 -> U+1EF9 */ 1365,
	/* U+0079+0304 -> U+0233 */ 283,
	/* U+0079+0307 -> U+1E8F */ 1263,
	/* U+0079+0308 -> U+00FF */ 66,
	/* U+0079+0309 -> U+1EF7 */ 1363,
	/* U+0079+030A -> U+1E99 */ 1273,
	/* U+0079+0323 -> U+1EF5 */ 1361,
	/* U+007A+0301 -> U+017A */ 175,
	/* U+007A+0302 -> U+1E91 */ 1265,
	/* U+007A+0307 -> U+017C */ 177,
	/* U+007A+030C -> U+017E */ 179,
	/* U+007A+0323 -> U+1E93 */ 1267,
	/* U+007A+0331 -> U+1E95 */ 1269,
	/* U+00A8+0300 -> U+1FED */ 1584,
	/* U+00A8+0301 -> U+0385 */ 419,
	/* U+00A8+0342 -> U+1FC1 */ 1544,
	/* U+00C2+0300 -> U+1EA6 */ 1282,
	/* U+00C2+0301 -> U+1EA4 */ 1280,
	/* U+00C2+0303 -> U+1EAA */ 1286,
	/* U+00C2+0309 -> U+1EA8 */ 1284,
	/* U+00C4+0304 -> U+01DE */ 210,
	/* U+00C5+0301 -> U+01FA */ 234,
	/* U+00C6+0301 -> U+01FC */ 236,
	/* U+00C6+0304 -> U+01E2 */ 214,
	/* U+00C7+0301 -> U+1E08 */ 1128,
	/* U+00CA+0300 -> U+1EC0 */ 1308,
	/* U+00CA+0301 -> U+1EBE */ 1306,
	/* U+00CA+0303 -> U+1EC4 */ 1312,
	/* U+00CA+0309 -> U+1EC2 */ 1310,
	/* U+00CF+0301 -> U+1E2E */ 1166,
	/* U+00D4+0300 -> U+1ED2 */ 1326,
	/* U+00D4+0301 -> U+1ED0 */ 1324,
	/* U+00D4+0303 -> U+1ED6 */ 1330,
	/* U+00D4+0309 -> U+1ED4 */ 1328,
	/* U+00D5+0301 -> U+1E4C */ 1196,
	/* U+00D5+0304 -> U+022C */ 276,
	/* U+00D5+0308 -> U+1E4E */ 1198,
	/* U+00D6+0304 -> U+022A */ 274,
	/* U+00D8+0301 -> U+01FE */ 238,
	/* U+00DC+0300 -> U+01DB */ 208,
	/* U+00DC+0301 -> U+01D7 */ 204,
	/* U+00DC+0304 -> U+01D5 */ 202,
	/* U+00DC+030C -> U+01D9 */ 206,
	/* U+00E2+0300 -> U+1EA7 */ 1283,
	/* U+00E2+0301 -> U+1EA5 */ 1281,
	/* U+00E2+0303 -> U+1EAB */ 1287,
	/* U+00E2+0309 -> U+1EA9 */ 1285,
	/* U+00E4+0304 -> U+01DF */ 211,
	/* U+00E5+0301 -> U+01FB */ 235,
	/* U+00E6+0301 -> U+01FD */ 237,
	/* U+00E6+0304 -> U+01E3 */ 215,
	/* U+00E7+0301 -> U+1E09 */ 1129,
	/* U+00EA+0300 -> U+1EC1 */ 1309,
	/* U+00EA+0301 -> U+1EBF */ 1307,
	/* U+00EA+0303 -> U+1EC5 */ 1313,
	/* U+00EA+0309 -> U+1EC3 */ 1311,
	/* U+00EF+0301 -> U+1E2F */ 1167,
	/* U+00F4+0300 -> U+1ED3 */ 1327,
	/* U+00F4+0301 -> U+1ED1 */ 1325,
	/* U+00F4+0303 -> U+1ED7 */ 1331,
	/* U+00F4+0309 -> U+1ED5 */ 1329,
	/* U+00F5+0301 -> U+1E4D */ 1197,
	/* U+00F5+0304 -> U+022D */ 277,
	/* U+00F5+0308 -> U+1E4F */ 1199,
	/* U+00F6+0304 -> U+022B */ 275,
	/* U+00F8+0301 -> U+01FF */ 239,
	/* U+00FC+0300 -> U+01DC */ 209,
	/* U+00FC+0301 -> U+01D8 */ 205,
	/* U+00FC+0304 -> U+01D6 */ 203,
	/* U+00FC+030C -> U+01DA */ 207,
	/* U+0102+0300 -> U+1EB0 */ 1292,
	/* U+0102+0301 -> U+1EAE */ 1290,
	/* U+0102+0303 -> U+1EB4 */ 1296,
	/* U+0102+0309 -> U+1EB2 */ 1294,
	/* U+0103+0300 -> U+1EB1 */ 1293,
	/* U+0103+0301 -> U+1EAF */ 1291,
	/* U+0103+0303 -> U+1EB5 */ 1297,
	/* U+0103+0309 -> U+1EB3 */ 1295,
	/* U+0112+0300 -> U+1E14 */ 1140,
	/* U+0112+0301 -> U+1E16 */ 1142,
	/* U+0113+0300 -> U+1E15 */ 1141,
	/* U+0113+0301 -> U+1E17 */ 1143,
	/* U+014C+0300 -> U+1E50 */ 1200,
	/* U+014C+0301 -> U+1E52 */ 1202,
	/* U+014D+0300 -> U+1E51 */ 1201,
	/* U+014D+0301 -> U+1E53 */ 1203,
	/* U+015A+0307 -> U+1E64 */ 1220,
	/* U+015B+0307 -> U+1E65 */ 1221,
	/* U+0160+0307 -> U+1E66 */ 1222,
	/* U+0161+0307 -> U+1E67 */ 1223,
	/* U+0168+0301 -> U+1E78 */ 1240,
	/* U+0169+0301 -> U+1E79 */ 1241,
	/* U+016A+0308 -> U+1E7A */ 1242,
	/* U+016B+0308 -> U+1E7B */ 1243,
	/* U+017F+0307 -> U+1E9B */ 1275,
	/* U+01A0+0300 -> U+1EDC */ 1336,
	/* U+01A0+0301 -> U+1EDA */ 1334,
	/* U+01A0+0303 -> U+1EE0 */ 1340,
	/* U+01A0+0309 -> U+1EDE */ 1338,
	/* U+01A0+0323 -> U+1EE2 */ 1342,
	/* U+01A1+0300 -> U+1EDD */ 1337,
	/* U+01A1+0301 -> U+1EDB */ 1335,
	/* U+01A1+0303 -> U+1EE1 */ 1341,
	/* U+01A1+0309 -> U+1EDF */ 1339,
	/* U+01A1+0323 -> U+1EE3 */ 1343,
	/* U+01AF+0300 -> U+1EEA */ 1350,
	/* U+01AF+0301 -> U+1EE8 */ 1348,
	/* U+01AF+0303 -> U+1EEE */ 1354,
	/* U+01AF+0309 -> U+1EEC */ 1352,
	/* U+01AF+0323 -> U+1EF0 */ 1356,
	/* U+01B0+0300 -> U+1EEB */ 1351,
	/* U+01B0+0301 -> U+1EE9 */ 1349,
	/* U+01B0+0303 -> U+1EEF */ 1355,
	/* U+01B0+0309 -> U+1EED */ 1353,
	/* U+01B0+0323 -> U+1EF1 */ 1357,
	/* U+01B7+030C -> U+01EE */ 224,
	/* U+01EA+0304 -> U+01EC */ 222,
	/* U+01EB+0304 -> U+01ED */ 223,
	/* U+0226+0304 -> U+01E0 */ 212,
	/* U+0227+0304 -> U+01E1 */ 213,
	/* U+0228+0306 -> U+1E1C */ 1148,
	/* U+0229+0306 -> U+1E1D */ 1149,
	/* U+022E+0304 -> U+0230 */ 280,
	/* U+022F+0304 -> U+0231 */ 281,
	/* U+0292+030C -> U+01EF */ 225,
	/* U+0391+0300 -> U+1FBA */ 1537,
	/* U+0391+0301 -> U+0386 */ 420,
	/* U+0391+0304 -> U+1FB9 */ 1536,
	/* U+0391+0306 -> U+1FB8 */ 1535,
	/* U+0391+0313 -> U+1F08 */ 1374,
	/* U+0391+0314 -> U+1F09 */ 1375,
	/* U+0391+0345 -> U+1FBC */ 1539,
	/* U+0395+0300 -> U+1FC8 */ 1550,
	/* U+0395+0301 -> U+0388 */ 422,
	/* U+0395+0313 -> U+1F18 */ 1388,
	/* U+0395+0314 -> U+1F19 */ 1389,
	/* U+0397+0300 -> U+1FCA */ 1552,
	/* U+0397+0301 -> U+0389 */ 423,
	/* U+0397+0313 -> U+1F28 */ 1402,
	/* U+0397+0314 -> U+1F29 */ 1403,
	/* U+0397+0345 -> U+1FCC */ 1554,
	/* U+0399+0300 -> U+1FDA */ 1566,
	/* U+0399+0301 -> U+038A */ 424,
	/* U+0399+0304 -> U+1FD9 */ 1565,
	/* U+0399+0306 -> U+1FD8 */ 1564,
	/* U+0399+0308 -> U+03AA */ 429,
	/* U+0399+0313 -> U+1F38 */ 1418,
	/* U+0399+0314 -> U+1F39 */ 1419,
	/* U+039F+0300 -> U+1FF8 */ 1592,
	/* U+039F+0301 -> U+038C */ 425,
	/* U+039F+0313 -> U+1F48 */ 1432,
	/* U+039F+0314 -> U+1F49 */ 1433,
	/* U+03A1+0314 -> U+1FEC */ 1583,
	/* U+03A5+0300 -> U+1FEA */ 1581,
	/* U+03A5+0301 -> U+038E */ 426,
	/* U+03A5+0304 -> U+1FE9 */ 1580,
	/* U+03A5+0306 -> U+1FE8 */ 1579,
	/* U+03A5+0308 -> U+03AB */ 430,
	/* U+03A5+0314 -> U+1F59 */ 1446,
	/* U+03A9+0300 -> U+1FFA */ 1594,
	/* U+03A9+0301 -> U+038F */ 427,
	/* U+03A9+0313 -> U+1F68 */ 1458,
	/* U+03A9+0314 -> U+1F69 */ 1459,
	/* U+03A9+0345 -> U+1FFC */ 1596,
	/* U+03AC+0345 -> U+1FB4 */ 1532,
	/* U+03AE+0345 -> U+1FC4 */ 1547,
	/* U+03B1+0300 -> U+1F70 */ 1466,
	/* U+03B1+0301 -> U+03AC */ 431,
	/* U+03B1+0304 -> U+1FB1 */ 1529,
	/* U+03B1+0306 -> U+1FB0 */ 1528,
	/* U+03B1+0313 -> U+1F00 */ 1366,
	/* U+03B1+0314 -> U+1F01 */ 1367,
	/* U+03B1+0342 -> U+1FB6 */ 1533,
	/* U+03B1+0345 -> U+1FB3 */ 1531,
	/* U+03B5+0300 -> U+1F72 */ 1468,
	/* U+03B5+0301 -> U+03AD */ 432,
	/* U+03B5+0313 -> U+1F10 */ 1382,
	/* U+03B5+0314 -> U+1F11 */ 1383,
	/* U+03B7+0300 -> U+1F74 */ 1470,
	/* U+03B7+0301 -> U+03AE */ 433,
	/* U+03B7+0313 -> U+1F20 */ 1394,
	/* U+03B7+0314 -> U+1F21 */ 1395,
	/* U+03B7+0342 -> U+1FC6 */ 1548,
	/* U+03B7+0345 -> U+1FC3 */ 1546,
	/* U+03B9+0300 -> U+1F76 */ 1472,
	/* U+03B9+0301 -> U+03AF */ 434,
	/* U+03B9+0304 -> U+1FD1 */ 1559,
	/* U+03B9+0306 -> U+1FD0 */ 1558,
	/* U+03B9+0308 -> U+03CA */ 436,
	/* U+03B9+0313 -> U+1F30 */ 1410,
	/* U+03B9+0314 -> U+1F31 */ 1411,
	/* U+03B9+0342 -> U+1FD6 */ 1562,
	/* U+03BF+0300 -> U+1F78 */ 1474,
	/* U+03BF+0301 -> U+03CC */ 438,
	/* U+03BF+0313 -> U+1F40 */ 1426,
	/* U+03BF+0314 -> U+1F41 */ 1427,
	/* U+03C1+0313 -> U+1FE4 */ 1575,
	/* U+03C1+0314 -> U+1FE5 */ 1576,
	/* U+03C5+0300 -> U+1F7A */ 1476,
	/* U+03C5+0301 -> U+03CD */ 439,
	/* U+03C5+0304 -> U+1FE1 */ 1572,
	/* U+03C5+0306 -> U+1FE0 */ 1571,
	/* U+03C5+0308 -> U+03CB */ 437,
	/* U+03C5+0313 -> U+1F50 */ 1438,
	/* U+03C5+0314 -> U+1F51 */ 1439,
	/* U+03C5+0342 -> U+1FE6 */ 1577,
	/* U+03C9+0300 -> U+1F7C */ 1478,
	/* U+03C9+0301 -> U+03CE */ 440,
	/* U+03C9+0313 -> U+1F60 */ 1450,
	/* U+03C9+0314 -> U+1F61 */ 1451,
	/* U+03C9+0342 -> U+1FF6 */ 1590,
	/* U+03C9+0345 -> U+1FF3 */ 1588,
	/* U+03CA+0300 -> U+1FD2 */ 1560,
	/* U+03CA+0301 -> U+0390 */ 428,
	/* U+03CA+0342 -> U+1FD7 */ 1563,
	/* U+03CB+0300 -> U+1FE2 */ 1573,
	/* U+03CB+0301 -> U+03B0 */ 435,
	/* U+03CB+0342 -> U+1FE7 */ 1578,
	/* U+03CE+0345 -> U+1FF4 */ 1589,
	/* U+03D2+0301 -> U+03D3 */ 444,
	/* U+03D2+0308 -> U+03D4 */ 445,
	/* U+0406+0308 -> U+0407 */ 457,
	/* U+0410+0306 -> U+04D0 */ 479,
	/* U+0410+0308 -> U+04D2 */ 481,
	/* U+0413+0301 -> U+0403 */ 456,
	/* U+0415+0300 -> U+0400 */ 454,
	/* U+0415+0306 -> U+04D6 */ 483,
	/* U+0415+0308 -> U+0401 */ 455,
	/* U+0416+0306 -> U+04C1 */ 477,
	/* U+0416+0308 -> U+04DC */ 487,
	/* U+0417+0308 -> U+04DE */ 489,
	/* U+0418+0300 -> U+040D */ 459,
	/* U+0418+0304 -> U+04E2 */ 491,
	/* U+0418+0306 -> U+0419 */ 461,
	/* U+0418+0308 -> U+04E4 */ 493,
	/* U+041A+0301 -> U+040C */ 458,
	/* U+041E+0308 -> U+04E6 */ 495,
	/* U+0423+0304 -> U+04EE */ 501,
	/* U+0423+0306 -> U+040E */ 460,
	/* U+0423+0308 -> U+04F0 */ 503,
	/* U+0423+030B -> U+04F2 */ 505,
	/* U+0427+0308 -> U+04F4 */ 507,
	/* U+042B+0308 -> U+04F8 */ 509,
	/* U+042D+0308 -> U+04EC */ 499,
	/* U+0430+0306 -> U+04D1 */ 480,
	/* U+0430+0308 -> U+04D3 */ 482,
	/* U+0433+0301 -> U+0453 */ 465,
	/* U+0435+0300 -> U+0450 */ 463,
	/* U+0435+0306 -> U+04D7 */ 484,
	/* U+0435+0308 -> U+0451 */ 464,
	/* U+0436+0306 -> U+04C2 */ 478,
	/* U+0436+0308 -> U+04DD */ 488,
	/* U+0437+0308 -> U+04DF */ 490,
	/* U+0438+0300 -> U+045D */ 468,
	/* U+0438+0304 -> U+04E3 */ 492,
	/* U+0438+0306 -> U+0439 */ 462,
	/* U+0438+0308 -> U+04E5 */ 494,
	/* U+043A+0301 -> U+045C */ 467,
	/* U+043E+0308 -> U+04E7 */ 496,
	/* U+0443+0304 -> U+04EF */ 502,
	/* U+0443+0306 -> U+045E */ 469,
	/* U+0443+0308 -> U+04F1 */ 504,
	/* U+0443+030B -> U+04F3 */ 506,
	/* U+0447+0308 -> U+04F5 */ 508,
	/* U+044B+0308 -> U+04F9 */ 510,
	/* U+044D+0308 -> U+04ED */ 500,
	/* U+0456+0308 -> U+0457 */ 466,
	/* U+0474+030F -> U+0476 */ 470,
	/* U+0475+030F -> U+0477 */ 471,
	/* U+04D8+0308 -> U+04DA */ 485,
	/* U+04D9+0308 -> U+04DB */ 486,
	/* U+04E8+0308 -> U+04EA */ 497,
	/* U+04E9+0308 -> U+04EB */ 498,
	/* U+0627+0653 -> U+0622 */ 574,
	/* U+0627+0654 -> U+0623 */ 575,
	/* U+0627+0655 -> U+0625 */ 577,
	/* U+0648+0654 -> U+0624 */ 576,
	/* U+064A+0654 -> U+0626 */ 578,
	/* U+06C1+0654 -> U+06C2 */ 606,
	/* U+06D2+0654 -> U+06D3 */ 607,
	/* U+06D5+0654 -> U+06C0 */ 605,
	/* U+0928+093C -> U+0929 */ 733,
	/* U+0930+093C -> U+0931 */ 734,
	/* U+0933+093C -> U+0934 */ 735,
	/* U+09C7+09BE -> U+09CB */ 751,
	/* U+09C7+09D7 -> U+09CC */ 752,
	/* U+0B47+0B3E -> U+0B4B */ 770,
	/* U+0B47+0B56 -> U+0B48 */ 769,
	/* U+0B47+0B57 -> U+0B4C */ 771,
	/* U+0B92+0BD7 -> U+0B94 */ 775,
	/* U+0BC6+0BBE -> U+0BCA */ 776,
	/* U+0BC6+0BD7 -> U+0BCC */ 778,
	/* U+0BC7+0BBE -> U+0BCB */ 777,
	/* U+0C46+0C56 -> U+0C48 */ 780,
	/* U+0CBF+0CD5 -> U+0CC0 */ 785,
	/* U+0CC6+0CC2 -> U+0CCA */ 788,
	/* U+0CC6+0CD5 -> U+0CC7 */ 786,
	/* U+0CC6+0CD6 -> U+0CC8 */ 787,
	/* U+0CCA+0CD5 -> U+0CCB */ 789,
	/* U+0D46+0D3E -> U+0D4A */ 793,
	/* U+0D46+0D57 -> U+0D4C */ 795,
	/* U+0D47+0D3E -> U+0D4B */ 794,
	/* U+0DD9+0DCA -> U+0DDA */ 798,
	/* U+0DD9+0DCF -> U+0DDC */ 799,
	/* U+0DD9+0DDF -> U+0DDE */ 801,
	/* U+0DDC+0DCA -> U+0DDD */ 800,
	/* U+1025+102E -> U+1026 */ 859,
	/* U+1B05+1B35 -> U+1B06 */ 904,
	/* U+1B07+1B35 -> U+1B08 */ 905,
	/* U+1B09+1B35 -> U+1B0A */ 906,
	/* U+1B0B+1B35 -> U+1B0C */ 907,
	/* U+1B0D+1B35 -> U+1B0E */ 908,
	/* U+1B11+1B35 -> U+1B12 */ 909,
	/* U+1B3A+1B35 -> U+1B3B */ 911,
	/* U+1B3C+1B35 -> U+1B3D */ 912,
	/* U+1B3E+1B35 -> U+1B40 */ 913,
	/* U+1B3F+1B35 -> U+1B41 */ 914,
	/* U+1B42+1B35 -> U+1B43 */ 915,
	/* U+1E36+0304 -> U+1E38 */ 1176,
	/* U+1E37+0304 -> U+1E39 */ 1177,
	/* U+1E5A+0304 -> U+1E5C */ 1212,
	/* U+1E5B+0304 -> U+1E5D */ 1213,
	/* U+1E62+0307 -> U+1E68 */ 1224,
	/* U+1E63+0307 -> U+1E69 */ 1225,
	/* U+1EA0+0302 -> U+1EAC */ 1288,
	/* U+1EA0+0306 -> U+1EB6 */ 1298,
	/* U+1EA1+0302 -> U+1EAD */ 1289,
	/* U+1EA1+0306 -> U+1EB7 */ 1299,
	/* U+1EB8+0302 -> U+1EC6 */ 1314,
	/* U+1EB9+0302 -> U+1EC7 */ 1315,
	/* U+1ECC+0302 -> U+1ED8 */ 1332,
	/* U+1ECD+0302 -> U+1ED9 */ 1333,
	/* U+1F00+0300 -> U+1F02 */ 1368,
	/* U+1F00+0301 -> U+1F04 */ 1370,
	/* U+1F00+0342 -> U+1F06 */ 1372,
	/* U+1F00+0345 -> U+1F80 */ 1480,
	/* U+1F01+0300 -> U+1F03 */ 1369,
	/* U+1F01+0301 -> U+1F05 */ 1371,
	/* U+1F01+0342 -> U+1F07 */ 1373,
	/* U+1F01+0345 -> U+1F81 */ 1481,
	/* U+1F02+0345 -> U+1F82 */ 1482,
	/* U+1F03+0345 -> U+1F83 */ 1483,
	/* U+1F04+0345 -> U+1F84 */ 1484,
	/* U+1F05+0345 -> U+1F85 */ 1485,
	/* U+1F06+0345 -> U+1F86 */ 1486,
	/* U+1F07+0345 -> U+1F87 */ 1487,
	/* U+1F08+0300 -> U+1F0A */ 1376,
	/* U+1F08+0301 -> U+1F0C */ 1378,
	/* U+1F08+0342 -> U+1F0E */ 1380,
	/* U+1F08+0345 -> U+1F88 */ 1488,
	/* U+1F09+0300 -> U+1F0B */ 1377,
	/* U+1F09+0301 -> U+1F0D */ 1379,
	/* U+1F09+0342 -> U+1F0F */ 1381,
	/* U+1F09+0345 -> U+1F89 */ 1489,
	/* U+1F0A+0345 -> U+1F8A */ 1490,
	/* U+1F0B+0345 -> U+1F8B */ 1491,
	/* U+1F0C+0345 -> U+1F8C */ 1492,
	/* U+1F0D+0345 -> U+1F8D */ 1493,
	/* U+1F0E+0345 -> U+1F8E */ 1494,
	/* U+1F0F+0345 -> U+1F8F */ 1495,
	/* U+1F10+0300 -> U+1F12 */ 1384,
	/* U+1F10+0301 -> U+1F14 */ 1386,
	/* U+1F11+0300 -> U+1F13 */ 1385,
	/* U+1F11+0301 -> U+1F15 */ 1387,
	/* U+1F18+0300 -> U+1F1A */ 1390,
	/* U+1F18+0301 -> U+1F1C */ 1392,
	/* U+1F19+0300 -> U+1F1B */ 1391,
	/* U+1F19+0301 -> U+1F1D */ 1393,
	/* U+1F20+0300 -> U+1F22 */ 1396,
	/* U+1F20+0301 -> U+1F24 */ 1398,
	/* U+1F20+0342 -> U+1F26 */ 1400,
	/* U+1F20+0345 -> U+1F90 */ 1496,
	/* U+1F21+0300 -> U+1F23 */ 1397,
	/* U+1F21+0301 -> U+1F25 */ 1399,
	/* U+1F21+0342 -> U+1F27 */ 1401,
	/* U+1F21+0345 -> U+1F91 */ 1497,
	/* U+1F22+0345 -> U+1F92 */ 1498,
	/* U+1F23+0345 -> U+1F93 */ 1499,
	/* U+1F24+0345 -> U+1F94 */ 1500,
	/* U+1F25+0345 -> U+1F95 */ 1501,
	/* U+1F26+0345 -> U+1F96 */ 1502,
	/* U+1F27+0345 -> U+1F97 */ 1503,
	/* U+1F28+0300 -> U+1F2A */ 1404,
	/* U+1F28+0301 -> U+1F2C */ 1406,
	/* U+1F28+0342 -> U+1F2E */ 1408,
	/* U+1F28+0345 -> U+1F98 */ 1504,
	/* U+1F29+0300 -> U+1F2B */ 1405,
	/* U+1F29+0301 -> U+1F2D */ 1407,
	/* U+1F29+0342 -> U+1F2F */ 1409,
	/* U+1F29+0345 -> U+1F99 */ 1505,
	/* U+1F2A+0345 -> U+1F9A */ 1506,
	/* U+1F2B+0345 -> U+1F9B */ 1507,
	/* U+1F2C+0345 -> U+1F9C */ 1508,
	/* U+1F2D+0345 -> U+1F9D */ 1509,
	/* U+1F2E+0345 -> U+1F9E */ 1510,
	/* U+1F2F+0345 -> U+1F9F */ 1511,
	/* U+1F30+0300 -> U+1F32 */ 1412,
	/* U+1F30+0301 -> U+1F34 */ 1414,
	/* U+1F30+0342 -> U+1F36 */ 1416,
	/* U+1F31+0300 -> U+1F33 */ 1413,
	/* U+1F31+0301 -> U+1F35 */ 1415,
	/* U+1F31+0342 -> U+1F37 */ 1417,
	/* U+1F38+0300 -> U+1F3A */ 1420,
	/* U+1F38+0301 -> U+1F3C */ 1422,
	/* U+1F38+0342 -> U+1F3E */ 1424,
	/* U+1F39+0300 -> U+1F3B */ 1421,
	/* U+1F39+0301 -> U+1F3D */ 1423,
	/* U+1F39+0342 -> U+1F3F */ 1425,
	/* U+1F40+0300 -> U+1F42 */ 1428,
	/* U+1F40+0301 -> U+1F44 */ 1430,
	/* U+1F41+0300 -> U+1F43 */ 1429,
	/* U+1F41+0301 -> U+1F45 */ 1431,
	/* U+1F48+0300 -> U+1F4A */ 1434,
	/* U+1F48+0301 -> U+1F4C */ 1436,
	/* U+1F49+0300 -> U+1F4B */ 1435,
	/* U+1F49+0301 -> U+1F4D */ 1437,
	/* U+1F50+0300 -> U+1F52 */ 1440,
	/* U+1F50+0301 -> U+1F54 */ 1442,
	/* U+1F50+0342 -> U+1F56 */ 1444,
	/* U+1F51+0300 -> U+1F53 */ 1441,
	/* U+1F51+0301 -> U+1F55 */ 1443,
	/* U+1F51+0342 -> U+1F57 */ 1445,
	/* U+1F59+0300 -> U+1F5B */ 1447,
	/* U+1F59+0301 -> U+1F5D */ 1448,
	/* U+1F59+0342 -> U+1F5F */ 1449,
	/* U+1F60+0300 -> U+1F62 */ 1452,
	/* U+1F60+0301 -> U+1F64 */ 1454,
	/* U+1F60+0342 -> U+1F66 */ 1456,
	/* U+1F60+0345 -> U+1FA0 */ 1512,
	/* U+1F61+0300 -> U+1F63 */ 1453,
	/* U+1F61+0301 -> U+1F65 */ 1455,
	/* U+1F61+0342 -> U+1F67 */ 1457,
	/* U+1F61+0345 -> U+1FA1 */ 1513,
	/* U+1F62+0345 -> U+1FA2 */ 1514,
	/* U+1F63+0345 -> U+1FA3 */ 1515,
	/* U+1F64+0345 -> U+1FA4 */ 1516,
	/* U+1F65+0345 -> U+1FA5 */ 1517,
	/* U+1F66+0345 -> U+1FA6 */ 1518,
	/* U+1F67+0345 -> U+1FA7 */ 1519,
	/* U+1F68+0300 -> U+1F6A */ 1460,
	/* U+1F68+0301 -> U+1F6C */ 1462,
	/* U+1F68+0342 -> U+1F6E */ 1464,
	/* U+1F68+0345 -> U+1FA8 */ 1520,
	/* U+1F69+0300 -> U+1F6B */ 1461,
	/* U+1F69+0301 -> U+1F6D */ 1463,
	/* U+1F69+0342 -> U+1F6F */ 1465,
	/* U+1F69+0345 -> U+1FA9 */ 1521,
	/* U+1F6A+0345 -> U+1FAA */ 1522,
	/* U+1F6B+0345 -> U+1FAB */ 1523,
	/* U+1F6C+0345 -> U+1FAC */ 1524,
	/* U+1F6D+0345 -> U+1FAD */ 1525,
	/* U+1F6E+0345 -> U+1FAE */ 1526,
	/* U+1F6F+0345 -> U+1FAF */ 1527,
	/* U+1F70+0345 -> U+1FB2 */ 1530,
	/* U+1F74+0345 -> U+1FC2 */ 1545,
	/* U+1F7C+0345 -> U+1FF2 */ 1587,
	/* U+1FB6+0345 -> U+1FB7 */ 1534,
	/* U+1FBF+0300 -> U+1FCD */ 1555,
	/* U+1FBF+0301 -> U+1FCE */ 1556,
	/* U+1FBF+0342 -> U+1FCF */ 1557,
	/* U+1FC6+0345 -> U+1FC7 */ 1549,
	/* U+1FF6+0345 -> U+1FF7 */ 1591,
	/* U+1FFE+0300 -> U+1FDD */ 1568,
	/* U+1FFE+0301 -> U+1FDE */ 1569,
	/* U+1FFE+0342 -> U+1FDF */ 1570,
	/* U+2190+0338 -> U+219A */ 1801,
	/* U+2192+0338 -> U+219B */ 1802,
	/* U+2194+0338 -> U+21AE */ 1803,
	/* U+21D0+0338 -> U+21CD */ 1804,
	/* U+21D2+0338 -> U+21CF */ 1806,
	/* U+21D4+0338 -> U+21CE */ 1805,
	/* U+2203+0338 -> U+2204 */ 1807,
	/* U+2208+0338 -> U+2209 */ 1808,
	/* U+220B+0338 -> U+220C */ 1809,
	/* U+2223+0338 -> U+2224 */ 1810,
	/* U+2225+0338 -> U+2226 */ 1811,
	/* U+223C+0338 -> U+2241 */ 1816,
	/* U+2243+0338 -> U+2244 */ 1817,
	/* U+2245+0338 -> U+2247 */ 1818,
	/* U+2248+0338 -> U+2249 */ 1819,
	/* U+224D+0338 -> U+226D */ 1822,
	/* U+2261+0338 -> U+2262 */ 1821,
	/* U+2264+0338 -> U+2270 */ 1825,
	/* U+2265+0338 -> U+2271 */ 1826,
	/* U+2272+0338 -> U+2274 */ 1827,
	/* U+2273+0338 -> U+2275 */ 1828,
	/* U+2276+0338 -> U+2278 */ 1829,
	/* U+2277+0338 -> U+2279 */ 1830,
	/* U+227A+0338 -> U+2280 */ 1831,
	/* U+227B+0338 -> U+2281 */ 1832,
	/* U+227C+0338 -> U+22E0 */ 1841,
	/* U+227D+0338 -> U+22E1 */ 1842,
	/* U+2282+0338 -> U+2284 */ 1833,
	/* U+2283+0338 -> U+2285 */ 1834,
	/* U+2286+0338 -> U+2288 */ 1835,
	/* U+2287+0338 -> U+2289 */ 1836,
	/* U+2291+0338 -> U+22E2 */ 1843,
	/* U+2292+0338 -> U+22E3 */ 1844,
	/* U+22A2+0338 -> U+22AC */ 1837,
	/* U+22A8+0338 -> U+22AD */ 1838,
	/* U+22A9+0338 -> U+22AE */ 1839,
	/* U+22AB+0338 -> U+22AF */ 1840,
	/* U+22B2+0338 -> U+22EA */ 1845,
	/* U+22B3+0338 -> U+22EB */ 1846,
	/* U+22B4+0338 -> U+22EC */ 1847,
	/* U+22B5+0338 -> U+22ED */ 1848,
	/* U+3046+3099 -> U+3094 */ 2286,
	/* U+304B+3099 -> U+304C */ 2261,
	/* U+304D+3099 -> U+304E */ 2262,
	/* U+304F+3099 -> U+3050 */ 2263,
	/* U+3051+3099 -> U+3052 */ 2264,
	/* U+3053+3099 -> U+3054 */ 2265,
	/* U+3055+3099 -> U+3056 */ 2266,
	/* U+3057+3099 -> U+3058 */ 2267,
	/* U+3059+3099 -> U+305A */ 2268,
	/* U+305B+3099 -> U+305C */ 2269,
	/* U+305D+3099 -> U+305E */ 2270,
	/* U+305F+3099 -> U+3060 */ 2271,
	/* U+3061+3099 -> U+3062 */ 2272,
	/* U+3064+3099 -> U+3065 */ 2273,
	/* U+3066+3099 -> U+3067 */ 2274,
	/* U+3068+3099 -> U+3069 */ 2275,
	/* U+306F+3099 -> U+3070 */ 2276,
	/* U+306F+309A -> U+3071 */ 2277,
	/* U+3072+3099 -> U+3073 */ 2278,
	/* U+3072+309A -> U+3074 */ 2279,
	/* U+3075+3099 -> U+3076 */ 2280,
	/* U+3075+309A -> U+3077 */ 2281,
	/* U+3078+3099 -> U+3079 */ 2282,
	/* U+3078+309A -> U+307A */ 2283,
	/* U+307B+3099 -> U+307C */ 2284,
	/* U+307B+309A -> U+307D */ 2285,
	/* U+309D+3099 -> U+309E */ 2291,
	/* U+30A6+3099 -> U+30F4 */ 2318,
	/* U+30AB+3099 -> U+30AC */ 2293,
	/* U+30AD+3099 -> U+30AE */ 2294,
	/* U+30AF+3099 -> U+30B0 */ 2295,
	/* U+30B1+3099 -> U+30B2 */ 2296,
	/* U+30B3+3099 -> U+30B4 */ 2297,
	/* U+30B5+3099 -> U+30B6 */ 2298,
	/* U+30B7+3099 -> U+30B8 */ 2299,
	/* U+30B9+3099 -> U+30BA */ 2300,
	/* U+30BB+3099 -> U+30BC */ 2301,
	/* U+30BD+3099 -> U+30BE */ 2302,
	/* U+30BF+3099 -> U+30C0 */ 2303,
	/* U+30C1+3099 -> U+30C2 */ 2304,
	/* U+30C4+3099 -> U+30C5 */ 2305,
	/* U+30C6+3099 -> U+30C7 */ 2306,
	/* U+30C8+3099 -> U+30C9 */ 2307,
	/* U+30CF+3099 -> U+30D0 */ 2308,
	/* U+30CF+309A -> U+30D1 */ 2309,
	/* U+30D2+3099 -> U+30D3 */ 2310,
	/* U+30D2+309A -> U+30D4 */ 2311,
	/* U+30D5+3099 -> U+30D6 */ 2312,
	/* U+30D5+309A -> U+30D7 */ 2313,
	/* U+30D8+3099 -> U+30D9 */ 2314,
	/* U+30D8+309A -> U+30DA */ 2315,
	/* U+30DB+3099 -> U+30DC */ 2316,
	/* U+30DB+309A -> U+30DD */ 2317,
	/* U+30EF+3099 -> U+30F7 */ 2319,
	/* U+30F0+3099 -> U+30F8 */ 2320,
	/* U+30F1+3099 -> U+30F9 */ 2321,
	/* U+30F2+3099 -> U+30FA */ 2322,
	/* U+30FD+3099 -> U+30FE */ 2323,
	/* U+11099+110BA -> U+1109A */ 4588,
	/* U+1109B+110BA -> U+1109C */ 4589,
	/* U+110A5+110BA -> U+110AB */ 4590,
	/* U+11131+11127 -> U+1112E */ 4596,
	/* U+11132+11127 -> U+1112F */ 4597,
	/* U+11347+1133E -> U+1134B */ 4609,
	/* U+11347+11357 -> U+1134C */ 4610,
	/* U+114B9+114B0 -> U+114BC */ 4628,
	/* U+114B9+114BA -> U+114BB */ 4627,
	/* U+114B9+114BD -> U+114BE */ 4629,
	/* U+115B8+115AF -> U+115BA */ 4632,
	/* U+115B9+115AF -> U+115BB */ 4633,
	/* U+11935+11930 -> U+11938 */ 4642
};

/* Perfect hash function for recomposition */
static int
Recomp_hash_func(const void *key)
{
	static const int16 h[1883] = {
		772,   773,   621,   32767, 32767, 387,   653,   196,
		32767, 32767, 855,   463,   -19,   651,   32767, 32767,
		32767, 364,   32767, 32767, -108,  32767, 32767, 32767,
		32767, 0,     -568,  32767, 32767, 32767, 0,     0,
		0,     -103,  364,   0,     210,   732,   0,     0,
		-506,  0,     0,     0,     32767, 32767, 0,     32767,
		407,   -140,  32767, 409,   32767, 772,   0,     86,
		842,   934,   32767, 32767, -499,  -355,  32767, 32767,
		532,   138,   174,   -243,  860,   1870,  742,   32767,
		32767, 339,   32767, 1290,  0,     32767, 32767, 0,
		-449,  -1386, 1633,  560,   561,   32767, 1219,  1004,
		139,   -804,  32767, -179,  141,   579,   1586,  32767,
		32767, 32767, 142,   199,   32767, 32767, 143,   0,
		32767, 32767, 314,   896,   32767, 32767, 428,   129,
		286,   -58,   0,     68,    32767, 0,     244,   -566,
		32767, 32767, 32767, 246,   32767, 32767, 0,     32767,
		32767, 271,   -108,  928,   32767, 715,   32767, 32767,
		-211,  -497,  32767, 0,     1055,  1339,  32767, 0,
		32767, 32767, -968,  -144,  32767, 32767, 248,   32767,
		-161,  32767, 32767, 282,   32767, -372,  0,     2,
		-137,  1116,  32767, 687,   32767, 459,   913,   0,
		461,   879,   -816,  443,   32767, 32767, 462,   1089,
		32767, 1054,  0,     314,   447,   -26,   480,   32767,
		64,    0,     0,     112,   32767, 66,    0,     646,
		603,   22,    -292,  0,     710,   475,   32767, 24,
		-781,  32767, 32767, 32767, 281,   307,   32767, 1289,
		32767, 0,     1064,  -149,  454,   118,   32767, 32767,
		0,     32767, -126,  0,     32767, 32767, 858,   32767,
		32767, 32767, 1029,  886,   665,   209,   0,     26,
		359,   0,     0,     -108,  -508,  -603,  894,   906,
		32767, 32767, 14,    0,     0,     534,   984,   876,
		32767, -93,   110,   -367,  167,   843,   32767, 32767,
		-947,  -290,  169,   0,     0,     32767, -42,   564,
		0,     -927,  32767, 817,   32767, 32767, 32767, 110,
		0,     32767, 32767, -38,   32767, 32767, -101,  694,
		-142,  190,   191,   1288,  32767, -687,  194,   -579,
		534,   -452,  0,     -72,   536,   765,   823,   266,
		-259,  684,   767,   32767, 654,   32767, 32767, 64,
		920,   32767, 32767, 32767, 0,     1653,  0,     0,
		32767, 32767, -452,  -222,  855,   0,     32767, -1153,
		127,   490,   449,   863,   32767, -144,  32767, -379,
		545,   32767, 32767, 32767, 530,   32767, 32767, 1331,
		611,   -612,  332,   545,   -73,   0,     604,   201,
		32767, -279,  338,   836,   340,   408,   32767, -60,
		-358,  32767, 343,   69,    707,   0,     -129,  582,
		32767, 0,     32767, 96,    392,   490,   639,   157,
		-4,    406,   32767, 32767, -571,  1077,  546,   32767,
		551,   0,     0,     0,     32767, 32767, 348,   32767,
		498,   -181,  0,     -433,  1057,  260,   0,     32767,
		32767, 397,   32767, 816,   -130,  32767, 624,   0,
		0,     32767, 32767, 32767, 485,   0,     32767, 32767,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 1222,
		-230,  32767, 797,   -538,  32767, 974,   32767, 32767,
		831,   70,    -658,  145,   0,     147,   0,     32767,
		1295,  32767, 0,     0,     895,   0,     0,     -385,
		491,   -287,  32767, -587,  32767, 32767, 32767, 813,
		-471,  -13,   32767, 32767, 32767, 0,     203,   411,
		470,   0,     -546,  -179,  146,   0,     0,     32767,
		-468,  32767, 0,     0,     32767, 32767, 32767, 211,
		32767, 32767, 0,     32767, 0,     52,    32767, 0,
		32767, 0,     692,   990,   32767, 32767, 32767, 56,
		-507,  784,   951,   0,     32767, 0,     697,   32767,
		187,   0,     32767, 32767, 430,   1209,  682,   32767,
		130,   0,     -25,   0,     -1006, 0,     32767, 214,
		433,   22,    0,     -1119, 32767, 285,   32767, 32767,
		32767, 216,   32767, 32767, 32767, 217,   527,   32767,
		32767, 32767, 829,   485,   419,   717,   620,   731,
		32767, 470,   0,     -145,  -620,  1162,  -644,  848,
		287,   -632,  32767, 32767, 32767, 32767, 381,   32767,
		510,   511,   -554,  -2,    32767, 0,     0,     698,
		32767, 32767, 436,   1154,  32767, 463,   32767, 32767,
		627,   517,   32767, 32767, 854,   579,   723,   396,
		110,   -42,   354,   32767, 664,   32767, 32767, 0,
		0,     32767, 65,    -163,  67,    140,   69,    341,
		70,    71,    402,   73,    623,   544,   624,   417,
		-1375, 648,   32767, -26,   904,   0,     548,   0,
		0,     32767, 32767, 855,   32767, 488,   -524,  599,
		130,   131,   32767, 32767, 542,   -1110, -324,  -462,
		32767, -405,  -440,  0,     0,     629,   850,   0,
		741,   257,   258,   32767, 32767, 0,     32767, 923,
		0,     32767, 0,     32767, 1559,  32767, 32767, 32767,
		671,   32767, 134,   32767, 32767, -336,  -104,  576,
		577,   829,   32767, 32767, 762,   902,   32767, 0,
		32767, 0,     1506,  887,   32767, 636,   601,   2465,
		426,   0,     236,   317,   427,   968,   32767, -975,
		-559,  -343,  341,   32767, 937,   241,   0,     32767,
		32767, 547,   32767, 32767, 32767, 32767, 32767, 789,
		0,     32767, 32767, 32767, 0,     0,     0,     32767,
		-192,  859,   1185,  1153,  69,    32767, 32767, 32767,
		-539,  32767, 32767, 0,     32767, 32767, 32767, 32767,
		640,   578,   32767, 32767, -766,  32767, 32767, 32767,
		32767, 1050,  -572,  32767, 32767, 32767, 32767, 1268,
		32767, 32767, 32767, 754,   32767, 32767, 1640,  179,
		804,   32767, 32767, 32767, 32767, 0,     684,   943,
		1006,  32767, 32767, 652,   0,     32767, 1041,  32767,
		718,   791,   32767, 274,   697,   32767, 32767, 0,
		32767, 32767, 32767, 0,     32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 735,
		0,     32767, 32767, 32767, 275,   358,   688,   32767,
		32767, 32767, 548,   -87,   770,   32767, -42,   0,
		551,   32767, 691,   222,   32767, 32767, 32767, 32767,
		0,     1273,  403,   -121,  806,   553,   554,   163,
		32767, 32767, 892,   825,   32767, 32767, -490,  32767,
		32767, 32767, 32767, 32767, -109,  744,   910,   32767,
		91,    32767, 32767, 0,     0,     32767, 32767, 32767,
		1521,  50,    701,   32767, 32767, 32767, 32767, 164,
		658,   32767, 288,   0,     32767, 0,     51,    0,
		32767, 32767, 32767, 32767, 555,   1547,  32767, 32767,
		595,   585,   429,   32767, -80,   32767, 1258,  0,
		540,   486,   -434,  865,   0,     192,   0,     884,
		0,     0,     0,     175,   555,   0,     32767, 32767,
		0,     32767, -566,  866,   591,   32767, 32767, 32767,
		32767, 32767, 496,   495,   -215,  32767, 849,   -772,
		32767, 32767, 502,   178,   483,   32767, 912,   793,
		794,   0,     32767, 32767, 32767, -556,  499,   838,
		32767, 32767, -506,  331,   0,     0,     -1096, 512,
		880,   0,     774,   -338,  649,   32767, 270,   32767,
		32767, -624,  328,   459,   32767, 32767, 32767, 32767,
		329,   -201,  -835,  813,   -879,  560,   0,     -212,
		-114,  35,    -494,  37,    523,   653,   751,   -653,
		-743,  32767, 1356,  818,   32767, 32767, 856,   0,
		44,    902,   0,     0,     0,     0,     32767, -26,
		526,   795,   456,   32767, 104,   -209,  -341,  133,
		-372,  0,     45,    110,   111,   0,     511,   47,
		114,   32767, 32767, 93,    48,    116,   -1031, -279,
		32767, 192,   0,     32767, 453,   415,   0,     -190,
		32767, 471,   240,   175,   29,    665,   684,   0,
		-11,   -95,   -344,  32767, 245,   148,   0,     530,
		0,     1185,  -615,  -712,  693,   784,   32767, 0,
		-776,  32767, 32767, -813,  0,     0,     0,     207,
		208,   32767, 674,   32767, 742,   -289,  249,   32767,
		520,   929,   -50,   781,   0,     -778,  32767, 0,
		302,   32767, 720,   -465,  0,     32767, 32767, 32767,
		0,     0,     32767, 833,   328,   806,   32767, -403,
		0,     32767, -77,   32767, 0,     441,   930,   32767,
		643,   0,     32767, 1938,  0,     1334,  381,   32767,
		216,   32767, 32767, 0,     32767, 484,   383,   0,
		242,   395,   0,     32767, 32767, 32767, -781,  355,
		356,   32767, 292,   706,   32767, 32767, 32767, 32767,
		32767, -410,  32767, 32767, 782,   32767, 189,   32767,
		32767, 943,   0,     -212,  407,   335,   0,     135,
		32767, 616,   0,     -497,  0,     -67,   853,   32767,
		700,   32767, 0,     32767, 32767, 32767, 32767, 32767,
		32767, 32767, 0,     459,   -48,   32767, 58,    0,
		-856,  1017,  32767, 59,    916,   -731,  32767, 940,
		-855,  347,   650,   0,     678,   32767, 0,     32767,
		32767, 530,   32767, 0,     -80,   32767, -730,  32767,
		1214,  799,   58,    651,   841,   0,     0,     -589,
		-1530, -478,  651,   652,   93,    576,   -1215, 32767,
		125,   32767, 1279,  32767, 32767, 0,     32767, 0,
		-367,  416,   -1236, 32767, 418,   32767, 815,   558,
		559,   781,   419,   32767, 739,   32767, 0,     32767,
		128,   570,   1349,  -298,  -66,   0,     147,   -488,
		32767, 590,   189,   274,   524,   32767, 1082,  -209,
		32767, 423,   32767, 32767, 975,   573,   32767, 424,
		32767, 32767, 1241,  32767, 32767, 32767, 32767, 32767,
		612,   391,   32767, 0,     -803,  1004,  -561,  32767,
		32767, 735,   870,   32767, 0,     32767, 32767, -123,
		99,    210,   600,   1294,  109,   1053,  32767, 307,
		834,   32767, 0,     1651,  32767, 644,   32767, 32767,
		0,     32767, -801,  385,   379,   32767, -368,  32767,
		32767, 830,   0,     32767, 32767, 739,   371,   372,
		-275,  32767, 32767, 331,   -780,  32767, 0,     1229,
		-1462, 913,   266,   827,   125,   32767, 32767, 32767,
		393,   32767, 631,   -33,   -883,  -661,  -204,  6,
		-19,   257,   8,     9,     118,   519,   615,   -541,
		-893,  0,     32767, 0,     1156,  15,    900,   32767,
		32767, 32767, 32767, 32767, 32767, 1022,  376,   0,
		32767, 32767, -972,  676,   840,   -661,  631,   58,
		0,     17,    32767, 0,     -799,  82,    0,     32767,
		32767, 680,   32767, 905,   0,     0,     32767, 32767,
		0,     0,     32767, 0,     828,   386,   802,   0,
		146,   0,     148,   32767, -1146, 0,     150,   151,
		-743,  153,   154,   32767, 32767, 442,   32767, 743,
		0,     0,     746,   0,     32767, 32767, 32767, 98,
		32767, 157,   0,     696,   0,     32767, 32767, -294,
		32767, 158,   159,   32767, 0,     32767, 160,   32767,
		933,   32767, 32767, -50,   759,   824,   162,   672,
		32767, 356,   0,     356,   32767, 32767, 0,     0,
		656,   692,   253,   254,   -374,  102,   256,   32767,
		0,     0,     32767, 32767, 259,   32767, 63,    260,
		510,   261,   32767, 0,     32767, 1061,  32767, 521,
		32767, 32767, 32767, 32767, 32767, 32767, 316,   317,
		846,   0,     32767, -500,  318,   0,     32767, 32767,
		263,   0,     790,   872,   32767, 32767, 32767, 2171,
		264,   32767, 32767, 32767, 32767, 486,   334,   465,
		32767, 466,   32767, 444,   606,   32767, 0,     445,
		320,   -317,  0,     520,   322,   718,   32767, 32767,
		32767, 0,     1013,  32767, 32767, 32767, 32767, 32767,
		32767, 611,   32767, 0,     0,     32767, 32767, -120,
		156,   613,   0,     0,     32767, -68,   32767, 622,
		32767, 32767, 32767, 32767, 32767, 455,   32767, 32767,
		32767, 403,   533,   0,     -161,  405,   95,    96,
		32767, 97,    32767, 0,     29,    0,     32767, 32767,
		30,    32767, 99,    32767, 32767, 0,     161,   32767,
		97,    0,     32,    32767, 32767, 0,     0,     315,
		32767, 32767, 414,   966,   0,     585,   32767, 32767,
		-616,  -256,  171,   172,   666,   101,   562,   563,
		32767, 95,    0,     0,     1492,  390,   -251,  103,
		32767, 0,     32767, 188,   1487,  32767, 0,     0,
		586,   668,   -126,  0,     0,     32767, 32767, 204,
		32767, 32767, 32767, 32767, 32767, 32767, 32767, 32767,
		32767, 32767, 32767, 32767, 32767, 656,   32767, 32767,
		599,   0,     222,   32767, 0,     1368,  -412,  435,
		32767, 936,   32767, -17,   32767, 832,   32767, 437,
		0,     -518,  787,   32767, 864,   -449,  0,     636,
		713,   206,   592,   572,   0,     483,   -139,  32767,
		32767, 180,   818,   32767, 32767, 1304,  0,     32767,
		274,   0,     0,     0,     0,     705,   32767, 32767,
		32767, 0,     -272,  0,     502,   503,   319,   0,
		32767, 0,     13,    32767, 32767, 0,     32767, 270,
		737,   0,     32767, 32767, 32767, 901,   32767, 616,
		180,   32767, 721,   353,   32767, 0,     32767, 32767,
		-199,  0,     280,   788,   32767, 940,   32767, 51,
		0,     400,   53,    0,     54,    -637,  0,     -453,
		0,     0,     0,     380,   0,     32767, 504,   0,
		2049,  0,     -964,  32767, 0,     32767, 32767, 32767,
		32767, 32767, 32767, 798,   32767, 32767, 32767, 0,
		538,   488,   0,     32767, -528,  57,    819,   32767,
		32767, 1244,  0,     488,   739,   908,   32767, 32767,
		0,     32767, 32767, 0,     55,    533,   0,     32767,
		814,   0,     32767, 458,   0,     32767, 32767, 32767,
		32767, 32767, 32767, 32767, 776,   777,   920,   0,
		0,     755,   32767, 0,     32767, 32767, 0,     32767,
		55,    -954,  0,     372,   166,   218,   165,   857,
		221,   675,   0,     223,   224,   -155,  226,   32767,
		1851,  227,   32767, 32767, 1192,  0,     229,   0,
		-72,   0,     865,   0,     0,     -330,  0,     683,
		32767, -550,  -196,  725,   -573,  293,   102,   32767,
		-589,  296,   297,   298,   231,   -256,  300,   32767,
		32767, 301,   233,   868,   32767, 234,   0,     811,
		1187,  32767, 32767, 0,     32767, 518,   0,     361,
		362,   466,   0,     365,   32767, -179,  366,   367,
		874,   369,   305,   0,     32767, 0,     32767, 0,
		32767, 2000,  1215,  451,   652,   0,     0,     799,
		32767, 32767, 32767
	};

	const unsigned char *k = (const unsigned char *) key;
	size_t		keylen = 8;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++;

		a = a * 257 + c;
		b = b * 17 + c;
	}
	return h[a % 1883] + h[b % 1883];
}

/* Hash lookup information for recomposition */
static const pg_unicode_recompinfo UnicodeRecompInfo =
{
	RecompInverseLookup,
	Recomp_hash_func,
	941
};
