.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "UNLISTEN" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
UNLISTEN \- Stop listening for notification
.SH SYNOPSIS
.sp
.nf
UNLISTEN { \fInotifyname\fR | * }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fInotifyname\fB\fR
Name of previously registered notify condition.
.TP
\fB*\fR
All current listen registrations for this backend are cleared.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBUNLISTEN\fR
Acknowledgement that statement has executed.
.PP
.SH "DESCRIPTION"
.PP
\fBUNLISTEN\fR
is used to remove an existing \fBNOTIFY\fR registration.
UNLISTEN cancels any existing registration of the current
Postgres session as a listener on the notify
condition \fInotifyname\fR.
The special condition wildcard "*" cancels all listener registrations
for the current session.
.PP
\fBnotify\fR(l)
contains a more extensive
discussion of the use of \fBLISTEN\fR and
\fBNOTIFY\fR.
.SS "NOTES"
.PP
\fIclassname\fR
needs not to be a valid class name but can be any string valid
as a name up to 32 characters long.
.PP
The backend does not complain if you UNLISTEN something you were not
listening for.
Each backend will automatically execute \fBUNLISTEN *\fR when
exiting.
.PP
A restriction in some previous releases of
Postgres that a
\fIclassname\fR
which does not correspond to an actual table must be enclosed in double-quotes
is no longer present.
.SH "USAGE"
.PP
To subscribe to an existing registration:
.sp
.nf
postgres=> LISTEN virtual;
LISTEN
postgres=> NOTIFY virtual;
NOTIFY
ASYNC NOTIFY of 'virtual' from backend pid '12317' received
   
.sp
.fi
.PP
Once UNLISTEN has been executed, further NOTIFY commands will be
ignored:
.sp
.nf
postgres=> UNLISTEN virtual;
UNLISTEN
postgres=> NOTIFY virtual;
NOTIFY
-- notice no NOTIFY event is received
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBUNLISTEN\fR in SQL92.
