.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /cvsroot/pgsql/src/man/Attic/copy.l,v 1.2 1996/12/11 00:27:09 momjian Exp $
.TH COPY SQL 11/05/95 PostgreSQL PostgreSQL
.SH NAME
copy \(em copy data to or from a class from or to a Unix file.
.SH SYNOPSIS
.nf
\fBcopy\fP [\fBbinary\fP] classname [\fBwith oids\fP]
	\fBto\fP|\fBfrom '\fPfilename\fB'\fP|\fBstdin\fR|\fBstdout\fR
	[\fBusing delimiters '\fPdelim\fB'\fP]
.fi
.SH DESCRIPTION
.BR Copy
moves data between Postgres classes and standard Unix files.  The
keyword
.BR binary
changes the behavior of field formatting, as described below.
.IR Classname
is the name of an existing class.
The keyword
.BR "with oids"
copies the internal unique object id (OID) for each row.
.IR Classname
is the name of an existing class.
.IR Filename
is the absolute Unix pathname of the file.  In place of a filename, the
keywords
.BR "stdin" " and " "stdout"
can be used so that input to
.BR copy
can be written by a Libpq application and output from the
.BR copy
command can be read by a Libpq application.
.PP
The
.BR binary
keyword will force all data to be stored/read as binary objects rather
than as ASCII text.  It is somewhat faster than the normal
.BR copy
command, but is not generally portable, and the files generated are
somewhat larger, although this factor is highly dependent on the data
itself.
When copying in, the
.BR "with oids"
keyword should only be used on an empty database because
the loaded oids could conflict with existing oids.
By default, a ASCII
.BR copy
uses a tab (\\t) character as a delimiter.  The delimiter may also be changed
to any other single-character with the use of 
.BR "using delimiters" .
Characters in data fields which happen to match the delimiter character
will be quoted.
.PP
You must have read access on any class whose values are read by the
.BR copy
command, and either write or append access to a class to which values
are being appended by the
.BR copy
command.
.SH FORMAT OF OUTPUT FILES
.SS "ASCII COPY FORMAT"
When
.BR copy
is used without the
.BR binary
keyword, the file generated will have each instance on a line, with
each attribute separated by the delimiter character.  Embedded delimiter
characters will be preceeded by a backslash character (\\).  The
attribute values themselves are strings generated by the output function
associated with each attribute type.  The output function for a type
should not try to generate the backslash character; this will be handled
by 
.BR copy
itself.
.PP
The actual format for each instance is
.nf
<attr1><tab><attr2><tab>...<tab><attrn><newline>
.fi
The oid is placed on the beginning of the line if specified.
.PP
If 
.BR copy
is sending its output to standard output instead of a file, it will
send a backslash(\\) and a period (.) followed immediately by a newline,
on a line by themselves, when it is done.  Similarly, if
.BR copy
is reading from standard input, it will expect a backslash (\\) and
a period (.) followed
by a newline, as the first three characters on a line, to denote
end-of-file.  However,
.BR copy
will terminate (followed by the backend itself) if a true EOF is
encountered.
.PP
The backslash character has special meaning.
.BR NULL
attributes are output as \\N.
A literal backslash character is output as two consecutive backslashes.
A literal tab character is represented as a backslash and a tab.
A literal newline character is represented as a backslash and a newline.
When loading ASCII data not generated by PostgreSQL, you will need to
convert backslash characters (\\) to double-backslashes (\\\\) so
they are loaded properly.
.SS "BINARY COPY FORMAT"
In the case of
.BR "copy binary" ,
the first four bytes in the file will be the number of instances in
the file.  If this number is
.IR zero,
the
.BR "copy binary"
command will read until end of file is encountered.  Otherwise, it
will stop reading when this number of instances has been read.
Remaining data in the file will be ignored.
.PP
The format for each instance in the file is as follows.  Note that
this format must be followed
.BR EXACTLY .
Unsigned four-byte integer quantities are called uint32 in the below
description.
.nf
The first value is:
	uint32 number of tuples
then for each tuple:
	uint32 total length of data segment
	uint32 oid (if specified)
	uint32 number of null attributes
	[uint32 attribute number of first null attribute
	 ...
	 uint32 attribute number of nth null attribute],
	<data segment>
.fi
.bp
.SS "ALIGNMENT OF BINARY DATA"
On Sun-3s, 2-byte attributes are aligned on two-byte boundaries, and
all larger attributes are aligned on four-byte boundaries.  Character
attributes are aligned on single-byte boundaries.  On other machines,
all attributes larger than 1 byte are aligned on four-byte boundaries.
Note that variable length attributes are preceded by the attribute's
length; arrays are simply contiguous streams of the array element
type.
.SH "SEE ALSO"
insert(l), create table(l), vacuum(l), libpq.
.SH BUGS
Files used as arguments to the
.BR copy
command must reside on or be accessible to the the database server
machine by being either on local disks or a networked file system.
.PP
.BR Copy
stops operation at the first error.  This should not lead to problems
in the event of a
.BR "copy from" ,
but the target relation will, of course, be partially modified in a
.BR "copy to" .
The 
.IR vacuum (l)
query should be used to clean up after a failed
.BR "copy" .
.PP
Because Postgres operates out of a different directory than the user's
working directory at the time Postgres is invoked, the result of copying
to a file \*(lqfoo\*(rq (without additional path information) may
yield unexpected results for the naive user.  In this case,
\*(lqfoo\*(rq will wind up in
.SM $PGDATA\c
/foo.  In general, the full pathname should be used when specifying
files to be copied.
.PP
.BR Copy
has virtually no error checking, and a malformed input file will
likely cause the backend to crash.  You should avoid using 
.BR copy
for input whenever possible.
