use DynaLoader;
use Config;
use ExtUtils::Embed;

#
# massage the ld options
#
my $ldopts = ldopts();
chomp($ldopts);

#
# get the location of the Opcode module
#
my $opcode = '';
{

	$modname = 'Opcode';

	my $dir;
	foreach (@INC) {
		if (-d "$_/auto/$modname") {
			$dir = "$_/auto/$modname";
			last;
		}
	}

	if (defined $dir) {
		$opcode = DynaLoader::dl_findfile("-L$dir", $modname);
	}

}

open(MAKEFILE, ">Makefile");

print MAKEFILE <<_STATIC_;
#-------------------------------------------------------------------------
#
# Makefile
#    Makefile for the plperl shared object
#
# AUTOGENERATED Makefile.pl
#

#
# Tell make where the postgresql sources live
#
SRCDIR= ../../../src
include \$(SRCDIR)/Makefile.global

EXTDIR= $Config{privlib}/ExtUtils

XSUBPP= \$(EXTDIR)/xsubpp

TYPEMAP= -typemap \$(EXTDIR)/typemap

# use the same compiler as perl did
CC= $Config{cc}

# get the compiler options that perl wants.
CFLAGS+= @{[ccopts()]}
# including the ones for dynamic loading
CFLAGS+= $Config{cccdlflags}

# add the includes for postgreSQL
CFLAGS+= -I\$(LIBPQDIR) -I\$(SRCDIR)/include

# For fmgr.h
CFLAGS+= -I\$(SRCDIR)/backend


# add the postgreSQL libraries
LDADD+= -L\$(LIBPQDIR) -lpq

LDFLAGS+= $Config{lddlflags} \\
	$ldopts \\
	-lperl

#
# DLOBJS is the dynamically-loaded object file.
#
DLOBJS= plperl\$(DLSUFFIX)

INFILES= \$(DLOBJS) 

SHLIB_EXTRA_LIBS+= $opcode

#
# plus exports files
#
ifdef EXPSUFF
INFILES+= \$(DLOBJS:.o=\$(EXPSUFF))
endif

%.so: %.o
	\$(CC) -o \$@ \$< \$(LDFLAGS) \$(SHLIB_EXTRA_LIBS) \$(LDADD)


#
# Build the shared lib
#
all:	 plperl

plperl : plperl.o SPI.o
	\$(CC) -o plperl.so plperl.o SPI.o \$(SHLIB_EXTRA_LIBS) \$(LDADD) \$(LDFLAGS)

%.o : %.c
	\$(CC) -c \$(CFLAGS) \$<

%.o : %.xs
	\$(XSUBPP) \$(TYPEMAP) \$< > xtmp.c
	\$(CC) -c \$(CFLAGS) -o \$@ xtmp.c


#
# Clean 
#
clean:
	rm -f \$(INFILES) *.o
	rm -rf .libs
	rm -f Makefile

dep depend:

_STATIC_
