.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_LANGUAGE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE LANGUAGE \- Defines a new language for functions
.SH SYNOPSIS
.sp
.nf
CREATE [ TRUSTED ] PROCEDURAL LANGUAGE '\fIlangname\fR'
    HANDLER \fIcall_handler\fR
    LANCOMPILER '\fIcomment\fR'
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTRUSTED\fR
\fBTRUSTED\fR specifies that the call handler for
the language is safe; that is, it offers an unprivileged user
no functionality to bypass access restrictions. If
this keyword is omitted when registering the language,
only users with the Postgres
superuser privilege can use
this language to create new functions
(like the 'C' language). 
.TP
\fB\fIlangname\fB\fR
The name of the new procedural language.
The language name is case insensitive. A procedural 
language cannot override one of the built-in languages of
Postgres.
.TP
\fBHANDLER \fIcall_handler\fB\fR
\fIcall_handler\fR is the name
of a previously
registered function that will be called to execute the PL
procedures.
.TP
\fB\fIcomment\fB\fR
The \fBLANCOMPILER\fR argument is the
string that will be
inserted in the LANCOMPILER attribute
of the new
\fIpg_language\fR entry. At present,
Postgres does not use
this attribute in any way.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
This message is returned if the language is successfully
created.
.TP
\fBERROR: PL handler function \fIfuncname\fB() doesn't exist\fR
This error is returned if the function
\fIfuncname\fR()
is not found.
.PP
.SH "DESCRIPTION"
.PP
Using \fBCREATE LANGUAGE\fR, a 
Postgres user can register
a new language with Postgres. 
Subsequently, functions and
trigger procedures can be defined in this new language.
The user must have the Postgres
superuser privilege to
register a new language.
.SS "WRITING PL HANDLERS"
.PP
The call handler for a procedural language must be written
in a compiler language such as 'C' and registered with
Postgres as a function taking
no arguments and returning the
\fBopaque\fR type, a placeholder for unspecified or undefined types..
This prevents the call handler from being
called directly as a function from queries.
.PP
However, arguments must be supplied on the actual call when a
PL function or trigger
procedure in the language offered by the handler is to be
executed.
.TP 0.2i
\(bu
When called from the trigger manager, the only argument is
the object ID from the procedure's \fIpg_proc\fR
entry. All other
information from the trigger manager is found in the
global CurrentTriggerData pointer.
.TP 0.2i
\(bu
When called from the function manager, the arguments are
the object ID of the procedure's \fIpg_proc\fR
entry, the number
of arguments given to the PL function, the arguments in a
FmgrValues structure and a pointer
to a boolean where the
function tells the caller if the return value is the SQL
NULL value.
.PP
.PP
It's up to the call handler to fetch the
\fIpg_proc\fR entry and
to analyze the argument and return types of the called
procedure. The AS clause from the
\fBCREATE FUNCTION\fR of
the procedure will be found in the prosrc
attribute of the
\fIpg_proc\fR table entry. This may be the
source text in the procedural
language itself (like for PL/Tcl), a pathname to a
file or anything else that tells the call handler what to
do in detail.
.SS "NOTES"
.PP
Use \fBCREATE FUNCTION\fR
to create a function.
.PP
Use \fBDROP LANGUAGE\fR to drop procedural languages.
.PP
Refer to the table \fIpg_language\fR
for further information:
.sp
.nf
     Table    = pg_language
+--------------------------+--------------------------+-------+
|          Field           |          Type            | Length|
+--------------------------+--------------------------+-------+
| lanname                  | name                     |    32 |
| lancompiler              | text                     |   var |
+--------------------------+--------------------------+-------+

lanname |lancompiler   
--------+--------------
internal|n/a           
lisp    |/usr/ucb/liszt
C       |/bin/cc       
sql     |postgres
     
    
.sp
.fi
.PP
Since the call handler for a procedural language must be
registered with Postgres in the 'C' language,
it inherits
all the capabilities and restrictions of 'C' functions.
.PP
At present, the definitions for a procedural language cannot be
changed once they have been created.
.SH "USAGE"
.PP
This is a template for a PL handler written in 'C':
.sp
.nf
#include "executor/spi.h"
#include "commands/trigger.h"
#include "utils/elog.h"
#include "fmgr.h"        /* for FmgrValues struct */
#include "access/heapam.h"
#include "utils/syscache.h"
#include "catalog/pg_proc.h"
#include "catalog/pg_type.h"

Datum
plsample_call_handler(
     Oid       prooid,
     int       pronargs,
     FmgrValues     *proargs,
     bool      *isNull)
{
     Datum          retval;
     TriggerData    *trigdata;

     if (CurrentTriggerData == NULL) {
          /*
           * Called as a function
           */

          retval = ...
     } else {
          /*
           * Called as a trigger procedure
           */
          trigdata = CurrentTriggerData;
          CurrentTriggerData = NULL;

          retval = ...
     }

     *isNull = false;
     return retval;
}
   
.sp
.fi
.PP
Only a few thousand lines of code have to be added instead
of the dots to complete the PL call handler. 
See \fBCREATE FUNCTION\fR for information on how to compile
it into a loadable module.
.PP
The following commands then register the sample procedural
language:
.sp
.nf
CREATE FUNCTION plsample_call_handler () RETURNS opaque
    AS '/usr/local/pgsql/lib/plsample.so'
    LANGUAGE 'C';
CREATE PROCEDURAL LANGUAGE 'plsample'
    HANDLER plsample_call_handler
    LANCOMPILER 'PL/Sample';
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE LANGUAGE\fR
is a Postgres extension.
There is no \fBCREATE LANGUAGE\fR statement in
SQL92.
