.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "SET" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
SET \- Set run-time parameters for session
.SH SYNOPSIS
.sp
.nf
SET \fIvariable\fR { TO | = } { '\fIvalue\fR' | DEFAULT }
SET TIME ZONE { '\fItimezone\fR' | LOCAL | DEFAULT }
SET TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIvariable\fB\fR
Settable global parameter.
.TP
\fB\fIvalue\fB\fR
New value of parameter.
.PP
.PP
The possible variables and allowed values are:
.TP
\fBCLIENT_ENCODING | NAMES\fR
Sets the multi-byte client encoding. Parameters are:
.RS
.TP
\fB\fIvalue\fB\fR
Sets the multi-byte client encoding to
\fIvalue\fR.
The specified encoding must be supported by the backend.
.TP
\fBDEFAULT\fR
Sets the multi-byte client encoding to the default value.
.RE
.PP

This is only enabled if multi-byte was specified to configure.
.TP
\fBDateStyle\fR
Set the date/time representation style. Affects the output format,
and in some cases it can affect the interpretation of input.
.RS
.TP
\fBISO\fR
use ISO 8601-style dates and times
.TP
\fBSQL\fR
use Oracle/Ingres-style dates and times
.TP
\fBPostgres\fR
use traditional Postgres format
.TP
\fBEuropean\fR
use dd/mm/yyyy for numeric date representations.
.TP
\fBNonEuropean\fR
use mm/dd/yyyy for numeric date representations.
.TP
\fBGerman\fR
use dd.mm.yyyy for numeric date representations.
.TP
\fBUS\fR
same as 'NonEuropean'
.TP
\fBDEFAULT\fR
restores the default values ('US,Postgres')
.RE
.PP

Date format initialization may be done by:

Setting the \fBPGDATESTYLE\fR environment variable.

Running postmaster using the option \fB-o -e\fR to set
dates to the European convention.
Note that this affects only some combinations of date styles; for example
the ISO style is not affected by this parameter.

Changing variables in 
\fIsrc/backend/utils/init/globals.c\fR.

The variables in \fIglobals.c\fR which can be changed are:

bool EuroDates = false | true

int DateStyle = USE_ISO_DATES | USE_POSTGRES_DATES | USE_SQL_DATES | USE_GERMAN_DATES
.TP
\fBSERVER_ENCODING\fR
Sets the multi-byte server encoding
.RS
.TP
\fB\fIvalue\fB\fR
Sets the multi-byte server encoding.
.TP
\fBDEFAULT\fR
Sets the multi-byte server encoding.
.RE
.PP

This is only enabled if multi-byte was specified to configure.
.TP
\fBTIMEZONE\fR
The possible values for timezone depends on your operating
system. For example on Linux /usr/lib/zoneinfo contains the
database of timezones.

Here are some valid values for timezone:
.RS
.TP
\fB\&'PST8PDT'\fR
set the timezone for California
.TP
\fB\&'Portugal'\fR
set time zone for Portugal.
.TP
\fB\&'Europe/Rome'\fR
set time zone for Italy.
.TP
\fBDEFAULT\fR
set time zone to your local timezone
(value of the TZ environment variable).
.RE
.PP

If an invalid time zone is specified, the time zone
becomes GMT (on most systems anyway).

A frontend which uses libpq may be initialized by setting the PGTZ
environment variable.

The second syntax shown above, allows one to set the timezone
with a syntax similar to SQL92 \fBSET TIME ZONE\fR.
The LOCAL keyword is just an alternate form
of DEFAULT for SQL92 compatibility.
.TP
\fBTRANSACTION ISOLATION LEVEL\fR
Sets the isolation level for the current transaction.
.RS
.TP
\fBREAD COMMITTED\fR
The current transaction queries read only rows committed
before a query began. READ COMMITTED is the default.
.sp
.RS
.B "Note:"
SQL92 standard requires 
SERIALIZABLE to be the default isolation level.
.RE
.sp
.TP
\fBSERIALIZABLE\fR
The current transaction queries read only rows committed
before first DML statement 
(\fBSELECT/INSERT/DELETE/UPDATE/FETCH/COPY_TO\fR)
was executed in this transaction. 
.RE
.PP
.PP
.PP
There are also several internal or optimization
parameters which can be specified
by the \fBSET\fR command:
.TP
\fBCOST_HEAP\fR
Sets the default cost of a heap scan for use by the optimizer.
.RS
.TP
\fB\fIfloat4\fB\fR
Set the cost of a heap scan to the specified floating point value.
.TP
\fBDEFAULT\fR
Sets the cost of a heap scan to the default value.
.RE
.PP

The frontend may be initialized by setting the PGCOSTHEAP
environment variable.
.TP
\fBCOST_INDEX\fR
Sets the default cost of an index scan for use by the optimizer.
.RS
.TP
\fB\fIfloat4\fB\fR
Set the cost of an index scan to the specified floating point value.
.TP
\fBDEFAULT\fR
Sets the cost of an index scan to the default value.
.RE
.PP

The frontend may be initialized by setting the PGCOSTINDEX
environment variable.
.TP
\fBGEQO\fR
Sets the threshold for using the genetic optimizer algorithm.
.RS
.TP
\fBON\fR
enables the genetic optimizer algorithm
for statements with 6 or more tables.
.TP
\fBON=\fI#\fB\fR
Takes an integer argument to enable the genetic optimizer algorithm
for statements with \fI#\fR
or more tables in the query.
.TP
\fBOFF\fR
disables the genetic optimizer algorithm.
.TP
\fBDEFAULT\fR
Equivalent to specifying \fBSET GEQO='ON'\fR
.RE
.PP

This algorithm is on by default, which used GEQO for
statements of eleven or more tables.
(See the chapter on GEQO in the Programmer's Guide
for more information).

The frontend may be initialized by setting PGGEQO
environment variable.

It may be useful when joining big relations with
small ones. This algorithm is off by default.
It's not used by GEQO anyway.
.TP
\fBKSQO\fR
\fIKey Set Query Optimizer\fR forces the query optimizer
to optimize repetative OR clauses such as generated by
MicroSoft Access:
.RS
.TP
\fBON\fR
enables this optimization.
.TP
\fBOFF\fR
disables this optimization.
.TP
\fBDEFAULT\fR
Equivalent to specifying \fBSET KSQO='OFF'\fR.
.RE
.PP

It may be useful when joining big relations with
small ones. This algorithm is off by default.
It's not used by GEQO anyway.

The frontend may be initialized by setting the PGKSQO
environment variable.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBSET VARIABLE\fR
Message returned if successfully.
.TP
\fBWARN: Bad value for \fIvariable\fB (\fIvalue\fB)\fR
If the command fails to set the specified variable.
.PP
.SH "DESCRIPTION"
.PP
\fBSET\fR will modify configuration parameters for variable during
a session.
.PP
Current values can be obtained using \fBSHOW\fR, and values
can be restored to the defaults using \fBRESET\fR.
Parameters and values are case-insensitive. Note that the value
field is always specified as a string, so is enclosed in
single-quotes.
.PP
\fBSET TIME ZONE\fR changes the session's
default time zone offset.
An SQL-session always begins with an initial default time zone
offset.
The \fBSET TIME ZONE\fR statement is used to change the default
time zone offset for the current SQL session.
.SS "NOTES"
.PP
The \fBSET \fIvariable\fB\fR
statement is a Postgres language extension.
.PP
Refer to \fBSHOW\fR and \fBRESET\fR to 
display or reset the current values.
.SH "USAGE"
.PP
Set the style of date to ISO:
.sp
.nf
SET DATESTYLE TO 'ISO';
   
.sp
.fi
Enable GEQO for queries with 4 or more tables:
.sp
.nf
 
SET GEQO ON=4;
   
.sp
.fi
Set GEQO to default:
.sp
.nf
 
SET GEQO = DEFAULT;
   
.sp
.fi
Set the timezone for Berkeley, California:
.sp
.nf
 
SET TIME ZONE 'PST8PDT';
SELECT CURRENT_TIMESTAMP AS today;
   
   today
   ----------------------
   1998-03-31 07:41:21-08
   
.sp
.fi
Set the timezone for Italy:
.sp
.nf
 
SET TIME ZONE 'Europe/Rome';
SELECT CURRENT_TIMESTAMP AS today;
   
   today
   ----------------------
   1998-03-31 17:41:31+02
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no general
\fBSET \fIvariable\fB\fR
in SQL92 (with the exception of
\fBSET TRANSACTION ISOLATION LEVEL\fR).
The SQL92 syntax for \fBSET TIME ZONE\fR
is slightly different,
allowing only a single integer value for time zone specification:
.sp
.nf
SET TIME ZONE { interval_value_expression | LOCAL }
    
.sp
.fi
