.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_OPERATOR" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
DROP OPERATOR \- Removes an operator from the database
.SH SYNOPSIS
.sp
.nf
DROP OPERATOR \fIid\fR ( \fItype\fR | NONE [,...] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIid\fB\fR
The identifier of an existing operator.
.TP
\fB\fItype\fB\fR
The type of function parameters.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command is successful.
.TP
\fBERROR: RemoveOperator: binary operator '\fIoper\fB' taking '\fItype\fB' and '\fItype2\fB' does not exist\fR
This message occurs if the specified binary operator does not exist.
.TP
\fBERROR: RemoveOperator: left unary operator '\fIoper\fB' taking '\fItype\fB' does not exist\fR
This message occurs if the specified left unary operator
specified does not exist.
.TP
\fBERROR: RemoveOperator: right unary operator '\fIoper\fB' taking '\fItype\fB' does not exist\fR
This message occurs if the specified right unary operator
specified does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP OPERATOR\fR drops an existing operator from the
database.
To execute this command you must be the owner of the operator.
.PP
The left or right type of a left or right unary
operator, respectively, may be specified as NONE.
.SS "NOTES"
.PP
The \fBDROP OPERATOR\fR statement is a 
Postgres
language extension.
.PP
Refer to
\fBcreate_operator\fR(l)
for information on how to create operators.
.PP
It is the user's responsibility to remove any access methods and
operator classes that rely on the deleted operator.
.SH "USAGE"
.PP
Remove power operator a^n for int4:
.sp
.nf
DROP OPERATOR ^ (int4, int4);
   
.sp
.fi
.PP
Remove left unary negation operator (b !) for booleans:
.sp
.nf
DROP OPERATOR ! (none, bool);
   
.sp
.fi
.PP
Remove right unary factorial operator (! i) for
int4:
.sp
.nf
DROP OPERATOR ! (int4, none);
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP OPERATOR\fR in SQL92.
