#include "btree_gist.h"
#include "btree_utils_num.h"

typedef struct
{
   Interval    lower,
               upper;
}   intvKEY;


/*
** Interval ops
*/
PG_FUNCTION_INFO_V1(gbt_intv_compress);
PG_FUNCTION_INFO_V1(gbt_intv_union);
PG_FUNCTION_INFO_V1(gbt_intv_picksplit);
PG_FUNCTION_INFO_V1(gbt_intv_consistent);
PG_FUNCTION_INFO_V1(gbt_intv_penalty);
PG_FUNCTION_INFO_V1(gbt_intv_same);

Datum    gbt_intv_compress(PG_FUNCTION_ARGS);
Datum    gbt_intv_union(PG_FUNCTION_ARGS);
Datum    gbt_intv_picksplit(PG_FUNCTION_ARGS);
Datum    gbt_intv_consistent(PG_FUNCTION_ARGS);
Datum    gbt_intv_penalty(PG_FUNCTION_ARGS);
Datum    gbt_intv_same(PG_FUNCTION_ARGS);


static bool     gbt_intvgt     (const void *a, const void *b)
{
   return DirectFunctionCall2 ( interval_gt , IntervalPGetDatum ( a ) , IntervalPGetDatum ( b ) );
}

static bool     gbt_intvge     (const void *a, const void *b)
{
   return DirectFunctionCall2 ( interval_ge , IntervalPGetDatum ( a ) , IntervalPGetDatum ( b ) );
}

static bool     gbt_intveq     (const void *a, const void *b)
{
   return DirectFunctionCall2 ( interval_eq , IntervalPGetDatum ( a ) , IntervalPGetDatum ( b ) );
}

static bool     gbt_intvle     (const void *a, const void *b)
{
   return DirectFunctionCall2 ( interval_le , IntervalPGetDatum ( a ) , IntervalPGetDatum ( b ) );
}

static bool     gbt_intvlt     (const void *a, const void *b)
{
   return DirectFunctionCall2 ( interval_lt , IntervalPGetDatum ( a ) , IntervalPGetDatum ( b ) );
}

static int
gbt_intvkey_cmp(const void *a, const void *b)
{
  return DatumGetInt32 ( 
     DirectFunctionCall2 ( interval_cmp ,
       IntervalPGetDatum(&((Nsrt *) a)->t[0]) ,
       IntervalPGetDatum(&((Nsrt *) b)->t[0])
     ) 
   );
}

static const gbtree_ninfo tinfo = 
{
  gbt_t_intv,
  sizeof(Interval),
  gbt_intvgt,
  gbt_intvge,
  gbt_intveq,
  gbt_intvle,
  gbt_intvlt,
  gbt_intvkey_cmp
};


/**************************************************
 * interval ops
 **************************************************/


Datum
gbt_intv_compress(PG_FUNCTION_ARGS)
{
    GISTENTRY  *entry  = (GISTENTRY *) PG_GETARG_POINTER(0);
    GISTENTRY  *retval = NULL;
    PG_RETURN_POINTER( gbt_num_compress( retval , entry , &tinfo ));
}
 

Datum
gbt_intv_consistent(PG_FUNCTION_ARGS)
{
    GISTENTRY        *entry = (GISTENTRY *) PG_GETARG_POINTER(0);
    Interval         *query = PG_GETARG_INTERVAL_P(1);
    intvKEY            *kkk = (intvKEY *) DatumGetPointer(entry->key);
    GBT_NUMKEY_R        key ;
    StrategyNumber strategy = (StrategyNumber) PG_GETARG_UINT16(2);
    key.lower = (GBT_NUMKEY*) &kkk->lower ;
    key.upper = (GBT_NUMKEY*) &kkk->upper ;

    PG_RETURN_BOOL(
      gbt_num_consistent( &key, (void*)query ,&strategy,GIST_LEAF(entry),&tinfo)
    );
}


Datum
gbt_intv_union(PG_FUNCTION_ARGS)
{
    GistEntryVector     *entryvec = (GistEntryVector *) PG_GETARG_POINTER(0);
    void                     *out = palloc(sizeof(intvKEY));
    *(int *) PG_GETARG_POINTER(1) = sizeof(intvKEY);
    PG_RETURN_POINTER( gbt_num_union ( (void*)out, entryvec, &tinfo ) );
}


Datum
gbt_intv_penalty(PG_FUNCTION_ARGS)
{
  intvKEY    *origentry = (intvKEY *) DatumGetPointer(((GISTENTRY *) PG_GETARG_POINTER(0))->key);
  intvKEY    *newentry  = (intvKEY *) DatumGetPointer(((GISTENTRY *) PG_GETARG_POINTER(1))->key);
  float         *result = (float *) PG_GETARG_POINTER(2);
  Interval   *intr;
#ifdef HAVE_INT64_TIMESTAMP
  int64      res;
#else
  double     res;
#endif

  intr = DatumGetIntervalP(DirectFunctionCall2(
            interval_mi,
            IntervalPGetDatum(&newentry->upper),
            IntervalPGetDatum(&origentry->upper)
  ));

  /* see interval_larger */

  res  = Max(intr->time + intr->month * (30 * 86400), 0);
  pfree(intr);

  intr = DatumGetIntervalP(DirectFunctionCall2(   
            interval_mi,
            IntervalPGetDatum(&origentry->lower),
            IntervalPGetDatum(&newentry->lower)
  ));

  /* see interval_larger */
  res += Max(intr->time + intr->month * (30 * 86400), 0);
  pfree(intr);

  *result = 0.0;

  if ( res > 0 ){

    intr = DatumGetIntervalP(DirectFunctionCall2(   
              interval_mi,
              IntervalPGetDatum(&origentry->upper),
              IntervalPGetDatum(&origentry->lower)
    ));

    *result += FLT_MIN ;
    *result += (float) ( res / ( (double) ( res + intr->time + intr->month * (30 * 86400) ) ) );
    *result *= ( FLT_MAX / ( ( (GISTENTRY *) PG_GETARG_POINTER(0))->rel->rd_att->natts + 1 ) );
    
    pfree ( intr );

  }

  PG_RETURN_POINTER(result);


}

Datum
gbt_intv_picksplit(PG_FUNCTION_ARGS)
{
  PG_RETURN_POINTER(gbt_num_picksplit(
      (GistEntryVector *) PG_GETARG_POINTER(0),
      (GIST_SPLITVEC *) PG_GETARG_POINTER(1),
      &tinfo
  ));
}

Datum
gbt_intv_same(PG_FUNCTION_ARGS)
{
  intvKEY    *b1 = (intvKEY *) PG_GETARG_POINTER(0);
  intvKEY    *b2 = (intvKEY *) PG_GETARG_POINTER(1);
  bool     *result = (bool *) PG_GETARG_POINTER(2);

  *result  = gbt_num_same ( (void*)b1, (void*)b2, &tinfo );
  PG_RETURN_POINTER(result);
}

