.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_FUNCTION" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE FUNCTION \- Defines a new function
.SH SYNOPSIS
.sp
.nf
CREATE FUNCTION \fIname\fR ( [ \fIftype\fR [, ...] ] )
    RETURNS \fIrtype\fR
    AS \fIdefinition\fR
    LANGUAGE '\fIlangname\fR'
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a function to create.
.TP
\fB\fIftype\fB\fR
The data type of function arguments.
The input types may be base or complex types, or
\fIopaque\fR.
opaque indicates that the function
accepts arguments of an invalid type such as \fBchar *\fR.
.TP
\fB\fIrtype\fB\fR
The return data type.
The output type may be specified as a base type, complex type, 
setof \fItype\fR,
or opaque.
The setof
modifier indicates that the function will return a set of items,
rather than a single item.
.TP
\fB\fIdefinition\fB\fR
A string defining the function; the meaning depends on the language.
It may be an internal function name, the path to an object file,
an SQL query, or text in a procedural language.
.TP
\fB\fIlangname\fB\fR
may be 'C', 'sql',
\&'internal'
or '\fIplname\fR',
where '\fIplname\fR'
is the name of a created procedural
language. See
\fBcreate_language\fR(l)
for details.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
This is returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE FUNCTION\fR allows a
Postgres user
to register a function
with a database. Subsequently, this user is treated as the
owner of the function.
.SS "NOTES"
.PP
Refer to the chapter in
the \fIPostgreSQL Programmer's Guide\fR
on extending
Postgres via functions 
for further information on writing external functions.
.PP
Use \fBDROP FUNCTION\fR
to drop user-defined functions.
.PP
Postgres allows function "overloading";
that is, the same name can be used for several different functions
so long as they have distinct argument types. This facility must be
used with caution for internal
and C-language functions, however.
.PP
Two internal
functions cannot have the same C name without causing
errors at link time. To get around that, give them different C names
(for example, use the argument types as part of the C names), then
specify those names in the AS clause of \fBCREATE FUNCTION\fR.
If the AS clause is left empty then \fBCREATE FUNCTION\fR
assumes the C name of the function is the same as the SQL name.
.PP
For dynamically-loaded C functions, the SQL name of the function must
be the same as the C function name, because the AS clause is used to
give the path name of the object file containing the C code. In this
situation it is best not to try to overload SQL function names. It
might work to load a C function that has the same C name as an internal
function or another dynamically-loaded function --- or it might not.
On some platforms the dynamic loader may botch the load in interesting
ways if there is a conflict of C function names. So, even if it works
for you today, you might regret overloading names later when you try
to run the code somewhere else.
.PP
A C function cannot return a set of values.
.SH "USAGE"
.PP
To create a simple SQL function:
.sp
.nf
CREATE FUNCTION one() RETURNS int4
    AS 'SELECT 1 AS RESULT'
    LANGUAGE 'sql';
SELECT one() AS answer;

       answer 
    ------
    1
   
  
.sp
.fi
.PP
This example creates a C function by calling a routine from a user-created
shared library. This particular routine calculates a check
digit and returns TRUE if the check digit in the function parameters
is correct. It is intended for use in a CHECK contraint.
.sp
.nf
   \fBCREATE FUNCTION ean_checkdigit(bpchar, bpchar) RETURNS bool
    AS '/usr1/proj/bray/sql/funcs.so' LANGUAGE 'c';
    
CREATE TABLE product (
    id        char(8) PRIMARY KEY,
    eanprefix char(8) CHECK (eanprefix ~ '[0-9]{2}-[0-9]{5}')
                      REFERENCES brandname(ean_prefix),
    eancode   char(6) CHECK (eancode ~ '[0-9]{6}'),
    CONSTRAINT ean    CHECK (ean_checkdigit(eanprefix, eancode))
);
   \fR
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE FUNCTION\fR is
a Postgres language extension.
.SS "SQL/PSM"
.PP
.sp
.RS
.B "Note:"
PSM stands for Persistent Stored Modules. It is a procedural
language and it was originally hoped that PSM would be ratified
as an official standard by late 1996. As of mid-1998, this
has not yet happened, but it is hoped that PSM will
eventually become a standard.
.RE
.sp
SQL/PSM \fBCREATE FUNCTION\fR has the following syntax:
.sp
.nf
CREATE FUNCTION \fIname\fR
    ( [ [ IN | OUT | INOUT ] \fIeter\fReable>eable> \fItype\fR [, ...] ] )
     RETURNS \fIrtype\fR
     LANGUAGE '\fIlangname\fR'
     ESPECIFIC \fIroutine\fR
     \fISQL-statement\fR
    
.sp
.fi
