/*
 * this is a small part of c.h since we don't want to leak all postgres
 * definitions into ecpg programs
 */

#ifndef _ECPGLIB_H
#define _ECPGLIB_H

#include <stdio.h>

#ifndef __BEOS__
#ifndef __cplusplus
#ifndef bool
#define bool char
#endif   /* ndef bool */

#ifndef true
#define true	((bool) 1)
#endif   /* ndef true */
#ifndef false
#define false	((bool) 0)
#endif   /* ndef false */
#endif   /* not C++ */
#else							/* __BEOS__ */
#include <SupportDefs.h>
#endif   /* __BEOS__ */

#ifndef TRUE
#define TRUE	1
#endif   /* TRUE */

#ifndef FALSE
#define FALSE	0
#endif   /* FALSE */

#ifdef __cplusplus
extern		"C"
{
#endif

void		ECPGdebug(int, FILE *);
bool		ECPGstatus(int, const char *);
bool		ECPGsetcommit(int, const char *, const char *);
bool		ECPGsetconn(int, const char *);
bool		ECPGconnect(int, const char *, const char *, const char *, const char *, int);
bool		ECPGdo(int, const char *, char *,...);
bool		ECPGtrans(int, const char *, const char *);
bool		ECPGdisconnect(int, const char *);
bool		ECPGprepare(int, char *, char *);
bool		ECPGdeallocate(int, char *);
bool		ECPGdeallocate_all(int);
char	       *ECPGprepared_statement(char *);

void		ECPGlog(const char *format,...);
char	       *ECPGerrmsg(void);

 /* print an error message */
void		sqlprint(void);

/* define this for simplicity as well as compatibility */

#define		  SQLCODE	 sqlca.sqlcode

/* dynamic SQL */

bool ECPGdo_descriptor(int line, const char *connection,
				  const char *descriptor, const char *query);
bool		ECPGdeallocate_desc(int line, const char *name);
bool		ECPGallocate_desc(int line, const char *name);
void		ECPGraise(int line, int code, const char *str);
bool		ECPGget_desc_header(int, char *, int *);
bool		ECPGget_desc(int, char *, int,...);

bool		ECPGdescribe(int, bool, const char *, ...);

/* dynamic result allocation */
void		ECPGfree_auto_mem(void);

enum COMPAT_MODE { ECPG_COMPAT_PGSQL = 0, ECPG_COMPAT_INFORMIX};

#ifdef __cplusplus
}

#endif

#endif /* _ECPGLIB_H */
