.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_VIEW" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
DROP VIEW \- Removes an existing view from a database
.SH SYNOPSIS
.sp
.nf
DROP VIEW \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing view.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command is successful.
.TP
\fBERROR: RewriteGetRuleEventRel: rule "_RET\fIname\fB" not found\fR
This message occurs if the specified view does not exist in
the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP VIEW\fR drops an existing view from the database.
To execute this command you must be the owner of the
view.
.SS "NOTES"
.PP
The Postgres
\fBDROP TABLE\fR statement also drops views.
.PP
Refer to \fBCREATE VIEW\fR
for information on how to create views.
.SH "USAGE"
.PP
This command will remove the view called kinds:
.sp
.nf
DROP VIEW kinds;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 specifies some additional capabilities for
\fBDROP VIEW\fR:
.sp
.nf
DROP VIEW \fIview\fR { RESTRICT | CASCADE }
    
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBRESTRICT\fR
Ensures that only a view with no dependent views or
integrity constraints can be destroyed.
.TP
\fBCASCADE\fR
Any referencing views and integrity constraints
will be dropped as well.
.PP
.SS "NOTES"
.PP
At present, to remove a referenced view from a
Postgres database, 
you must drop it explicitly.
