#!/usr/bin/perl

#
# This script automatically generates the help on SQL in psql from the
# SGML docs. So far the format of the docs was consistent enough that
# this worked, but this here is my no means an SGML parser.
#
# It might be a good idea that this is just done once before distribution
# so people that don't have the docs or have slightly messed up docs or
# don't have perl, etc. won't have to bother.
#
# Call: perl create_help.pl sql_help.h
# (Do not rely on this script to be executable.)
# The name of the header file doesn't matter to this script, but it sure
# does matter to the rest of the source.
#
# A rule for this is also in the psql makefile.
#

$docdir = "./../../../doc/src/sgml/ref";
$outputfile = $ARGV[0] or die "Missing required argument.\n";

$define = $outputfile;
$define =~ tr/a-z/A-Z/;
$define =~ s/\W/_/g;

opendir DIR, $docdir or die "Couldn't open documentation sources: $!\n";
open OUT, ">$outputfile" or die "Couldn't open output file '$outputfile': $!\n";

print OUT
"/*
 * This file is automatically generated from the SGML documentation.
 * Direct changes here will be overwritten.
 */
#ifndef $define
#define $define

struct _helpStruct
{
    char	   *cmd;	   /* the command name */
    char	   *help;	   /* the help associated with it */
    char	   *syntax;	   /* the syntax associated with it */
};


static struct _helpStruct QL_HELP[] = {
";

foreach $file (readdir DIR) {
    my ($cmdname, $cmddesc, $cmdsynopsis);
    $file =~ /\.sgml$/ || next;

    open FILE, "$docdir/$file" or next;
    $filecontent = join('', <FILE>);
    close FILE;

    $filecontent =~ m!<refmiscinfo>\s*SQL - Language Statements\s*</refmiscinfo>!i
	or next;

    $filecontent =~ m!<refname>\s*([a-z ]+?)\s*</refname>!i && ($cmdname = $1);
    $filecontent =~ m!<refpurpose>\s*(.+?)\s*</refpurpose>!i && ($cmddesc = $1);

    $filecontent =~ m!<synopsis>\s*(.+?)\s*</synopsis>!is && ($cmdsynopsis = $1);

    if ($cmdname && $cmddesc && $cmdsynopsis) {
        $cmdname =~ s/\"/\\"/g;

	$cmddesc =~ s/<\/?.+?>//sg;
	$cmddesc =~ s/\n/ /g;
        $cmddesc =~ s/\"/\\"/g;

	$cmdsynopsis =~ s/<\/?.+?>//sg;
	$cmdsynopsis =~ s/\n/\\n/g;
        $cmdsynopsis =~ s/\"/\\"/g;

	print OUT "    { \"$cmdname\",\n      \"$cmddesc\",\n      \"$cmdsynopsis\" },\n\n";
    }
    else {
	print STDERR "Couldn't parse file '$file'. (N='$cmdname' D='$cmddesc')\n";
    }
}

print OUT "
    { NULL, NULL, NULL }    /* End of list marker */
};

#endif /* $define */
";

close OUT;
closedir DIR;
