.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "ALTER_TABLE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
ALTER TABLE \- Modifies table properties
.SH SYNOPSIS
.sp
.nf
ALTER TABLE \fItable\fR
    [ * ] ADD [ COLUMN ] \fIER">co\fRBLE> \fItype\fR
ALTER TABLE \fItable\fR
    [ * ] RENAME [ COLUMN ] \fIER">co\fRBLE> TO \fInewcolumn\fR
ALTER TABLE \fItable\fR
    RENAME TO \fInewtable\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItable \fB\fR
The name of an existing table to alter.
.TP
\fB\fIcolumn \fB\fR
Name of a new or existing column.
.TP
\fB\fItype \fB\fR
Type of the new column.
.TP
\fB\fInewcolumn \fB\fR
New name for an existing column.
.TP
\fB\fInewtable \fB\fR
New name for an existing column.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER\fR
Message returned from column or table renaming.
.TP
\fBNEW\fR
Message returned from column addition.
.TP
\fBERROR\fR
Message returned if table or column is not available.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER TABLE\fR changes the definition of an existing table.
The new columns and their types are specified in the same style
and with the the same restrictions as in \fBCREATE TABLE\fR.
The RENAME clause causes the name of a table or column
to change without changing any of the data contained in
the affected table. Thus, the table or column will
remain of the same type and size after this command is
executed.
.PP
You must own the table in order to change its schema.
.SS "NOTES"
.PP
The keyword COLUMN is noise and can be omitted.
.PP
``*'' following a name of a table indicates that the statement
should be run over that table and all tables below it in the
inheritance hierarchy;
by default, the attribute will not be added to or renamed in any of the subclasses.
This should always be done when adding or modifying an attribute in a
superclass. If it is not, queries on the inheritance hierarchy
such as
.sp
.nf
SELECT \fINewColumn\fR FROM \fISuperClass\fR*
    
.sp
.fi
will not work because the subclasses will be missing an attribute
found in the superclass.
.PP
For efficiency reasons, default values for added attributes are
not placed in existing instances of a class.
That is, existing instances will have NULL values in the new
attributes. If non-NULL values are desired, a subsequent
\fBUPDATE\fR query 
(\fBupdate\fR(l))
should be run.
.PP
You must own the class in order to change its schema.
Renaming any part of the schema of a system
catalog is not permitted.
The \fIPostgreSQL User's Guide\fR has further
information on inheritance.
.PP
Refer to \fBCREATE TABLE\fR for a further description
of valid arguments.
.SH "USAGE"
.PP
To add a column of type VARCHAR to a table:
.sp
.nf
ALTER TABLE distributors ADD COLUMN address VARCHAR(30);
   
.sp
.fi
.PP
To rename an existing column:
.sp
.nf
ALTER TABLE distributors RENAME COLUMN address TO city;
   
.sp
.fi
.PP
To rename an existing table:
.sp
.nf
ALTER TABLE distributors RENAME TO suppliers;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBALTER TABLE/RENAME\fR
is a Postgres language extension.
.PP
SQL92 specifies some additional capabilities for \fBALTER TABLE\fR
statement which are not yet directly supported by
Postgres:
.TP
\fB.sp\fR
Puts the default value or constraint specified into the
definition of column in the table.
See \fBCREATE TABLE\fR for the
syntax of the default and table-constraint clauses.
If a default clause already exists, it will be replaced by
the new definition. If any constraints on this column already
exist, they will be retained using a boolean AND with the new
constraint.

Currently, to set new default constraints on an existing column
the table must be recreated and reloaded:
.sp
.nf
CREATE TABLE temp AS SELECT * FROM distributors;
DROP TABLE distributors;
CREATE TABLE distributors (
    did      DECIMAL(3) DEFAULT 1,
    name     VARCHAR(40) NOT NULL,
    city     VARCHAR(30)
);
INSERT INTO distributors SELECT * FROM temp;
DROP TABLE temp;
       
.sp
.fi
.TP
\fB.sp\fR
Removes the default value specified by default or the rule
specified by constraint from the definition of a table. 
If RESTRICT is specified only a constraint with no dependent
constraints can be destroyed.
If CASCADE is specified, Any constraints that are dependent on
this constraint are also dropped.

Currently, to remove a default value or constraints on an
existing column the table must be recreated and reloaded:
.sp
.nf
CREATE TABLE temp AS SELECT * FROM distributors;
DROP TABLE distributors;
CREATE TABLE distributors AS SELECT * FROM temp;
DROP TABLE temp;
       
.sp
.fi
.TP
\fB.sp\fR
Removes a column from a table.
If RESTRICT is specified only a column with no dependent
objects can be destroyed.
If CASCADE is specified, all objects that are dependent on
this column are also dropped.

Currently, to remove an existing column the table must be
recreated and reloaded:
.sp
.nf
CREATE TABLE temp AS SELECT did, city FROM distributors;    
DROP TABLE distributors;
CREATE TABLE distributors (
    did      DECIMAL(3)  DEFAULT 1,
    name     VARCHAR(40) NOT NULL,
);
INSERT INTO distributors SELECT * FROM temp;
DROP TABLE temp;
       
.sp
.fi
