.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_LANGUAGE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
DROP LANGUAGE \- Removes a user-defined procedural language
.SH SYNOPSIS
.sp
.nf
DROP PROCEDURAL LANGUAGE '\fIname\fR'
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing procedural language.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
This message is returned if the language is successfully dropped.
.TP
\fBERROR: Language "\fIname\fB" doesn't exist\fR
This message occurs if a language called
\fIname\fR is
not found in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP PROCEDURAL LANGUAGE\fR will remove the definition
of the previously registered procedural language called
\fIname\fR.
.SS "NOTES"
.PP
The \fBDROP PROCEDURAL LANGUAGE\fR statement is
a Postgres language extension.
.PP
Refer to
\fBcreate_language\fR(l)
for information on how to create procedural languages.
.PP
No checks are made if functions or trigger procedures registered
in this language still exist. To re-enable them without having
to drop and recreate all the functions, the pg_proc's prolang
attribute of the functions must be adjusted to the new object
ID of the recreated pg_language entry for the PL.
.SH "USAGE"
.PP
This command removes the PL/Sample language:
.sp
.nf
DROP PROCEDURAL LANGUAGE 'plsample';
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP PROCEDURAL LANGUAGE\fR in 
SQL92.
