.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "UPDATE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
UPDATE \- Replaces values of columns in a table
.SH SYNOPSIS
.sp
.nf
UPDATE \fItable\fR SET \fIR">col\fRle> = \fIexpression\fR [, ...]
    [ FROM \fIfromlist\fR ]
    [ WHERE \fIcondition\fR ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItable\fB\fR
The name of an existing table.
.TP
\fB\fIcolumn\fB\fR
The name of a column in \fItable\fR.
.TP
\fB\fIexpression\fB\fR
A valid expression or value to assign to column.
.TP
\fB\fIfromlist\fB\fR
A Postgres
non-standard extension to allow columns
from other tables to appear in the WHERE condition.
.TP
\fB\fIcondition\fB\fR
Refer to the SELECT statement for a further description
of the WHERE clause.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBUPDATE \fI#\fB\fR
Message returned if successful.
The \fI#\fR
means the number of rows updated.
If \fI#\fR
is equal 0 no rows are updated.
.PP
.SH "DESCRIPTION"
.PP
\fBUPDATE\fR changes the values of the columns specified for
all rows which satisfy condition. Only the columns 
to be modified need appear as columns in the statement.
.PP
Array references use the same syntax found in
\fBselect\fR(l).
That is, either single array elements, a range of array
elements or the entire array may be replaced with a single
query.
.PP
You must have write access to the table in order to modify
it, as well as read access to any table whose values are
mentioned in the WHERE condition.
.SH "USAGE"
.PP
Change word "Drama" with "Dramatic" on column kind:
.sp
.nf
UPDATE films 
    SET kind = 'Dramatic'
    WHERE kind = 'Drama';
SELECT * FROM films WHERE kind = 'Dramatic' OR kind = 'Drama';

   code |title        |did| date_prod|kind      |len
   -----+-------------+---+----------+----------+------
   BL101|The Third Man|101|1949-12-23|Dramatic  | 01:44
   P_302|Becket       |103|1964-02-03|Dramatic  | 02:28
   M_401|War and Peace|104|1967-02-12|Dramatic  | 05:57
   T_601|Yojimbo      |106|1961-06-16|Dramatic  | 01:50
   DA101|Das Boot     |110|1981-11-11|Dramatic  | 02:29
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 defines a different syntax for
the positioned UPDATE statement:
.sp
.nf
UPDATE table SET column = expression [, ...]
    WHERE CURRENT OF \fIcursor\fR
    
.sp
.fi
where \fIcursor\fR
identifies an open cursor.
