.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_INDEX" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CREATE INDEX \- Constructs a secondary index
.SH SYNOPSIS
.sp
.nf
CREATE [ UNIQUE ] INDEX \fIindex_name\fR ON \fItable\fR
    [ USING \fIacc_name\fR ] ( \fIcolumn\fR [ \fIops_name\fR] [, ...] )
CREATE [ UNIQUE ] INDEX \fIindex_name\fR ON \fItable\fR
    [ USING \fIacc_name\fR ] ( \fIfunc_name\fR( \fIr">col\fRle> [, ... ]) \fIops_name\fR )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBUNIQUE\fR
Causes the system to check for
duplicate values in the table when the index is created (if data
already exist) and each time data is added. Attempts to
insert or update non-duplicate data will generate an
error.
.TP
\fB\fIindex_name\fB\fR
The name of the index to be created.
.TP
\fB\fItable\fB\fR
The name of the table to be indexed.
.TP
\fB\fIacc_name\fB\fR
the name of the access method which is to be used for
the index. The default access method is BTREE.
Postgres provides three access methods for secondary indexes:
.RS
.TP
\fBBTREE\fR
an implementation of the Lehman-Yao
high-concurrency btrees.
.TP
\fBRTREE\fR
implements standard rtrees using Guttman's
quadratic split algorithm.
.TP
\fBHASH\fR
an implementation of Litwin's linear hashing.
.RE
.PP
.TP
\fB\fIcolumn\fB\fR
The name of a column of the table.
.TP
\fB\fIops_name\fB\fR
An associated operator class. See below for details.
.TP
\fB\fIfunc_name\fB\fR
A user-defined function, which returns a value that can
be indexed.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
The message returned if the index is successfully created.
.TP
\fBERROR: Cannot create index: 'index_name' already exists.\fR
This error occurs if it is impossible to create the index.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE INDEX\fR constructs an index 
\fIindex_name\fR
on the specified \fItable\fR.
.sp
.RS
.B "Tip:"
Indexes are primarily used to enhance database performance.
But inappropriate use will result in slower performance.
.RE
.sp
.PP
In the first syntax shown above, the key fields for the
index are specified as column names; a column may also have
an associated operator class. An operator class is used
to specify the operators to be used for a particular
index. For example, a btree index on four-byte integers
would use the int4_ops class;
this operator class includes
comparison functions for four-byte integers. The default
operator class is the appropriate operator class for that
field type.
.PP
In the second syntax shown above, an index is defined
on the result of a user-defined function
\fIfunc_name\fR applied
to one or more attributes of a single class.
These \fIfunctional indices\fR
can be used to obtain fast access to data
based on operators that would normally require some
transformation to apply them to the base data.
.PP
Postgres provides btree, rtree and hash access methods for
secondary indices. The btree access method is an implementation of
the Lehman-Yao high-concurrency btrees. The rtree access method
implements standard rtrees using Guttman's quadratic split algorithm.
The hash access method is an implementation of Litwin's linear
hashing. We mention the algorithms used solely to indicate that all
of these access methods are fully dynamic and do not have to be
optimized periodically (as is the case with, for example, static hash
access methods).
.SS "NOTES"
.PP
The Postgres query optimizer will consider using btree indices in a scan
whenever an indexed attribute is involved in a comparison using one of:
<, <=, =, >=, >
.PP
Both box classes support indices on the box data 
type in Postgres.
The difference between them is that bigbox_ops
scales box coordinates down, to avoid floating point exceptions from
doing multiplication, addition, and subtraction on very large
floating-point coordinates. If the field on which your rectangles lie
is about 20,000 units square or larger, you should use
bigbox_ops.
The poly_ops operator class supports rtree
indices on polygon data.
.PP
The Postgres
query optimizer will consider using an rtree index whenever
an indexed attribute is involved in a comparison using one of:
<<, &<, &>, >>, @, ~=, &&
.PP
The Postgres
query optimizer will consider using a hash index whenever
an indexed attribute is involved in a comparison using
the = operator.
.PP
Currently, only the BTREE access method supports multi-column
indexes. Up to 7 keys may be specified.
.PP
Use \fBdrop_index\fR(l)
to remove an index.
.PP
The int24_ops
operator class is useful for constructing indices on int2 data, and
doing comparisons against int4 data in query qualifications.
Similarly, int42_ops
support indices on int4 data that is to be compared against int2 data
in queries.
.PP
The following select list returns all ops_names:
.sp
.nf
SELECT am.amname AS acc_name,
       opc.opcname AS ops_name,
       opr.oprname AS ops_comp
    FROM pg_am am, pg_amop amop,
         pg_opclass opc, pg_operator opr
    WHERE amop.amopid = am.oid AND
          amop.amopclaid = opc.oid AND
          amop.amopopr = opr.oid
    ORDER BY acc_name, ops_name, ops_comp
    
.sp
.fi
.SH "USAGE"
.PP
To create a btree index on the field title
in the table films:
.sp
.nf
CREATE UNIQUE INDEX title_idx
    ON films (title);
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
CREATE INDEX is a Postgres language extension.
.PP
There is no \fBCREATE INDEX\fR command in SQL92.
