.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "VACUUM" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
VACUUM \- Clean and analyze a Postgres database
.SH SYNOPSIS
.sp
.nf
VACUUM [ VERBOSE ] [ ANALYZE ] [ \fItable\fR ]
VACUUM [ VERBOSE ] ANALYZE [ \fIER">t\fRBLE> [ (\fIcolumn\fR [, ...] ) ] ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBVERBOSE\fR
Prints a detailed vacuum activity report for each table.
.TP
\fBANALYZE\fR
Updates column statistics used by the optimizer to
determine the most efficient way to execute a query.
The statistics represent the disbursion of the data in each column.
This information is valuable when several execution paths are possible.
.TP
\fB\fItable\fB\fR
The name of a specific table to vacuum. Defaults to all tables.
.TP
\fB\fIcolumn\fB\fR
The name of a specific column to analyze. Defaults to all columns.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBVACUUM\fR
The command has been accepted and the database is being cleaned.
.TP
\fBNOTICE: --Relation \fItable\fB--\fR
The report header for \fItable\fR.
.TP
\fBNOTICE: Pages 98: Changed 25, Reapped 74, Empty 0, New 0;\fR
The analysis for \fItable\fR itself.
.TP
\fBNOTICE: Index \fIindex\fB: Pages 28;\fR
The analysis for an index on the target table.
.PP
.SH "DESCRIPTION"
.PP
\fBVACUUM\fR serves two purposes in 
Postgres as both a means to reclaim storage and
also a means to collect information for the optimizer.
.PP
\fBVACUUM\fR opens every class in the database,
cleans out records from rolled back transactions, and updates statistics in the
system catalogs. The statistics maintained include the number of
tuples and number of pages stored in all classes.
.PP
Running \fBVACUUM\fR
periodically will increase the speed of the database in processing user queries.
.SS "NOTES"
.PP
The open database is the target for \fBVACUUM\fR.
.PP
We recommend that active production databases be cleaned nightly, in order
to keep statistics relatively current. The \fBVACUUM\fR
query may be executed at any time, however. In particular, after
copying a large class into Postgres 
or after deleting a large number of
records, it may be a good idea to issue a \fBVACUUM\fR
query. This will update the system catalogs with the results of all
recent changes, and allow the Postgres 
query optimizer to make better choices in planning user queries.
.PP
If the server crashes during a \fBVACUUM\fR command, 
chances are it will leave a lock file hanging around. 
Attempts to re-run the \fBVACUUM\fR command
result in an error message about the creation of a lock file. If you
are sure \fBVACUUM\fR is not running, 
remove the \fIpg_vlock\fR file in your
database directory 
(i.e. \fI\fBPGDATA\fI/base/dbname/pg_vlock\fR).
.SH "USAGE"
.PP
The following is an example from running \fBVACUUM\fR on a table
in the regression database:
.sp
.nf
regression=> vacuum verbose analyze onek;
NOTICE:  --Relation onek--
NOTICE:  Pages 98: Changed 25, Reapped 74, Empty 0, New 0;
         Tup 1000: Vac 3000, Crash 0, UnUsed 0, MinLen 188, MaxLen 188;
         Re-using: Free/Avail. Space 586952/586952; EndEmpty/Avail. Pages 0/74.
         Elapsed 0/0 sec.
NOTICE:  Index onek_stringu1: Pages 28; Tuples 1000: Deleted 3000. Elapsed 0/0 sec.
NOTICE:  Index onek_hundred: Pages 12; Tuples 1000: Deleted 3000. Elapsed 0/0 sec.
NOTICE:  Index onek_unique2: Pages 19; Tuples 1000: Deleted 3000. Elapsed 0/0 sec.
NOTICE:  Index onek_unique1: Pages 17; Tuples 1000: Deleted 3000. Elapsed 0/0 sec.
NOTICE:  Rel onek: Pages: 98 --> 25; Tuple(s) moved: 1000. Elapsed 0/1 sec.
NOTICE:  Index onek_stringu1: Pages 28; Tuples 1000: Deleted 1000. Elapsed 0/0 sec.
NOTICE:  Index onek_hundred: Pages 12; Tuples 1000: Deleted 1000. Elapsed 0/0 sec.
NOTICE:  Index onek_unique2: Pages 19; Tuples 1000: Deleted 1000. Elapsed 0/0 sec.
NOTICE:  Index onek_unique1: Pages 17; Tuples 1000: Deleted 1000. Elapsed 0/0 sec.
VACUUM
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBVACUUM\fR statement in SQL92.
