/*
 * psql - the PostgreSQL interactive terminal
 *
 * Copyright (c) 2000-2005, PostgreSQL Global Development Group
 *
 * $PostgreSQL: pgsql/src/bin/psql/command.h,v 1.23 2005/12/18 02:17:16 petere Exp $
 */
#ifndef COMMAND_H
#define COMMAND_H

#include "settings.h"
#include "print.h"
#include "psqlscan.h"


typedef enum _backslashResult
{
	PSQL_CMD_UNKNOWN = 0,			/* not done parsing yet (internal only) */
	PSQL_CMD_SEND,					/* query complete; send off */
	PSQL_CMD_SKIP_LINE,				/* keep building query */
	PSQL_CMD_TERMINATE,				/* quit program */
	PSQL_CMD_NEWEDIT,				/* query buffer was changed (e.g., via \e) */
	PSQL_CMD_ERROR					/* the execution of the backslash command
								 * resulted in an error */
} backslashResult;


extern backslashResult HandleSlashCmds(PsqlScanState scan_state,
				PQExpBuffer query_buf);

extern int	process_file(char *filename);

extern bool do_pset(const char *param,
		const char *value,
		printQueryOpt *popt,
		bool quiet);

extern void SyncVariables(void);

extern void UnsyncVariables(void);

extern void SyncVerbosityVariable(void);

#endif   /* COMMAND_H */
