.\" This is -*-nroff-*-
.\" XXX standard disclaimer belongs here....
.\" $Header: /cvsroot/pgsql/src/man/Attic/lock.l,v 1.8 1999/06/04 04:28:54 momjian Exp $
.TH FETCH SQL 01/23/93 PostgreSQL PostgreSQL
.SH NAME
lock - exclusive lock a table
.SH SYNOPSIS
.nf
\fBlock\fR [\fBtable\fR] classname
[\fBin\fR [\fBrow\fR|\fBaccess\fR] [\fBshare\fR|\fBexclusive\fR] |
[\fBshare row exclusive\fR] \fBmode\fR]
.fi
.SH DESCRIPTION
By default,
.BR lock
exclusive locks an entire table inside a transaction.
Various options allow shared access, or row-level locking control.
.PP
The classic use for this
is the case where you want to \fBselect\fP some data, then update it
inside a transaction.  If you don't exclusive lock the table before the
\fBselect\fP, some other user may also read the selected data, and try
and do their own \fBupdate\fP, causing a deadlock while you both wait
for the other to release the \fBselect\fP-induced shared lock so you can
get an exclusive lock to do the \fBupdate.\fP
.PP
Another example of deadlock is where one user locks one table, and
another user locks a second table.  While both keep their existing
locks, the first user tries to lock the second user's table, and the
second user tries to lock the first user's table. Both users deadlock
waiting for the tables to become available.  The only solution to this
is for both users to lock tables in the same order, so user's lock
aquisitions and requests to not form a deadlock.
.SH EXAMPLES
.nf
--
--  Proper locking to prevent deadlock
--
begin work;
lock table mytable;
select * from mytable;
update mytable set (x = 100);
commit;
.SH "SEE ALSO"
begin(l),
commit(l),
select(l).
