/*-------------------------------------------------------------------------
 *
 * relmapdesc.c
 *    rmgr descriptor routines for utils/cache/relmapper.c
 *
 * Portions Copyright (c) 1996-2013, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *    src/backend/access/rmgrdesc/relmapdesc.c
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include "utils/relmapper.h"

void
relmap_desc(StringInfo buf, uint8 xl_info, char *rec)
{
	uint8		info = xl_info & ~XLR_INFO_MASK;

	if (info == XLOG_RELMAP_UPDATE)
	{
		xl_relmap_update *xlrec = (xl_relmap_update *) rec;

		appendStringInfo(buf, "update relmap: database %u tablespace %u size %u",
						 xlrec->dbid, xlrec->tsid, xlrec->nbytes);
	}
	else
		appendStringInfo(buf, "UNKNOWN");
}
