.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_RULE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
DROP RULE \- Removes an existing rule from the database
.SH SYNOPSIS
.sp
.nf
DROP RULE \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing rule to drop.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
Message returned if successfully.
.TP
\fBERROR: RewriteGetRuleEventRel: rule "\fIname\fB" not found\fR
This message occurs if the specified rule does not exist.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP RULE\fR drops a rule from the specified
Postgres rule
system. Postgres
will immediately cease enforcing it and
will purge its definition from the system catalogs.
.SS "NOTES"
.PP
The \fBDROP RULE\fR statement is a
Postgres
language extension.
.PP
Refer to \fBCREATE RULE\fR for
information on how to create rules.
.PP
Once a rule is dropped, access to historical information
the rule has written may disappear.
.SH "USAGE"
.PP
To drop the rewrite rule newrule:
.sp
.nf
DROP RULE newrule;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP RULE\fR in SQL92.
