use ExtUtils::MakeMaker;
use ExtUtils::Embed;
use DynaLoader;
use Config;

#
# Can't build a shared plperl unless libperl is shared too.
# (Actually, it would be enough if code in libperl.a is compiled
# to be position-independent, but that is hard to check for and
# seems pretty unlikely anyway.)
#
if ($Config{'useshrplib'} ne 'true') {
	open(OUT, ">Makefile") or die "Can't write Makefile: $!\n";
	print OUT <<'EndOfMakefile';
# Dummy Makefile for use when we can't build plperl

all install:
	@echo "*****"; \
	 echo "* Cannot build PL/Perl because libperl is not a shared library." ; \
	 echo "* Skipped."; \
	 echo "*****"


clean realclean:
	rm -f Makefile

EndOfMakefile
	close(OUT);
	exit(0);
}

my $ldopts=ldopts();
$ldopts=~s/$Config{ccdlflags}//;

WriteMakefile( 'NAME' => 'plperl', 
        dynamic_lib => { 'OTHERLDFLAGS' =>  $ldopts } ,
	INC => "$ENV{EXTRA_INCLUDES}",
	XS => { 'SPI.xs' => 'SPI.c' },
	OBJECT => 'plperl.o eloglvl.o SPI.o',
	);


sub MY::cflags {
    package MY;			# so that "SUPER" works right
    my $inherited = shift->SUPER::cflags(@_);

#
# Hack for building on HPUX (probably should have a general mechanism
# for system-specific hints, but for now ...)
# The default compiler and flags on this platform is cc -Aa, which
# will reject 'long long' declarations that appear in Postgres headers.
# Need to select -Ae instead.
#
    if ($Config::Config{'osname'} eq 'hpux') {
	$inherited =~ s/-Aa/-Ae/;
    }

    $inherited;
}

sub MY::install {

qq[
install :: all
	cp \$(INST_DYNAMIC) $ENV{plperl_installdir}
];

}
