.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "MOVE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
MOVE \- Moves cursor position
.SH SYNOPSIS
.sp
.nf
MOVE [ \fIselector\fR ] [ \fIcount\fR ] 
    { IN | FROM } \fIcursor\fR
    FETCH [ RELATIVE ] [ { [ \fI#\fR | ALL | NEXT | PRIOR ] } ] FROM ] \fIcursor\fR
  
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBMOVE\fR allows a user to move cursor position a specified
number of rows.
\fBMOVE\fR works like the \fBFETCH\fR command,
but only positions the cursor and does
not return rows.
.PP
Refer to 
\fBfetch\fR(l)
for details on syntax and usage.
.SS "NOTES"
.PP
\fBMOVE\fR is a Postgres
language extension.
.PP
Refer to
\fBfetch\fR(l)
for a description of valid arguments.
Refer to 
\fBdeclare\fR(l)
to define a cursor.
Refer to 
\fBbegin\fR(l), 
\fBcommit\fR(l),
and
\fBrollback\fR(l)
for further information about transactions.
.SH "USAGE"
.PP
Set up and use a cursor:
.sp
.nf
BEGIN WORK;
DECLARE liahona CURSOR  FOR SELECT * FROM films;
--Skip first 5 rows:
MOVE FORWARD 5 IN liahona;
MOVE
--Fetch 6th row in the cursor liahona:
FETCH 1 IN liahona;
FETCH

  code |title |did| date_prod|kind      |len
  -----+------+---+----------+----------+------
  P_303|48 Hrs|103|1982-10-22|Action    | 01:37
  (1 row)
-- close the cursor liahona and commit work:
CLOSE liahona;
COMMIT WORK;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no SQL92 \fBMOVE\fR statement. 
Instead, SQL92 allows
one to \fBFETCH\fR rows from an absolute cursor position,
implicitly moving the cursor to the correct position.
