.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "LISTEN" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
LISTEN \- Listen for a response on a notify condition
.SH SYNOPSIS
.sp
.nf
LISTEN \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
Name of notify condition.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBLISTEN\fR
Message returned upon successful completion of registration.
.TP
\fBNOTICE Async_Listen: We are already listening on \fIname\fB\fR
If this backend is already registered for that notify condition.
.PP
.SH "DESCRIPTION"
.PP
\fBLISTEN\fR registers the current 
Postgres backend as a
listener on the notify condition
\fIname\fR.
.PP
Whenever the command 
\fBNOTIFY \fIname\fB\fR
is invoked, either by this backend or another one connected to
the same database, all the backends currently listening on that notify
condition are notified, and each will in turn notify its connected
frontend application. See the discussion of \fBNOTIFY\fR
for more information.
.PP
A backend can be unregistered for a given notify condition with the
\fBUNLISTEN\fR command. Also, a backend's listen registrations
are automatically cleared when the backend process exits.
.PP
The method a frontend application must use to detect notify events depends on
which Postgres application programming interface it
uses. With the basic libpq library, the application issues
\fBLISTEN\fR as an ordinary SQL command, and then must
periodically call the routine \fBPQnotifies\fR to find out
whether any notify events have been received. Other interfaces such as
libpgtcl provide higher-level methods for handling notify events; indeed,
with libpgtcl the application programmer should not even issue
\fBLISTEN\fR or \fBUNLISTEN\fR directly. See the
documentation for the library you are using for more details.
.PP
\fBnotify\fR(l)
contains a more extensive
discussion of the use of \fBLISTEN\fR and
\fBNOTIFY\fR.
.SS "NOTES"
.PP
\fIname\fR
can be any string valid as a name;
it need not correspond to the name of any actual table. If
\fInotifyname\fR
is enclosed in double-quotes, it need not even be a syntactically
valid name, but can be any string up to 31 characters long.
.PP
In some previous releases of
Postgres,
\fIname\fR
had to be enclosed in double-quotes when it did not correspond to any existing
table name, even if syntactically valid as a name. That is no longer required.
.SH "USAGE"
.PP
Configure and execute a listen/notify sequence from \fBpsql\fR:
.sp
.nf
LISTEN virtual;
NOTIFY virtual;

ASYNC NOTIFY of 'virtual' from backend pid '11239' received
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBLISTEN\fR in SQL92.
