.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_USER" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
DROP USER \- Removes an user account information
.SH SYNOPSIS
.sp
.nf
DROP USER \fIname\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing user.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the user is successfully deleted.
.TP
\fBERROR: removeUser: user "\fIname\fB" does not exist.\fR
This message occurs if the username is not found.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP USER\fR removes the specified
user from the database,
along with any databases owned by the user. It
does not remove tables, views, or triggers owned by the
named user in databases not owned by the user. This statement
can be used in place of the \fBdestroyuser\fR
script, regardless of how the user was created.
.SS "NOTES"
.PP
\fBDROP USER\fR is a Postgres
language extension.
.PP
Refer to \fBCREATE USER\fR and
\fBALTER USER\fR for information on
how to create or modify user accounts.
.SH "USAGE"
.PP
To drop a user account:
.sp
.nf
DROP USER Jonathan;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP USER\fR in SQL92.
