.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_FUNCTION" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
DROP FUNCTION \- Removes a user-defined C function
.SH SYNOPSIS
.sp
.nf
DROP FUNCTION \fIname\fR ( [ \fItype\fR [, ...] ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing function.
.TP
\fB\fItype\fB\fR
The type of function parameters.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
Message returned if the command completes successfully.
.TP
\fBWARN RemoveFunction: Function "\fIname\fB" ("\fItypes\fB") does not exist\fR
This message is given if the function specified does not
exist in the current database.
.PP
.SH "DESCRIPTION"
.PP
DROP FUNCTION will remove references to an existing C
function. To execute this command the user must be the
owner of the function. The input argument types to the
function must be specified, as only the function with the
given name and argument types will be removed.
.SS "NOTES"
.PP
Refer to
\fBcreate_function\fR(l)
for information on creating aggregate functions.
.PP
No checks are made to ensure that types, operators or access
methods that rely on the function have been removed first.
.SH "USAGE"
.PP
This command removes the square root function:
.sp
.nf
DROP FUNCTION sqrt(int4);
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBDROP FUNCTION\fR
is a Postgres language extension.
.SS "SQL/PSM"
.PP
SQL/PSM is a proposed standard to enable function extensibility.
The SQL/PSM DROP FUNCTION statement has the following syntax:
.sp
.nf
DROP [ SPECIFIC ] FUNCTION \fIname\fR { RESTRICT | CASCADE }
    
.sp
.fi
