.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CLOSE" "l" "08 August 1999" "SQL - Language Statements" ""
.SH NAME
CLOSE \- Close a cursor
.SH SYNOPSIS
.sp
.nf
CLOSE \fIcursor\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIcursor\fB\fR
The name of an open cursor to close.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCLOSE\fR
Message returned if the cursor is successfully closed.
.TP
\fBNOTICE PerformPortalClose: portal "\fIcursor\fB" not found\fR
This warning is given if
\fIcursor\fR is not
declared or has already been closed.
.PP
.SH "DESCRIPTION"
.PP
\fBCLOSE\fR frees the resources associated with an open cursor.
After the cursor is closed, no subsequent operations
are allowed on it. A cursor should be closed when it is
no longer needed.
.PP
An implicit close is executed for every open cursor when a
transaction is terminated by \fBCOMMIT\fR
or \fBROLLBACK\fR.
.SS "NOTES"
.PP
Postgres does not have
an explicit \fBOPEN\fR cursor statement;
a cursor is considered open when it is declared.
Use the \fBDECLARE\fR statement to declare a cursor.
.SH "USAGE"
.PP
Close the cursor liahona:
.sp
.nf
CLOSE liahona;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCLOSE\fR is fully compatible with SQL92.
