# $PostgreSQL: pgsql/src/nls-global.mk,v 1.15 2008/12/11 07:34:07 petere Exp $

# Common rules for Native Language Support (NLS)
#
# If some subdirectory of the source tree wants to provide NLS, it
# needs to contain a file 'nls.mk' with the following make variable
# assignments:
#
# CATALOG_NAME		-- name of the message catalog (xxx.po); probably
#			   name of the program
# AVAIL_LANGUAGES	-- list of languages that are provided/supported
# GETTEXT_FILES		-- list of source files that contain message strings
# GETTEXT_TRIGGERS	-- (optional) list of functions that contain
#                          translatable strings
#
# That's all, the rest is done here, if --enable-nls was specified.
#
# The only user-visible targets here are 'init-po', to make an initial
# "blank" catalog from program sources, and 'update-po', which is to
# be called if the messages in the program source have changed, in
# order to merge the changes into the existing .po files.


# existence checked by Makefile.global; otherwise we won't get here
include $(srcdir)/nls.mk

# If user specified the languages he wants in --enable-nls=LANGUAGES,
# filter out the rest.  Else use all available ones.
ifdef WANTED_LANGUAGES
LANGUAGES = $(filter $(WANTED_LANGUAGES), $(AVAIL_LANGUAGES))
else
LANGUAGES = $(AVAIL_LANGUAGES)
endif

PO_FILES = $(addprefix po/, $(addsuffix .po, $(LANGUAGES)))
MO_FILES = $(addprefix po/, $(addsuffix .mo, $(LANGUAGES)))

ifdef XGETTEXT
XGETTEXT += --foreign-user -ctranslator
endif


all-po: $(MO_FILES)

%.mo: %.po
	$(MSGFMT) -o $@ $<

ifdef XGETTEXT
ifeq ($(word 1,$(GETTEXT_FILES)),+)
po/$(CATALOG_NAME).pot: $(word 2, $(GETTEXT_FILES))
	$(XGETTEXT) -D $(srcdir) -n $(addprefix -k, $(GETTEXT_TRIGGERS)) -f $<
else
po/$(CATALOG_NAME).pot: $(GETTEXT_FILES)
# Change to srcdir explicitly, don't rely on $^.  That way we get
# consistent #: file references in the po files.
	$(XGETTEXT) -D $(srcdir) -n $(addprefix -k, $(GETTEXT_TRIGGERS)) $(GETTEXT_FILES)
endif
	@$(mkinstalldirs) $(dir $@)
	mv messages.po $@
else # not XGETTEXT
	@echo "You don't have 'xgettext'."; exit 1
endif # not XGETTEXT


# catalog name extentions must match behavior of PG_TEXTDOMAIN() in c.h
install-po: all-po installdirs-po
ifneq (,$(LANGUAGES))
	for lang in $(LANGUAGES); do \
	  $(INSTALL_DATA) po/$$lang.mo '$(DESTDIR)$(localedir)'/$$lang/LC_MESSAGES/$(CATALOG_NAME)$(SO_MAJOR_VERSION)-$(MAJORVERSION).mo || exit 1; \
	done
endif

installdirs-po:
	$(mkinstalldirs) $(foreach lang, $(LANGUAGES), '$(DESTDIR)$(localedir)'/$(lang)/LC_MESSAGES)

uninstall-po:
	rm -f $(foreach lang, $(LANGUAGES), '$(DESTDIR)$(localedir)'/$(lang)/LC_MESSAGES/$(CATALOG_NAME)$(SO_MAJOR_VERSION)-$(MAJORVERSION).mo)


clean-po:
	$(if $(MO_FILES),rm -f $(MO_FILES))
	@$(if $(PO_FILES),rm -f $(addsuffix .old, $(PO_FILES)))
	rm -f po/$(CATALOG_NAME).pot


maintainer-check-po: $(PO_FILES)
	for file in $^; do \
	  $(MSGFMT) -c -v -o /dev/null $$file || exit 1; \
	done


init-po: po/$(CATALOG_NAME).pot


define merge-lang
@printf 'merging $(1) '
@if $(MSGMERGE) $(srcdir)/po/$(1).po $< -o po/$(1).po.new $(addprefix --compendium=,$(shell find $(top_srcdir) -name $(1).po -printf '%p ')); \
then \
    mv $(srcdir)/po/$(1).po po/$(1).po.old; \
    mv po/$(1).po.new $(srcdir)/po/$(1).po; \
else \
    echo "msgmerge for $(1) failed"; \
    rm -f po/$(1).po.new; \
fi

endef

update-po: po/$(CATALOG_NAME).pot
ifdef MSGMERGE
	$(foreach lang,$(LANGUAGES),$(call merge-lang,$(lang)))
else
	@echo "You don't have 'msgmerge'." ; exit 1
endif


all: all-po
install: install-po
installdirs: installdirs-po
uninstall: uninstall-po
clean distclean maintainer-clean: clean-po
maintainer-check: maintainer-check-po

.PHONY: all-po install-po installdirs-po uninstall-po clean-po \
        maintainer-check-po init-po update-po
.SILENT: installdirs-po
