#include "types.h"
#include "x86.h"
#include "defs.h"

#include "param.h"
#include "memlayout.h"
#include "mmu.h"
#include "proc.h"

int
sys_fork(void)
{
  return fork();
}

int
sys_exit(void)
{
  int status;
  if(argint(0, &status) < 0){
    return -1;
  }
  exit(status);
  return 0;  // not reached
}

int
sys_wait(void)
{
  int *p;
  if(argptr(0, (void*)&p, sizeof(int))<0){
    return -1;
  }
  return wait(p);
}

int
sys_kill(void)
{
  int pid;

  if(argint(0, &pid) < 0)
    return -1;
  return kill(pid);
}

int
sys_getpid(void)
{
  return myproc()->pid;
}

int
sys_sbrk(void)
{
  int addr;
  int n;
  struct proc *curprocess = myproc();
  if(argint(0, &n) < 0)
    return -1;
  curprocess->currentHeapMem += n;
  addr = myproc()->sz;
  if(growproc(n) < 0)
    return -1;
  return addr;
}

int
sys_sleep(void)
{
  int n;
  uint ticks0;

  if(argint(0, &n) < 0)
    return -1;
  acquire(&tickslock);
  ticks0 = ticks;
  while(ticks - ticks0 < n){
    if(myproc()->killed){
      release(&tickslock);
      return -1;
    }
    sleep(&ticks, &tickslock);
  }
  release(&tickslock);
  return 0;
}

// return how many clock tick interrupts have occurred
// since start.
int
sys_uptime(void)
{
  uint xticks;

  acquire(&tickslock);
  xticks = ticks;
  release(&tickslock);
  return xticks;
}

int 
sys_helloWorld(void) 
{ 
  cprintf("Hello World\n");
  return 1;
}

int 
sys_numopenfiles(void)
{
  int pid;
  if(argint(0, &pid) < 0){
    return -1;
  }
  return numopenfiles(pid);
}

int
sys_memalloc(void)
{
  int pid;
  if(argint(0, &pid) < 0){
    return -1;
  }
  return memalloc(pid);
}

int 
sys_getprocesstimedetails(void)
{
  int pid;
  if(argint(0, &pid) < 0){
    return -1;
  }
  return getprocesstimedetails(pid);
}

int 
sys_psinfo(void) {
  return psinfo();
}