#include "types.h"
#include "stat.h"
#include "user.h"
#include "fcntl.h"

#define INPUT_SIZE 1024 
#define TOKEN_SIZE 64   
#define NUM_TOKENS 64   
#define FILE_INPUT 4096

struct twoCmd {
	char **cmd1;
	char **cmd2;
};

char **tokenCreator(char *); 
char **fileCommandSeparator(char *);
void exeCmd(char **);
void exePs(char **);
void exeProcInfo(char **);
void exeExit(char **);
void executeCommand(char **); 
void succOrParser(struct twoCmd *);
void succAndParser(struct twoCmd *);
void parallelParser(struct twoCmd *);
void pipeParser(struct twoCmd *);
void commandChecker(char *);
void cmdSeperator1 (char *, int);
void cmdSeperator2 (char *, int);


char **fileCommandSeparator(char *fileContent) {
	char **fileCommandArray = (char **)malloc(sizeof(char *));
	int k = 0, i, j = -1;
	for (i=0; i<strlen(fileContent); i++) {
		if ((fileContent[i] == '\n') && j != -1) {
			char temp[100]; int l = 0;
			while (j<i) {
				temp[l++] = fileContent[j++];
			}
			temp[l] = '\0';
			fileCommandArray[k] = (char *)malloc(TOKEN_SIZE * sizeof(char));
			strcpy(fileCommandArray[k++], temp);
			j = -1;
		}
		else if (fileContent[i] != '\n' && j == -1) {
			j = i;
		}
	}
	fileCommandArray[k] = 0;
	return fileCommandArray;
}

void cmdSeperator1 (char *cmd, int index) {
	struct twoCmd *commands = (struct twoCmd *)malloc(sizeof(struct twocmd *));
	char *temp1 = (char *)malloc(INPUT_SIZE * sizeof(char));
	char *temp2 = (char *)malloc(INPUT_SIZE * sizeof(char));
	int ind1 = 0, ind2 = 0;

	for (int j=0; j<index; j++) {
		temp1[ind1++] = cmd[j];
	}
	temp1[ind1] = '\n';
	for (int j=index+1; j<strlen(cmd); j++) {
		temp2[ind2++] = cmd[j];
	}
	temp2[ind2] = '\n';
	commands->cmd1 = tokenCreator(temp1);
	commands->cmd2 = tokenCreator(temp2);
	free(temp1); free(temp2);
	if (cmd[index] == '|') pipeParser(commands);
	else if (cmd[index] == ';') parallelParser(commands);
}

void cmdSeperator2 (char *cmd, int index) {
	struct twoCmd *commands = (struct twoCmd *)malloc(sizeof(struct twocmd *));
	char *temp1 = (char *)malloc(INPUT_SIZE * sizeof(char));
	char *temp2 = (char *)malloc(INPUT_SIZE * sizeof(char));
	int ind1 = 0, ind2 = 0;

	for (int j=0; j<index; j++) {
		temp1[ind1++] = cmd[j];
	}
	temp1[ind1] = '\n';
	for (int j=index+2; j<strlen(cmd); j++) {
		temp2[ind2++] = cmd[j];
	}
	temp2[ind2] = '\n';
	commands->cmd1 = tokenCreator(temp1);
	commands->cmd2 = tokenCreator(temp2);
	free(temp1); free(temp2);
	if (cmd[index] == '|') succOrParser(commands);
	else if (cmd[index] == '&') succAndParser(commands);
}

void commandChecker(char *cmd) {
	int i = 0;
	char  **tokenArray;
	for (i=0; i<strlen(cmd); i++) {
		if (cmd[i] == '|' && cmd[i+1] != '|' ) {
			cmdSeperator1(cmd, i);
			break;
		}
		else if (cmd[i] == '|' && cmd[i+1] == '|') {
			cmdSeperator2(cmd, i); 
			break;
		}
		else if (cmd[i] == '&') {
			cmdSeperator2(cmd, i);
			break;
		}
		else if (cmd[i] == ';') {
			cmdSeperator1(cmd, i);
			break;
		}
	}
	if (i == strlen(cmd)) {
		cmd[strlen(cmd)] = '\n';      
		tokenArray = tokenCreator(cmd);         
		executeCommand(tokenArray);
	}
}

void pipeParser(struct twoCmd *cmds) {
	int status1, status2, pipefd[2];

	for (int i=0; cmds->cmd1[i]!=0; i++) {
		if (!strcmp(cmds->cmd1[i], ">")) {
			printf(1, "Illegal command or arguments.\n");
			return;
		}
	}
	for (int i=0; cmds->cmd2[i]!=0; i++) {
		if (!strcmp(cmds->cmd2[i], "<")) {
			printf(1, "Illegal command or arguments.\n");
			return;
		}
	}
	pipe(pipefd);
	int cid1 = fork();
	if (cid1 == -1) {
		return;
	}
	else if (cid1 == 0) {
		close(1);
		dup(pipefd[1]);
		close(pipefd[0]);
		close(pipefd[1]);
		//exec(cmd1[0], cmd1);
		executeCommand(cmds->cmd1);
		exit(0);
	}

	int cid2 = fork();
	if (cid2 == -1) {
		exit(-1);
	}
	else if (cid2 == 0) {
		close(0);
		dup(pipefd[0]);
		close(pipefd[0]);
		close(pipefd[1]);
		//exec(cmd2[0], cmd2);
		executeCommand(cmds->cmd2);
		exit(0);
	}

	close(pipefd[0]); close(pipefd[1]); 
	wait(&status1); wait(&status2);

}

void succOrParser(struct twoCmd *commands) {
	int  status1, status2;

	int cid1 = fork();
	if (cid1 == -1) {
		return;
	}
	else if (cid1 == 0) {
		exeCmd(commands->cmd1);
		exit(0);
	}
	else {
		wait(&status1);
	}

	if (status1 == -1) {
		int cid2 = fork();
		if (cid2 == -1) {
		exit(-1);
		}
		else if (cid2 == 0) {
			exeCmd(commands->cmd2);
			exit(0);
		}
		else {
			wait(&status2);
		}
	}
	else {
		return;
	}
}

void succAndParser(struct twoCmd *commands) {
	int status1, status2;

	int cid1 = fork();
	if (cid1 == -1) {
		return;
	}
	else if (cid1 == 0) {
		//exec(cmd1[0], cmd1);
		exeCmd(commands->cmd1);
		exit(0);
	}
	else {
		wait(&status1);
	}

	if (status1 == 0) {
		int cid2 = fork();
		if (cid2 == -1) {
			exit(-1);
		}
		else if (cid2 == 0) {
			//exec(cmd2[0], cmd2);
			exeCmd(commands->cmd2);
			exit(0);
		}
		else {
			wait(&status2);
		}
	}
	else {
		return;
	}

}

void parallelParser(struct twoCmd *cmds) {
    int status1, status2;

	int cid1 = fork();
	if (cid1 == -1) return;
	else if (cid1 == 0) {
		exeCmd(cmds->cmd1);
		exeCmd(cmds->cmd2);
		exit(0);
	}
	int cid2 = fork();
	if (cid2 == -1) return;
	if (cid2 == 0) {
		exeCmd(cmds->cmd2);
		exeCmd(cmds->cmd1);
		exit(0);
	}
	
	int pid1 = wait(&status1); int pid2 = wait(&status2);
	if ((pid1 == cid1 || pid1 == cid2) && (pid2 == cid1 || pid2 == cid2)) {
		return;
	}
	else {
		wait(0);wait(0);
	}
	
	return;
}

char **tokenCreator(char *cmd) {
	char **finalTokenArray = (char **)malloc(20 * sizeof(char*));
	int k = 0, i, j = -1;
	for (i=0; i<strlen(cmd); i++) {
		if ((cmd[i] == ' ' || cmd[i] == '\0' || cmd[i] == '\n') && j != -1) {
			char temp[20]; int l = 0;
			while (j<i) {
				temp[l++] = cmd[j++];
			}
			temp[l] = '\0';
			finalTokenArray[k] = (char *)malloc(TOKEN_SIZE * sizeof(char));
			strcpy(finalTokenArray[k++], temp);
			j = -1;
		}
		else if ((cmd[i] != ' ' && cmd[i] != '\0' && cmd[i] != '\n') && j == -1) {
			j = i;
		}
	}
	finalTokenArray[k] = 0;

	return finalTokenArray;
}

void executeCommand(char **cmd) {
	if (!strcmp(cmd[0], "ls") || !strcmp(cmd[0], "echo") || !strcmp(cmd[0], "grep") || !strcmp(cmd[0], "cat") || \
	!strcmp(cmd[0], "wc") || !strcmp(cmd[0], "ps") || !strcmp(cmd[0], "procinfo")) {
		int i = fork(), status;
		if (i == 0) {
			exeCmd(cmd);
			exit(0);
		}
		else {
			wait(&status);
		}
	}
	else if (!strcmp(cmd[0], "exit")) {
		wait(0);
		exit(0);
	}
	else {
		printf(1, "Illegal command or arguments\n");
		return;
	}
}

void exeCmd(char **cmd) {
	char **actualCMD = (char **)malloc(NUM_TOKENS * sizeof(char *)); 
	int inputFD = -1, outputFD = -1;
		for (int j=0; cmd[j]!=0; j++) {
			if (!strcmp(cmd[j], "<") || !strcmp(cmd[j], ">")) break;
			else {
				actualCMD[j] = cmd[j];
			}
		}
		for (int j=0; cmd[j]!=0; j++) {
			if (!strcmp(cmd[j],">")) {
				close(1);
				unlink(cmd[j+1]);
				outputFD = open(cmd[j+1], O_WRONLY | O_CREATE);
			}
			if (!strcmp(cmd[j],"<")) {
				close(0);
				inputFD = open(cmd[j+1], O_RDONLY);
			}
		}
		exec(actualCMD[0], actualCMD);
		if (inputFD >= 0) close(inputFD);
		if (outputFD >= 0) close(outputFD);
}


int main(void) {
    static char input[INPUT_SIZE];            
	char  **tokenArray;                      
    while (1) {
        printf(1, "MyShell>");
        memset(input, 0, sizeof(input));    
        gets(input, sizeof(input));  
       

		int fd;
		fd = open("console", O_RDWR);
		while (fd > 2) {
			close(fd);
			fd--;
		}

		if (input[0] == 'e' && input[1] == 'x' && input[2] == 'e' && input[3] == 'c' && input[4] == 'u' && input[5] == 't' && input[6] == 'e' && \
		input[7] == 'C' && input[8] == 'o' && input[9] == 'm' && input[10] == 'm' && input[11] == 'a' && input[12] == 'n' && input[13] == 'd' && input[14] == 's') {
			tokenArray = tokenCreator(input);
			static char fileContent[FILE_INPUT];
			if (tokenArray[2] != 0 || tokenArray[1] == 0) {
				printf(1, "Illegal command or arguments\n");
				continue;
			}

			int fd = open(tokenArray[1], O_RDONLY | O_CREATE);
			read(fd, fileContent, 1000);
			//printf(1, "%s", fileContent);
			fileContent[strlen(fileContent)] = '\n';
			char **fileCommands = fileCommandSeparator(fileContent);
			for (int j=0; fileCommands[j]!=0; j++) {
				//printf(1, "%s", fileCommands[j]);
				commandChecker(fileCommands[j]);
			}
			free(input);
		}
		else {
			commandChecker(input);
		}
		
    }
    exit(0);
}