#include "types.h"
#include "user.h"
#include "fcntl.h"

int
main(int argc, char *argv[])
{
  int pid = 0, x, y, z;
  if(argc != 2){
    printf(1, "Illegal command or arguments.\n Usage procinfo <process_id>\n pid 0 for current process info\n");
    exit(-1);
  }

  pid = atoi(argv[1]);
  if (pid == 0) {
    printf(1, "No process for such Pid exists\n");
    exit(-1);
  }

  x = numOpenFiles(pid);
  if (x == -1){
    printf(1, "No process for such Pid exists\n");
    exit(-1);
  } 
  y = memAlloc(pid);
  if (y == -1) {
    printf(1, "No process for such Pid exists\n");
    exit(-1);
  } 
  z = getprocesstimedetails(pid);
  if(z == -1) {
    printf(1, "No process for such Pid exists\n");
    exit(-1);
  }
  exit(0);
}

