# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.core.validators import MinLengthValidator

# Create your models here.


class Student(models.Model):
	name = models.CharField(max_length=200)
	phone_number = models.CharField(max_length=10)
	email_ID = models.CharField(max_length=200)
	address = models.CharField(max_length=400)
	username = models.CharField(max_length=200,primary_key=True)
	password = models.CharField(max_length=200,validators=[MinLengthValidator(4)])


class Faculty(models.Model):
	name = models.CharField(max_length=200)
	phone_number = models.CharField(max_length=10)
	email_ID = models.CharField(max_length=200)
	address = models.CharField(max_length=400)
	username = models.CharField(max_length=200,primary_key=True)
	password = models.CharField(max_length=200,validators=[MinLengthValidator(4)])


class Test(models.Model):
	test_ID = models.AutoField(primary_key=True)
	test_name = models.CharField(max_length=200,unique=True)
	visibility_student = models.CharField(max_length=20)
	ownership = models.CharField(max_length=20)
	expected_time_for_completion = models.DurationField(blank=True)
	start_time = models.DateTimeField(auto_now=False, auto_now_add=False)
	max_marks = models.FloatField(null=True)

class Subject(models.Model):
	subect_ID = models.CharField(max_length=20,primary_key=True)
	subject = models.CharField(max_length=20)

class Question(models.Model):
	q_ID = models.AutoField(primary_key=True)
	subect_ID = models.ForeignKey('Subject', on_delete=models.CASCADE)
	faculty = models.ForeignKey('Faculty',models.SET_NULL,blank=True,null=True)
	topic = models.CharField(max_length=20)
	subtopic = models.CharField(max_length=20)
	time_stamp = models.DateTimeField(auto_now=True)
	source = models.CharField(max_length=200)
	dificulty_set = models.CharField(max_length=20)
	dificulty_observed = models.CharField(max_length=20)
	qestion_text = models.CharField(max_length=1000)
	image_link = models.CharField(max_length=200) 
	num_appeared = models.IntegerField
	num_correct = models.IntegerField
	visibility = models.CharField(max_length=20)
	ownership = models.CharField(max_length=20)




