# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.http import HttpResponse
from django.shortcuts import render,redirect
from . import models
from .models import Responses
from .models import Test
from .models import Question
from .models import Options
from .models import Student
from . import utilities
from .utilities import evaluate
from . import forms

from django.contrib.auth.decorators import login_required
from django.http import HttpResponse
from django.views.decorators.cache import cache_control
import json
from django.db import connection
from django.db import IntegrityError
from django.db.models import F
from .forms import TestForm
import datetime

def login(request):
    print("session currently is "+str(request.session.get('session',None)))
        
    if(request.session.get('session',None)==True):
        return redirect('/arfa/profile')
    return render(request,'ARFA_app/login.html')   

def AboutUs(request):
    return render(request,'ARFA_app/AboutUs.html',request.session.get('args',None))

def success_mantra(request):
    return render(request,'ARFA_app/success_mantra.html',request.session.get('args',None))

def timetable(request):
    return render(request,'ARFA_app/timetable.html',request.session.get('args',None))

def register(request):
    return render(request,'ARFA_app/register.html',request.session.get('args',None))
def reg(request):
    if(request.method=="POST"):
        role=request.POST['role']
        data={'username': request.POST['username'], 'name':request.POST['name'],'email_ID': request.POST['email_ID'],'address':request.POST['email_ID'],'password':request.POST['password'],'phone_number':request.POST['phone_number']}
        
        if(role=="Student"):
            s=models.Student(**data)
            s.save()
        else:
            data['salary']=0
            data['subject_ID']=models.Subject.objects.filter(subject_ID=request.POST['subject_ID']).get()
            s=models.Faculty(**data)
            s.save()
        
        return redirect('/arfa/register')
    else:        
        return redirect('/arfa')   


def students(request):
    students=models.Student.objects.all().values()
    args={'students':students}
    args2=request.session.get('args',None)
    if args2!=None:
        args.update(args2)
    return render(request,'ARFA_app/students.html',args)

def faculty(request):
    faculty=models.Faculty.objects.all().values()
    args={'facultys':faculty}
    args2=request.session.get('args',None)
    if args2!=None:
        args.update(args2)
    return render(request,'ARFA_app/faculty.html',args)

def ContactUs(request):
    return render(request,'ARFA_app/ContactUs.html',request.session.get('args',None))

def send_mess(request):
    if(request.method=='POST'):
        name=request.POST['txtName']
        email_ID=request.POST['txtEmail']
        phone_number=request.POST['txtPhone']
        message=request.POST['txtMsg']
        args={'name':name,'phone_number':phone_number,'email_ID':email_ID,'text':message}
        Info=models.ContactUs(**args)
        Info.save()
        args.update(request.session.get('args',None))
        return render(request,'ARFA_app/Success.html',args)
    else:
        return redirect('/arfa/ContactUs')   

def profile(request):
    if request.method=='POST' or request.session.get('session',None)==True:
        if(request.session.get('session',None)==True):
            if(request.session.get('role',None)=="student"):
                return render(request,'ARFA_app/home.html',request.session.get('args',None))
            else:
                return render(request,'ARFA_app/faculty_home.html',request.session.get('args',None))
        else:
            args={'user':request.POST['username'],'password':request.POST['password']}
            print(args['user'])
            authenticated=check_auth(args)
            if(not(authenticated["status"])):
                return redirect('/arfa/',authenticated)
            else:
                request.session['username'] = args['user']
                request.session['session'] = True
                request.session.get('role',None)
                request.session['role']=authenticated['role']
                args={
                    'name':authenticated["object"].name,
                    'phone_number':authenticated["object"].phone_number,
                    'username':authenticated["object"].username,
                    'email_ID':authenticated["object"].email_ID,
                    'address':authenticated["object"].address,
                    'role':authenticated["role"],
                    'is_session':True
                }
                request.session['args']=args
                if(authenticated['role']=="student"):
                    print("session before render "+str(request.session.get('session',None)))
                    return render(request,'ARFA_app/home.html',args)
                else:
                    return render(request,'ARFA_app/faculty_home.html',args)
                
    else:
        return redirect('/arfa')   
    
def check_auth(args):
    tuple=models.Student.objects.filter(username=args["user"],password=args["password"])
        
    if len(tuple)==1 :
        return {'status':True,'object':tuple[0],'role':"student"}
    else :
        tuple=models.Faculty.objects.filter(username=args["user"],password=args["password"])
        if len(tuple)==1 :
            return {'status':True,'object':tuple[0],'role':"faculty"}
        else :
            return {'status':False}

def logout(request):
    request.session['session']=False
    request.session.flush()
    return render(request,'ARFA_app/logout.html')


def studentTestHome(request):
    if(request.session.get('session',None)!=True):
        return render(request,'ARFA_app/login.html')
    if(request.session.get('role',None)!="student"):
        return HttpResponse("Not a student")

    now = datetime.datetime.now()
    activeTests = Test.objects.filter(start_time__gte = now - F('expected_time_for_completion'),
    start_time__lte = now)
    practiceTests = Test.objects.filter(start_time__lte = now - F('expected_time_for_completion'))
    data = {}
    data['username'] = request.session['username']
    data['is_session'] = True
    data['activeTests'] = []
    for t in activeTests:
        data['activeTests'].append({'test_ID':t.test_ID, 'test_name':t.test_name, 
        'marks':t.max_marks, 'start_time':t.start_time}) 

    data['practiceTests'] = []
    for t in practiceTests:
        data['practiceTests'].append({'test_ID':t.test_ID, 'test_name':t.test_name, 
        'marks':t.max_marks, 'start_time':t.start_time}) 
    print data
    return render(request, 'ARFA_app/studentTestHome.html', data)

def loadStudentTest(request):
    if request.method == 'POST':
        test_ID = request.POST['test_ID']
            

def testHome(request):
    # if request.method == 'GET':
    allOptions = models.Options.objects.select_related('q_ID').all()
    json = {'testID':'3'}

    questionsJSON = {}
    for option in allOptions:
        if option.q_ID.question_text in questionsJSON:
            questionsJSON[option.q_ID.question_text].append([option.q_ID.q_ID, option.pk, option.option_Value])
        else:
            questionsJSON[option.q_ID.question_text] = [[option.q_ID.q_ID, option.pk, option.option_Value]]
        

    # return HttpResponse(json)
    json['questions'] = questionsJSON
    return render(request, 'ARFA_app/home.html', {'data':json})

def result(request):
    if request.method == 'POST':
        data = dict(request.POST.copy()) #copy to make QueryDict mutable. HttpResponse is immutable
        data.pop('csrfmiddlewaretoken')
        responseObj = Responses()
        responseObj.student_ID = Student.objects.get(username=request.session['username'])
        try:
            responseObj.test_ID = Test.objects.get(test_ID=int(data.pop('testID')[0]))    
        except Test.DoesNotExist as e:
            print "No such test exists"
            print e
            return HttpResponse("No such test exists")

        
        responses = [] #list of response objects to be passed to evaluate
        for q in data:
            responseObj.q_ID = Question.objects.get(q_ID=int(q))
            print data[q]
            data[q] = list(map(lambda x: int(x), data[q]))
            for option in data[q]:
                print "option"
                print option
                responseObj.option_ID = Options.objects.get(pk=int(option))
                responseObj.pk = None
                try:
                    responseObj.save(force_insert=True)
                except IntegrityError as e:
                    print "Integrity error - response not recorded"
                    pass
                print "responses"
            print Responses.objects.all().values()
            responses.append({int(q):data[q]})

        #call evaluate function
        utilities.evaluate(responses, 
        {'username':request.session['username'], 'testID':responseObj.test_ID_id})

        return HttpResponse("Result page should be here")
	
       


def create_question(request):
    return render(request,'ARFA_app/create_question.html',request.session.get('args',None))


def view_personal_question(request):
    if(request.session.get('session',None)!=True):
        return render(request,'ARFA_app/login.html')
    if(request.session.get('role',None)!="faculty"):
        return render(request,'ARFA_app/not_a_faculty.html',request.session.get('args',None))

    args={'username':request.session['username']}
    cursor = connection.cursor()
    cursor.execute(''' SELECT s.subject,q."q_ID" as q_ID,q.question_text,q.topic,q.subtopic,q.source,
        q.difficulty_set,q.image_link,q.visibility,q.ownership,o."option_Value" as option_details,
        o."is_Answer" 
        FROM "ARFA_app_question" as q,
        "ARFA_app_options" as o,"ARFA_app_subject" as s 
        WHERE  q.faculty_id = %s and s."subject_ID" = q."subject_ID_id" and q."q_ID" = o."q_ID_id"
        order by s.subject,q_ID ''',[args['username']])
    rows = cursor.fetchall()
    columns = [col[0] for col in cursor.description]
    res=[]
    options_so_far = []
    preval = []
    first = True
    for val in rows :
        if(first==True):
            first=False
            preval = list(val[:-1])
            options_so_far = [{"option_text":val[-2],"is_answer":val[-1]}]
        else:
            if not(preval[0]==val[0] and preval[1]==val[1]):
                preval[-1] = options_so_far
                preval[1] = "q"+str(preval[1])
                t = dict(zip(columns[:-1], preval))
                res.append(t)
                options_so_far = [{"option_text":val[-2],"is_answer":val[-1]}]
                preval = list(val[:-1])

            else:
                options_so_far.append({"option_text":val[-2],"is_answer":val[-1]})
    if not(first):
        preval[-1] = options_so_far
        preval[1] = "q"+str(preval[1])
        t = dict(zip(columns[:-1], preval))
        res.append(t)
    # return res
    print(res)
    args={'username':request.session['username'],'questions':res}
    args.update(request.session.get('args',None))
    return render(request,'ARFA_app/view_personal_question.html',args)

def view_all_question(request):

    if(request.session.get('session',None)!=True):
        return render(request,'ARFA_app/login.html')
    if(request.session.get('role',None)!="faculty"):
        return render(request,'ARFA_app/not_a_faculty.html')

    res = utilities.get_all_questions(request)
    
    args={'username':request.session['username'],'questions':res}
    args.update(request.session.get('args',None))
    return render(request,'ARFA_app/view_all_question.html',args)


def create_Test(request):
    if(request.session.get('session',None)!=True):
        return render(request,'ARFA_app/login.html')
    if(request.session.get('role',None)!="faculty"):
        return render(request,'ARFA_app/not_a_faculty.html')

    res = utilities.get_all_questions(request)
    test = None

    form = forms.TestForm()
    args={'username':request.session['username'],'questions':res, 'TestForm':TestForm,
    'is_session':True}
    if request.method == "GET":
        return render(request,'ARFA_app/create_Test.html',args)
    if request.method == "POST":
        form = TestForm(request.POST)
        data = dict(request.POST.copy()) #copy to make QueryDict mutable. HttpResponse is immutable
        data.pop('csrfmiddlewaretoken')
        if not data: #only csrf token was sent, display create test page
            return render(request,'ARFA_app/create_Test.html',args)
        

        if form.is_valid():
            test = form.save()
            creator = models.Created_BY(test_ID=test,faculty=models.Faculty.objects.filter(username=request.session['username']).get())
            creator.save()
        else:
            if form.errors:
                for field in form   :
                    print field.errors
            return HttpResponse("Test Form Invalid")

        
        for attr in dir(Test):
            # print attr
            try:
                data.pop(attr)
            except KeyError as e:
                pass
            
        containsObj = models.Contains(test_ID=test)

        for q in data.keys():
            if len(data[q]) != 3:
                continue
            try:

                int(q)
                containsObj.q_ID_id = q
                #data[q] is an array ['True', 'pos_marks', 'neg_marks']

                containsObj.marks_pos = data[q][1]
                containsObj.marks_neg = data[q][2]

                containsObj.pk = None
                containsObj.save()
                print "success"
                print containsObj
            except ValueError as e:
                data.pop(q)
                print e 
                continue

        return render(request,'ARFA_app/view_personal_Test.html',args)


def view_all_Test(request):
    args={'username':request.session['username']}
    return render(request,'ARFA_app/view_all_Test.html',args)



def add_question(request):
    if(request.session.get('session',None)!=True):
        return render(request,'ARFA_app/login.html')
    if(request.session.get('role',None)!="faculty"):
        return render(request,'ARFA_app/not_a_faculty.html',request.session.get('args',None))
    else:

        try:
            question_data = dict(json.loads(request.POST['client_response']))
            
            args = question_data['question_data']
            print args['question_text']
            if args['question_text']=='':
                print 'failed'
                return HttpResponse(json.dumps({'status':'Failed','reason':'No question provided'}))
            

            args['faculty'] = models.Faculty.objects.filter(username=request.session['username']).get()
            options = question_data['options_details']
            args['subject_ID'] = models.Subject.objects.filter(subject_ID = args['subject_ID']).get()
            flag = False
            for i in range(0,len(options)):
                if options[str(i)]['option_Value']:
                    flag = True
                    break
            if not(flag):
                return HttpResponse(json.dumps({'status':'Failed','reason':'No correct option provided'}))
            question = models.Question(**args)
            question.save()
            for i in range(0,len(options)):
                option = models.Options(q_ID=question,option_Value=options[str(i)]['option_Value'],
                    is_Answer=options[str(i)]['is_Answer'],option_ID=options[str(i)]['id'])
                option.save()
            return HttpResponse(json.dumps({'status':'Success'}))
        except:
            return HttpResponse(json.dumps({'status':'Failed','reason':'input/database error'}))


def view_personal_Test(request):
    if(request.session.get('session',None)!=True):
        return render(request,'ARFA_app/login.html')
    if(request.session.get('role',None)!="faculty"):
        return render(request,'ARFA_app/not_a_faculty.html',request.session.get('args',None))

    cursor = connection.cursor()
    cursor.execute(''' SELECT t."test_ID" as test_ID,t.test_name,t.visibility_student,
        t.ownership,t.expected_time_for_completion,t.start_time,t.max_marks
        FROM "ARFA_app_created_by" as c,
        "ARFA_app_test" as t
        WHERE c."test_ID_id" = t."test_ID" and  c.faculty_id = %s
        order by t.start_time desc ''',[request.session['username']])
    rows = cursor.fetchall()
    print rows
    columns = [col[0] for col in cursor.description]
    res = []
    for val in rows:
        res.append(dict(zip(columns,val)))
    args={'username':request.session['username'],'tests':res}
    return render(request,'ARFA_app/view_personal_Test.html',args)




