# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.core.validators import MinLengthValidator

# Create your models here.

class arfa_user(models.Model):
	name = models.CharField(max_length=200)
	phone_number = models.CharField(max_length=10)
	email_ID = models.CharField(max_length=200)
	address = models.CharField(max_length=400)
	username = models.CharField(max_length=200,primary_key=True)
	password = models.CharField(max_length=200,validators=[MinLengthValidator(4)])

	class Meta:
		abstract=True

class Student(arfa_user):
	Standard=models.IntegerField(default=12)

class Faculty(arfa_user):
	salary= models.IntegerField(default=0)
	subject_ID = models.ForeignKey('Subject', on_delete=models.CASCADE,default="M")

class Test(models.Model):
	test_ID = models.AutoField(primary_key=True)
	test_name = models.CharField(max_length=200,unique=True)
	visibility_student = models.CharField(max_length=20)
	ownership = models.CharField(max_length=20)
	expected_time_for_completion = models.CharField(max_length=10)
	start_time = models.CharField(max_length=10)
	max_marks = models.IntegerField(null=True)

# class TestQuestions(models.Model):
# 	test_ID = models.ForeignKey(
# 		'Test', on_delete=models.CASCADE)
# 	q_ID = models.ForeignKey(
# 		'Question', on_delete=models.CASCADE)


class Subject(models.Model):
	subject_ID = models.CharField(max_length=20,primary_key=True)
	subject = models.CharField(max_length=20)

class Responses(models.Model):
	student_ID = models.ForeignKey(
		'Student', on_delete=models.CASCADE)

	test_ID = models.ForeignKey(
		'Test', on_delete=models.CASCADE)

	q_ID = models.ForeignKey(
		'Question', on_delete=models.CASCADE)

	option_ID = models.ForeignKey(
		'Options', on_delete=models.CASCADE)

	Response_value = models.BooleanField(default=False)

	class Meta:
		unique_together = (("student_ID", "test_ID", "q_ID", "option_ID"),)

class Options(models.Model):
	q_ID = models.ForeignKey(
		'Question', on_delete=models.CASCADE)
	option_ID = models.IntegerField()
	option_Value = models.CharField(max_length=1000)
	is_Answer = models.BooleanField(default=False)

	class Meta:
		unique_together = (("q_ID", "option_ID"),)


#marks??
class Question(models.Model):
	q_ID = models.AutoField(primary_key=True)
	subject_ID = models.ForeignKey('Subject', on_delete=models.CASCADE,default="M")
	faculty = models.ForeignKey('Faculty',models.SET_NULL,blank=True,null=True)
	topic = models.CharField(max_length=20)
	subtopic = models.CharField(max_length=20)
	time_stamp = models.DateTimeField(auto_now=True)
	source = models.CharField(max_length=200)
	difficulty_set = models.CharField(max_length=20)
	difficulty_observed = models.CharField(max_length=20)
	question_text = models.CharField(max_length=1000)
	image_link = models.CharField(max_length=200) 
	num_appeared = models.IntegerField
	num_correct = models.IntegerField
	visibility = models.CharField(max_length=20)
	ownership = models.CharField(max_length=20)




class Takes(models.Model):
	student = models.ForeignKey('Student',models.SET_NULL,blank=True,null=True)
	test_ID = models.ForeignKey('Test',models.SET_NULL,blank=True,null=True)
	time_stamp = models.DateTimeField(auto_now=True)
	total_marks = models.FloatField(null=True)
	rank = models.IntegerField(default=0)

	class Meta:
		unique_together = (('student', 'test_ID'))

class Created_BY(models.Model):
	test_ID = models.ForeignKey('Test',models.SET_NULL,blank=True,null=True)
	faculty = models.ForeignKey('Faculty',models.SET_NULL,blank=True,null=True)

	class Meta:
		unique_together = (('faculty', 'test_ID'))

class Contains(models.Model):
	test_ID = models.ForeignKey('Test',models.SET_NULL,blank=True,null=True)
	q_ID  = models.ForeignKey('Question',models.SET_NULL,blank=True,null=True)	
	marks_pos =  models.FloatField(null=True)
	marks_neg = models.FloatField(null=True)

	class Meta:
		unique_together = (('q_ID', 'test_ID'))


#rewrite this. Redundant storage of student and test for each question
# class Evaluation(models.Model):
# 	student = models.ForeignKey('Student',models.SET_NULL,blank=True,null=True)
# 	test_ID = models.ForeignKey('Test',models.SET_NULL,blank=True,null=True)
# 	q_ID = models.ForeignKey('Question',models.SET_NULL,blank=True,null=True)
# 	marks = models.FloatField(null=True)

# 	class Meta:
# 		unique_together = (('student', 'test_ID', 'q_ID'))

class Evaluation(models.Model):
    # attempt = models.ForeignKey('TestAttempt', models.SET_NULL,blank=True,null=True)
	student = models.ForeignKey('Student',models.SET_NULL,blank=True,null=True)
	test_ID = models.ForeignKey('Test',models.SET_NULL,blank=True,null=True)
	q_ID = models.ForeignKey('Question',models.SET_NULL,blank=True,null=True)
	marks = models.FloatField(null=True)

	class Meta:
		unique_together = (('student', 'test_ID', 'q_ID'))

# class TestAttempt(models.Model):
# 	attemptID = models.AutoField(primary_key = True)
# 	student = models.ForeignKey('Student',models.SET_NULL,blank=True,null=True)
# 	test = models.ForeignKey('Test',models.SET_NULL,blank=True,null=True)

class ContactUs(models.Model):
	name = models.CharField(max_length=200)
	phone_number = models.CharField(max_length=10)
	email_ID=models.CharField(max_length=200)
	text = models.CharField(max_length=200)
	
