# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2018-11-24 13:16
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ContactUs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('phone_number', models.CharField(max_length=10)),
                ('email_ID', models.CharField(max_length=200)),
                ('text', models.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name='Contains',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('marks_pos', models.FloatField(null=True)),
                ('marks_neg', models.FloatField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Created_BY',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='Evaluation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('marks', models.FloatField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Faculty',
            fields=[
                ('name', models.CharField(max_length=200)),
                ('phone_number', models.CharField(max_length=10)),
                ('email_ID', models.CharField(max_length=200)),
                ('address', models.CharField(max_length=400)),
                ('username', models.CharField(max_length=200, primary_key=True, serialize=False)),
                ('password', models.CharField(max_length=200, validators=[django.core.validators.MinLengthValidator(4)])),
                ('salary', models.IntegerField(default=0)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Options',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('option_ID', models.IntegerField()),
                ('option_Value', models.CharField(max_length=1000)),
                ('is_Answer', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('q_ID', models.AutoField(primary_key=True, serialize=False)),
                ('topic', models.CharField(max_length=20)),
                ('subtopic', models.CharField(max_length=20)),
                ('time_stamp', models.DateTimeField(auto_now=True)),
                ('source', models.CharField(max_length=200)),
                ('difficulty_set', models.CharField(max_length=20)),
                ('difficulty_observed', models.CharField(max_length=20)),
                ('question_text', models.CharField(max_length=1000)),
                ('image_link', models.CharField(max_length=200)),
                ('visibility', models.CharField(max_length=20)),
                ('ownership', models.CharField(max_length=20)),
                ('faculty', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Faculty')),
            ],
        ),
        migrations.CreateModel(
            name='Responses',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('Response_value', models.BooleanField(default=False)),
                ('option_ID', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Options')),
                ('q_ID', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Question')),
            ],
        ),
        migrations.CreateModel(
            name='Student',
            fields=[
                ('name', models.CharField(max_length=200)),
                ('phone_number', models.CharField(max_length=10)),
                ('email_ID', models.CharField(max_length=200)),
                ('address', models.CharField(max_length=400)),
                ('username', models.CharField(max_length=200, primary_key=True, serialize=False)),
                ('password', models.CharField(max_length=200, validators=[django.core.validators.MinLengthValidator(4)])),
                ('Standard', models.IntegerField(default=12)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('subject_ID', models.CharField(max_length=20, primary_key=True, serialize=False)),
                ('subject', models.CharField(max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='Takes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('time_stamp', models.DateTimeField(auto_now=True)),
                ('total_marks', models.FloatField(null=True)),
                ('rank', models.IntegerField(default=0)),
                ('student', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Student')),
            ],
        ),
        migrations.CreateModel(
            name='Test',
            fields=[
                ('test_ID', models.AutoField(primary_key=True, serialize=False)),
                ('test_name', models.CharField(max_length=200, unique=True)),
                ('visibility_student', models.CharField(max_length=20)),
                ('ownership', models.CharField(max_length=20)),
                ('expected_time_for_completion', models.DurationField(blank=True)),
                ('start_time', models.DateTimeField()),
                ('max_marks', models.FloatField(null=True)),
            ],
        ),
        migrations.AddField(
            model_name='takes',
            name='test_ID',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Test'),
        ),
        migrations.AddField(
            model_name='responses',
            name='student_ID',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Student'),
        ),
        migrations.AddField(
            model_name='responses',
            name='test_ID',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Test'),
        ),
        migrations.AddField(
            model_name='question',
            name='subject_ID',
            field=models.ForeignKey(default='M', on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Subject'),
        ),
        migrations.AddField(
            model_name='options',
            name='q_ID',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Question'),
        ),
        migrations.AddField(
            model_name='faculty',
            name='subject_ID',
            field=models.ForeignKey(default='M', on_delete=django.db.models.deletion.CASCADE, to='ARFA_app.Subject'),
        ),
        migrations.AddField(
            model_name='evaluation',
            name='q_ID',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Question'),
        ),
        migrations.AddField(
            model_name='evaluation',
            name='student',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Student'),
        ),
        migrations.AddField(
            model_name='evaluation',
            name='test_ID',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Test'),
        ),
        migrations.AddField(
            model_name='created_by',
            name='faculty',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Faculty'),
        ),
        migrations.AddField(
            model_name='created_by',
            name='test_ID',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Test'),
        ),
        migrations.AddField(
            model_name='contains',
            name='q_ID',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Question'),
        ),
        migrations.AddField(
            model_name='contains',
            name='test_ID',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ARFA_app.Test'),
        ),
        migrations.AlterUniqueTogether(
            name='takes',
            unique_together=set([('student', 'test_ID')]),
        ),
        migrations.AlterUniqueTogether(
            name='responses',
            unique_together=set([('student_ID', 'test_ID', 'q_ID', 'option_ID')]),
        ),
        migrations.AlterUniqueTogether(
            name='options',
            unique_together=set([('q_ID', 'option_ID')]),
        ),
        migrations.AlterUniqueTogether(
            name='evaluation',
            unique_together=set([('student', 'test_ID', 'q_ID')]),
        ),
        migrations.AlterUniqueTogether(
            name='created_by',
            unique_together=set([('faculty', 'test_ID')]),
        ),
        migrations.AlterUniqueTogether(
            name='contains',
            unique_together=set([('q_ID', 'test_ID')]),
        ),
    ]
